/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.cytoscape.model.CyDisposable;

public class OrderedMouseAdapter
implements MouseListener,
MouseMotionListener,
CyDisposable {
    private final List<MouseAdapter> listeners = new ArrayList<MouseAdapter>();

    public OrderedMouseAdapter(MouseAdapter ... adapters) {
        for (MouseAdapter a : adapters) {
            this.add(a);
        }
    }

    public void add(MouseAdapter mouseAdapter) {
        this.listeners.add(mouseAdapter);
    }

    public <T> T get(Class<T> type) {
        for (MouseAdapter l : this.listeners) {
            if (!type.isAssignableFrom(l.getClass())) continue;
            return type.cast(l);
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseDragged);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseMoved);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseClicked);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fire(e, MouseAdapter::mousePressed);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseReleased);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseEntered);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.fire(e, MouseAdapter::mouseExited);
    }

    private void fire(MouseEvent e, BiConsumer<MouseAdapter, MouseEvent> consumer) {
        for (MouseAdapter l : this.listeners) {
            if (e.isConsumed()) {
                return;
            }
            consumer.accept(l, e);
        }
    }

    public void dispose() {
        this.listeners.clear();
    }
}

