/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class MathUtil {
    private static final double EPSILON = 1.0E-30;

    private MathUtil() {
    }

    public static double invLinearInterp(double x, double min, double max) {
        double denom = max - min;
        return denom < 1.0E-30 && denom > -1.0E-30 ? 0.0 : (x - min) / denom;
    }

    public static double linearInterp(double f, double min, double max) {
        return min + f * (max - min);
    }

    public static double logInterp(double f, double min, double max, double b) {
        f = (min = MathUtil.symLog(min, b)) + f * ((max = MathUtil.symLog(max, b)) - min);
        return f < 0.0 ? -Math.pow(b, -f) : Math.pow(b, f);
    }

    public static double invLogInterp(double x, double min, double max, double b) {
        min = MathUtil.symLog(min, b);
        double denom = MathUtil.symLog(max, b) - min;
        return denom < 1.0E-30 && denom > -1.0E-30 ? 0.0 : (MathUtil.symLog(x, b) - min) / denom;
    }

    public static double symLog(double x, double b) {
        return x == 0.0 ? 0.0 : (x > 0.0 ? MathUtil.log(x, b) : -MathUtil.log(-x, b));
    }

    public static double log(double x, double b) {
        return Math.log(x) / Math.log(b);
    }

    public static int findNearestNumber(int[] numbers, int target) {
        int minDiff = Integer.MAX_VALUE;
        int nearest = 0;
        for (int n : numbers) {
            int diff = Math.abs(n - target);
            if (diff >= minDiff) continue;
            minDiff = diff;
            nearest = n;
        }
        return nearest;
    }

    public static float findNearestNumber(float[] numbers, float target) {
        float minDiff = Float.MAX_VALUE;
        float nearest = 0.0f;
        for (float n : numbers) {
            float diff = Math.abs(n - target);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            nearest = n;
        }
        return nearest;
    }

    public static Point2D getIntersectionPoint(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        return MathUtil.getIntersectionPoint(new Line2D.Double(p1, p2), new Line2D.Double(p3, p4));
    }

    public static Point2D getIntersectionPoint(Line2D lineA, Line2D lineB) {
        double a1x = lineA.getX1();
        double a1y = lineA.getY1();
        double a2x = lineA.getX2();
        double a2y = lineA.getY2();
        double b1x = lineB.getX1();
        double b1y = lineB.getY1();
        double b2x = lineB.getX2();
        double b2y = lineB.getY2();
        Point2D.Double p = null;
        double d = (b2y - b1y) * (a2x - a1x) - (b2x - b1x) * (a2y - a1y);
        if (d != 0.0) {
            double ua = ((b2x - b1x) * (a1y - b1y) - (b2y - b1y) * (a1x - b1x)) / d;
            double ub = ((a2x - a1x) * (a1y - b1y) - (a2y - a1y) * (a1x - b1x)) / d;
            if (0.0 <= ua && ua <= 1.0 && 0.0 <= ub && ub <= 1.0) {
                double xi = a1x + ua * (a2x - a1x);
                double yi = a1y + ua * (a2y - a1y);
                p = new Point2D.Double(xi, yi);
            }
        }
        return p;
    }

    public static Point2D[] getIntersectionPoints(Line2D line, Rectangle2D rect) {
        Point2D[] p = new Point2D[]{MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY() + rect.getHeight(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY(), rect.getX(), rect.getY() + rect.getHeight())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX() + rect.getWidth(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()))};
        return p;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static int getQuadrant(double angle) {
        return (int)(MathUtil.normalizeAngle(angle) / 90.0) % 4 + 1;
    }

    public static double normalizeAngle(double angle) {
        return angle + Math.ceil(-angle / 360.0) * 360.0;
    }

    public static Line2D rotate(Line2D line, double angle, double anchorx, double anchory) {
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchorx, anchory);
        Point2D p1 = at.transform(line.getP1(), new Point2D.Double());
        Point2D p2 = at.transform(line.getP2(), new Point2D.Double());
        return new Line2D.Double(p1, p2);
    }

    public static double scaleToFit(double w1, double h1, double w2, double h2) {
        double fw = 0.0;
        double fh = 0.0;
        if (w1 > 0.0) {
            fw = w2 / w1;
        }
        if (h1 > 0.0) {
            fh = h2 / h1;
        }
        return Math.min(fw, fh);
    }

    public static Point2D convertCoordinate(Point2D cp, Rectangle ob, Rectangle nb) {
        double cx = cp.getX();
        double cy = cp.getY();
        double xlo = ob.getMinX();
        double ylo = ob.getMinY();
        double xho = ob.getMaxX();
        double yho = ob.getMaxY();
        double xln = nb.getMinX();
        double yln = nb.getMinY();
        double xhn = nb.getMaxX();
        double yhn = nb.getMaxY();
        double xro = xho - xlo;
        double xrn = xhn - xln;
        double x = xln + (cx - xlo) * xrn / xro;
        double yro = yho - ylo;
        double yrn = yhn - yln;
        double y = yln + (cy - ylo) * yrn / yro;
        Point2D.Double np = new Point2D.Double(x, y);
        return np;
    }

    public static double getGradientAngle(LinearGradientPaint paint) {
        Point2D sp = paint.getStartPoint();
        Point2D ep = paint.getEndPoint();
        Point2D.Double p1 = new Point2D.Double(sp.getX(), sp.getY());
        Point2D.Double p2 = new Point2D.Double(ep.getX(), ep.getY());
        return MathUtil.getGradientAngle(p1, p2);
    }

    public static double getGradientAngle(Point2D.Double p1, Point2D.Double p2) {
        double angle = Math.toDegrees(Math.atan2(p2.y - p1.y, p2.x - p1.x)) * -1.0;
        angle = MathUtil.normalizeAngle(angle);
        return angle;
    }

    public static Line2D getGradientAxis(Rectangle2D bounds, double angle) {
        Point2D start = null;
        Point2D end = null;
        double x1 = bounds.getMinX();
        double y1 = bounds.getMinY();
        double x2 = bounds.getMaxX();
        double y2 = bounds.getMaxY();
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        if (angle == 0.0) {
            start = new Point2D.Double(x1, cy);
            end = new Point2D.Double(x2, cy);
        } else if (angle == 90.0) {
            start = new Point2D.Double(cx, y2);
            end = new Point2D.Double(cx, y1);
        } else if (angle == 180.0) {
            start = new Point2D.Double(x2, cy);
            end = new Point2D.Double(x1, cy);
        } else if (angle == 270.0) {
            start = new Point2D.Double(cx, y1);
            end = new Point2D.Double(cx, y2);
        } else {
            double d = Math.max(bounds.getWidth(), bounds.getHeight());
            Line2D gl = new Line2D.Double(cx - d, cy, cx + d, cy);
            gl = MathUtil.rotate(gl, -angle, cx, cy);
            int q = MathUtil.getQuadrant(angle);
            Line2D pl1 = new Line2D.Double(x1, cy - d, x1, cy + d);
            double ax = x1;
            double ay = q == 1 || q == 3 ? y2 : y1;
            pl1 = MathUtil.rotate(pl1, -angle, ax, ay);
            Line2D pl2 = new Line2D.Double(x2, cy - d, x2, cy + d);
            ax = x2;
            ay = q == 1 || q == 3 ? y1 : y2;
            pl2 = MathUtil.rotate(pl2, -angle, ax, ay);
            start = MathUtil.getIntersectionPoint(gl, q == 1 || q == 4 ? pl1 : pl2);
            end = MathUtil.getIntersectionPoint(gl, q == 1 || q == 4 ? pl2 : pl1);
        }
        return new Line2D.Double(start, end);
    }
}

