/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.cytoscape.ding.impl.strokes.ShapeStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class PipeStroke
extends ShapeStroke {
    private Type offsetType;

    PipeStroke(float width, Type offsetType) {
        super(new Shape[]{PipeStroke.getShape(width, offsetType)}, width, width);
        this.offsetType = offsetType;
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        return new PipeStroke(w, this.offsetType);
    }

    private static Shape getShape(float input, Type offsetType) {
        GeneralPath shape = new GeneralPath();
        float height = input;
        float width = input / 5.0f;
        float offset = offsetType.adjust(input);
        shape.moveTo(0.0f, -height);
        shape.lineTo(width, -height);
        shape.lineTo(width + offset, height);
        shape.lineTo(0.0f + offset, height);
        shape.lineTo(0.0f, -height);
        return shape;
    }

    public static enum Type {
        VERTICAL(0.0f),
        FORWARD(-1.0f),
        BACKWARD(1.0f);

        private float adjust;

        private Type(float adjust) {
            this.adjust = adjust;
        }

        public float adjust(float input) {
            return this.adjust * input;
        }
    }
}

