/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.BasicStroke;
import org.cytoscape.ding.impl.strokes.DAnimatedStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class AnimatedEqualDashStroke
extends BasicStroke
implements DAnimatedStroke {
    private final float width;
    private final float offset;

    public AnimatedEqualDashStroke(float width) {
        this(width, 100000.0f);
    }

    private AnimatedEqualDashStroke(float width, float offset) {
        super(width, 0, 0, 10.0f, new float[]{width * 2.0f, width * 2.0f}, width * 4.0f * offset);
        this.width = width;
        this.offset = offset;
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        if (this.offset >= 0.0f) {
            return new AnimatedEqualDashStroke(w, this.offset);
        }
        return new AnimatedEqualDashStroke(w);
    }

    @Override
    public AnimatedEqualDashStroke newInstanceForNextOffset() {
        return new AnimatedEqualDashStroke(this.width, DAnimatedStroke.nextOffset(this.offset));
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.width;
    }
}

