/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualProperty;

public class ViewUtils {
    public static String serialize(Paint paint) {
        if (paint == null) {
            return null;
        }
        if (paint instanceof LinearGradientPaint) {
            Object lg = "lingrad(";
            LinearGradientPaint lingrad = (LinearGradientPaint)paint;
            Point2D start = lingrad.getStartPoint();
            Point2D end = lingrad.getEndPoint();
            lg = (String)lg + ViewUtils.serialize(start) + ";";
            lg = (String)lg + ViewUtils.serialize(end) + ";";
            float[] fractions = lingrad.getFractions();
            Color[] colors = lingrad.getColors();
            lg = (String)lg + ViewUtils.serialize(fractions, colors) + ")";
            return lg;
        }
        if (paint instanceof RadialGradientPaint) {
            Object rg = "radgrad(";
            RadialGradientPaint radgrad = (RadialGradientPaint)paint;
            Point2D center = radgrad.getCenterPoint();
            Point2D focus = radgrad.getFocusPoint();
            float radius = radgrad.getRadius();
            rg = (String)rg + ViewUtils.serialize(center) + ";";
            rg = (String)rg + ViewUtils.serialize(focus) + ";";
            rg = (String)rg + radius + ";";
            float[] fractions = radgrad.getFractions();
            Color[] colors = radgrad.getColors();
            rg = (String)rg + ViewUtils.serialize(fractions, colors) + ")";
            return rg;
        }
        if (paint instanceof Color) {
            return Integer.toString(((Color)paint).getRGB());
        }
        return paint.toString();
    }

    public static String serialize(Point2D point) {
        return point == null ? "" : point.getX() + "," + point.getY();
    }

    public static String serialize(float[] fractions, Color[] colors) {
        Object stops = null;
        for (int i = 0; i < fractions.length; ++i) {
            stops = stops != null ? stops + ";" : "";
            stops = (String)stops + fractions[i] + "," + Integer.toString(colors[i].getRGB());
        }
        return stops;
    }

    public static Paint getColor(String strColor) {
        if (strColor == null) {
            return null;
        }
        if (strColor.startsWith("lingrad")) {
            String[] tokens = strColor.split("[(;)]");
            Point2D start = ViewUtils.getPoint2D(tokens[1]);
            Point2D end = ViewUtils.getPoint2D(tokens[2]);
            float[] fractions = new float[tokens.length - 3];
            Color[] colors = new Color[tokens.length - 3];
            ViewUtils.getStops(tokens, 3, fractions, colors);
            return new LinearGradientPaint(start, end, fractions, colors);
        }
        if (strColor.startsWith("radgrad")) {
            String[] tokens = strColor.split("[(;)]");
            Point2D center = ViewUtils.getPoint2D(tokens[1]);
            Point2D focus = ViewUtils.getPoint2D(tokens[2]);
            float radius = ViewUtils.getFloat(tokens[3]).floatValue();
            float[] fractions = new float[tokens.length - 4];
            Color[] colors = new Color[tokens.length - 4];
            ViewUtils.getStops(tokens, 4, fractions, colors);
            MultipleGradientPaint.CycleMethod method = MultipleGradientPaint.CycleMethod.NO_CYCLE;
            return new RadialGradientPaint(center, radius, focus, fractions, colors, method);
        }
        if (strColor.startsWith("#")) {
            String hex = strColor.substring(1);
            int clr = Integer.parseInt(hex, 16);
            return new Color(clr);
        }
        return new Color(Integer.parseInt(strColor), true);
    }

    public static Paint getColor(Map<String, String> argMap, String key, Color defValue) {
        if (argMap.get(key) == null) {
            return defValue;
        }
        return ViewUtils.getColor(argMap.get(key));
    }

    public static void getStops(String[] tokens, int stopStart, float[] fractions, Color[] colors) {
        for (int i = stopStart; i < tokens.length; ++i) {
            String[] stop = tokens[i].split(",");
            fractions[i - stopStart] = ViewUtils.getFloat(stop[0]).floatValue();
            colors[i - stopStart] = new Color(Integer.parseInt(stop[1]), true);
        }
    }

    public static Point2D getPoint2D(String point) {
        if (point.length() == 0) {
            return null;
        }
        String[] xy = point.split(",");
        return new Point2D.Double(ViewUtils.getDouble(xy[0]), ViewUtils.getDouble(xy[1]));
    }

    public static String getString(Map<String, String> argMap, String key, String defValue) {
        if (argMap.get(key) == null) {
            return defValue;
        }
        try {
            return argMap.get(key);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static Float getFloat(String fValue) {
        return Float.valueOf(Float.parseFloat(fValue));
    }

    public static Float getFloat(Map<String, String> argMap, String key, float defValue) {
        if (argMap.get(key) == null) {
            return Float.valueOf(defValue);
        }
        try {
            return Float.valueOf(Float.parseFloat(argMap.get(key)));
        }
        catch (Exception e) {
            return Float.valueOf(defValue);
        }
    }

    public static Integer getInteger(Map<String, String> argMap, String key, int defValue) {
        if (argMap.get(key) == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(argMap.get(key));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static Double getDouble(String dValue) {
        return Double.parseDouble(dValue);
    }

    public static Double getDouble(Map<String, String> argMap, String key, double defValue) {
        if (argMap.get(key) == null) {
            return defValue;
        }
        try {
            return Double.parseDouble(argMap.get(key));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static Font getArgFont(Map<String, String> argMap, String defFamily, int defStyle, int defSize) {
        String family = ViewUtils.getString(argMap, "fontFamily", defFamily);
        int size = ViewUtils.getInteger(argMap, "fontSize", defSize);
        int style = ViewUtils.getInteger(argMap, "fontStyle", defStyle);
        return new Font(family, style, size);
    }

    public static void addNodeCoordinates(DRenderingEngine re, Map<String, String> argMap, double x, double y) {
        Point2D xy = re.getTransform().getNodeCoordinates((int)x, (int)y);
        argMap.put("x", Double.toString(xy.getX()));
        argMap.put("y", Double.toString(xy.getY()));
    }

    public static Point2D getComponentCoordinates(DRenderingEngine re, Map<String, String> argMap) {
        double[] nextLocn = new double[]{0.0, 0.0};
        if (argMap.containsKey("x")) {
            nextLocn[0] = Double.parseDouble(argMap.get("x"));
        }
        if (argMap.containsKey("y")) {
            nextLocn[1] = Double.parseDouble(argMap.get("y"));
        }
        re.getTransform().xformNodeToImageCoords(nextLocn);
        return new Point2D.Double(nextLocn[0], nextLocn[1]);
    }

    public static void selectAnnotation(DRenderingEngine re, DingAnnotation annotation) {
        CyNetworkView view;
        DVisualLexicon lexicon = re.getVisualLexicon();
        VisualProperty vp = lexicon.lookup(CyNetwork.class, "NETWORK_ANNOTATION_SELECTION");
        if (vp != null && !Boolean.TRUE.equals((view = re.getViewModel()).getVisualProperty(vp))) {
            view.setLockedValue(vp, (Object)Boolean.TRUE);
        }
        annotation.setSelected(true);
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        cyAnnotator.addAnnotation(annotation);
        cyAnnotator.setSelectedAnnotation(annotation, true);
    }

    public static void reorder(List<DingAnnotation> annotations, AnnotationTree.Shift shift, DRenderingEngine re) {
        List<DingAnnotation> bga;
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        AnnotationTree tree = cyAnnotator.getAnnotationTree();
        Map<String, List<DingAnnotation>> byCanvas = annotations.stream().collect(Collectors.groupingBy(DingAnnotation::getCanvasName));
        List<DingAnnotation> fga = byCanvas.get("foreground");
        if (fga != null && !fga.isEmpty()) {
            tree.shift(shift, "foreground", fga);
        }
        if ((bga = byCanvas.get("background")) != null && !bga.isEmpty()) {
            tree.shift(shift, "background", bga);
        }
        tree.resetZOrder();
        re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
    }

    public static void styleWindowStateButton(AbstractButton btn) {
        int size = 16;
        btn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        btn.setMinimumSize(new Dimension(16, 16));
        btn.setPreferredSize(new Dimension(16, 16));
        btn.setSize(new Dimension(16, 16));
        btn.setRolloverEnabled(false);
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setContentAreaFilled(false);
    }

    public static void styleEditorButtons(AbstractButton ... buttons) {
        for (AbstractButton btn : buttons) {
            btn.putClientProperty("JButton.buttonType", "gradient");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{btn});
        }
    }
}

