/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.ding.impl.cyannotator.utils.DoubleInputVerifier;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.ding.internal.util.MathUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class PointPicker
extends JPanel {
    public static final Point2D DEFAULT_VALUE = new Point2D.Double(0.5, 0.5);
    private static final float[] MAIN_XY = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f};
    private Color borderColor = UIManager.getColor("CyComponent.borderColor");
    private Color color1 = UIManager.getColor("Label.foreground");
    private Color color2 = UIManager.getColor("Table.background");
    private Stroke defStroke = new BasicStroke(1.0f);
    private Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    private int size;
    private float fieldWidth;
    private float fieldHeight;
    private float fieldX;
    private float fieldY;
    private float fieldCenterX;
    private float fieldCenterY;
    private float targetSize;
    private Point2D value;
    private Point2D position = new Point2D.Double();
    private JPanel canvas;
    private JLabel xLbl;
    private JTextField xTxt;
    private JLabel yLbl;
    private JTextField yTxt;
    private JButton resetBtn;
    private float[] fractions;
    private Color[] colors;
    private boolean shiftDown;
    private final CyServiceRegistrar serviceRegistrar;

    public PointPicker(int size, int targetSize, CyServiceRegistrar serviceRegistrar) {
        this(size, targetSize, DEFAULT_VALUE, serviceRegistrar);
    }

    public PointPicker(int size, int targetSize, Point2D value, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        if (value == null) {
            value = DEFAULT_VALUE;
        }
        float EXTRA_PADDING = 2.0f;
        this.value = value;
        this.size = size;
        this.targetSize = targetSize;
        this.fieldHeight = this.fieldWidth = (float)(size - targetSize) - 4.0f;
        this.fieldX = (float)(targetSize / 2) + 2.0f;
        this.fieldY = (float)(targetSize / 2) + 2.0f;
        this.fieldCenterX = this.fieldX + this.fieldWidth / 2.0f;
        this.fieldCenterY = this.fieldY + this.fieldHeight / 2.0f;
        this.position = this.convertToPosition((Point2D)value.clone());
        this.init();
        this.updateTextFields();
    }

    public Point2D getValue() {
        return (Point2D)this.value.clone();
    }

    public void setValue(Point2D value) {
        if (!this.value.equals(value)) {
            Point2D oldValue = this.value;
            this.value = value;
            Point2D p = this.convertToPosition((Point2D)value.clone());
            this.moveTarget(p.getX(), p.getY(), false);
            this.updateTextFields();
            this.firePropertyChange("value", oldValue, value);
        }
    }

    public void update(float[] fractions, Color[] colors) {
        this.fractions = fractions;
        this.colors = colors;
        this.repaint();
    }

    private void init() {
        this.xLbl = new JLabel("x:");
        this.yLbl = new JLabel("y:");
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getCanvas(), -2, -1, -2).addGap(4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getResetBtn(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.xLbl).addComponent(this.getXTxt())).addGroup(layout.createSequentialGroup().addComponent(this.yLbl).addComponent(this.getYTxt()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getCanvas()).addGroup(layout.createSequentialGroup().addComponent(this.getResetBtn(), -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.xLbl).addComponent(this.getXTxt(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.yLbl).addComponent(this.getYTxt(), -2, -1, -2))));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.xLbl, this.yLbl, this.getXTxt(), this.getYTxt()});
        ViewUtils.styleEditorButtons(this.getResetBtn());
    }

    private JPanel getCanvas() {
        if (this.canvas == null) {
            this.canvas = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    PointPicker.this.paintCanvas(g);
                }
            };
            this.canvas.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.canvas.setMinimumSize(new Dimension(this.size, this.size));
            this.canvas.setPreferredSize(new Dimension(this.size, this.size));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PointPicker.this.mouseCheck(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PointPicker.this.mouseCheck(e);
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        PointPicker.this.setValue(PointPicker.this.convertToValue(PointPicker.this.position));
                    }
                    PointPicker.this.shiftDown = false;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    PointPicker.this.shiftDown = false;
                    PointPicker.this.mouseCheck(e);
                }
            };
            this.canvas.addMouseMotionListener(mouseAdapter);
            this.canvas.addMouseListener(mouseAdapter);
        }
        return this.canvas;
    }

    private JTextField getXTxt() {
        if (this.xTxt == null) {
            this.xTxt = new JTextField();
            this.xTxt.setInputVerifier(new DoubleInputVerifier());
            this.xTxt.setMinimumSize(new Dimension(60, this.xTxt.getMinimumSize().height));
            this.xTxt.setHorizontalAlignment(11);
            this.xTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PointPicker.this.onTextFieldUpdated();
                }
            });
        }
        return this.xTxt;
    }

    private JTextField getYTxt() {
        if (this.yTxt == null) {
            this.yTxt = new JTextField();
            this.yTxt.setInputVerifier(new DoubleInputVerifier());
            this.yTxt.setMinimumSize(new Dimension(60, this.yTxt.getMinimumSize().height));
            this.yTxt.setHorizontalAlignment(11);
            this.yTxt.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PointPicker.this.onTextFieldUpdated();
                }
            });
        }
        return this.yTxt;
    }

    private JButton getResetBtn() {
        if (this.resetBtn == null) {
            this.resetBtn = new JButton("\uf021");
            this.resetBtn.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
            this.resetBtn.setToolTipText("Reset");
            this.resetBtn.addActionListener(evt -> this.setValue(DEFAULT_VALUE));
            if (LookAndFeelUtil.isAquaLAF()) {
                this.resetBtn.putClientProperty("JButton.buttonType", "gradient");
            }
        }
        return this.resetBtn;
    }

    private void mouseCheck(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            this.shiftDown = evt.isShiftDown();
            this.moveTarget(evt.getX(), evt.getY(), this.shiftDown);
        }
    }

    private void moveTarget(double x, double y, boolean snap) {
        Line2D.Double line = new Line2D.Double(this.fieldCenterX, this.fieldCenterY, x, y);
        Point2D[] ips = MathUtil.getIntersectionPoints(line, new Rectangle2D.Float(this.fieldX, this.fieldY, this.fieldWidth, this.fieldHeight));
        Point2D ip = null;
        for (Point2D p : ips) {
            if (p == null) continue;
            ip = p;
            break;
        }
        if (ip != null) {
            x = ip.getX();
            y = ip.getY();
        }
        if (snap) {
            x = this.fieldX + MathUtil.findNearestNumber(MAIN_XY, (float)(x / (double)this.fieldWidth)) * this.fieldWidth;
            y = this.fieldY + MathUtil.findNearestNumber(MAIN_XY, (float)(y / (double)this.fieldHeight)) * this.fieldHeight;
        }
        this.position.setLocation(x, y);
        SwingUtilities.getRoot(this).repaint();
        this.updateTextFields();
    }

    private void updateTextFields() {
        Point2D value = this.convertToValue(this.position);
        this.getXTxt().setText("" + (double)Math.round(value.getX() * 100.0) / 100.0);
        this.getYTxt().setText("" + (double)Math.round(value.getY() * 100.0) / 100.0);
    }

    private void onTextFieldUpdated() {
        try {
            double y;
            double x = Double.parseDouble(this.getXTxt().getText());
            if (x < 0.0) {
                x = 0.0;
            }
            if (x > 1.0) {
                x = 1.0;
            }
            if ((y = Double.parseDouble(this.getYTxt().getText())) < 0.0) {
                y = 0.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            this.setValue(new Point2D.Double(x, y));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Point2D convertToValue(Point2D position) {
        return new Point2D.Double((position.getX() - (double)this.fieldX) / (double)this.fieldWidth, (position.getY() - (double)this.fieldY) / (double)this.fieldHeight);
    }

    private Point2D convertToPosition(Point2D value) {
        return new Point2D.Double(value.getX() * (double)this.fieldWidth + (double)this.fieldX, value.getY() * (double)this.fieldHeight + (double)this.fieldY);
    }

    protected void paintCanvas(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (int)this.fieldX;
        int y = (int)this.fieldY;
        int w = (int)this.fieldWidth;
        int h = (int)this.fieldHeight;
        if (this.fractions != null && this.fractions.length > 0 && this.colors != null && this.colors.length > 0) {
            float cx = (float)this.position.getX();
            float cy = (float)this.position.getY();
            RadialGradientPaint newPaint = new RadialGradientPaint(cx, cy, Math.max(w, h), this.fractions, this.colors);
            g2.setPaint(newPaint);
            g2.fillRect(x, y, w, h);
        } else {
            g2.setColor(UIManager.getColor("Panel.background"));
            g2.fillRect(x, y, w, h);
        }
        if (this.shiftDown) {
            g2.setStroke(this.dashedStroke);
            g2.setColor(Color.LIGHT_GRAY);
            int mx = (int)((float)x + 0.5f * (float)w);
            int my = (int)((float)y + 0.5f * (float)h);
            g2.drawLine(mx, y, mx, y + h);
            g2.drawLine(x, my, x + w, my);
        }
        g2.setStroke(this.defStroke);
        g2.setColor(this.borderColor);
        g2.drawRect(x, y, w, h);
        this.drawTarget(g2, 3.2f, this.color1);
        this.drawTarget(g2, 1.0f, this.color2);
        g2.dispose();
    }

    protected void drawTarget(Graphics2D g2, float strokeWidth, Color strokeColor) {
        double cx = this.position.getX();
        double cy = this.position.getY();
        float d = this.targetSize;
        g2.setStroke(new BasicStroke(strokeWidth, 1, 1));
        g2.setColor(strokeColor);
        g2.drawLine((int)cx, (int)(cy - (double)(d / 2.0f)), (int)cx, (int)(cy + (double)(d / 2.0f)));
        g2.drawLine((int)(cx - (double)(d / 2.0f)), (int)cy, (int)(cx + (double)(d / 2.0f)), (int)cy);
    }
}

