/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.cytoscape.ding.impl.cyannotator.utils.AnglePicker;
import org.cytoscape.ding.impl.cyannotator.utils.DoubleInputVerifier;
import org.cytoscape.ding.impl.cyannotator.utils.GradientEditor;
import org.cytoscape.ding.impl.cyannotator.utils.PointPicker;
import org.cytoscape.ding.internal.util.ColorUtil;
import org.cytoscape.ding.internal.util.MathUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;

public class MultipleGradientEditor
extends JPanel {
    private static Integer[] ANGLES = new Integer[]{0, 45, 90, 135, 180, 225, 270, 315};
    private JToggleButton linearToggle;
    private JToggleButton radialToggle;
    private ButtonGroup typeGroup = new ButtonGroup();
    private JButton paletteBtn;
    private JButton reverseBtn;
    private GradientEditor grEditor;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton editBtn;
    private JPanel linearOptionsPnl;
    private JLabel angleLbl = new JLabel("Angle (degrees):");
    private JComboBox<Integer> angleCmb;
    private AnglePicker anglePicker;
    private JPanel radialOptionsPnl;
    private JLabel centerLbl = new JLabel("Center:");
    private PointPicker pointPicker;
    private Palette lastPalette;
    private Palette currentPalette;
    private PaletteType paletteType;
    private float[] fractions;
    private Color[] colors;
    private double angle;
    private Point2D centerPoint = (Point2D)PointPicker.DEFAULT_VALUE.clone();
    private GradientType type;
    private final String targetId;
    private final CyServiceRegistrar serviceRegistrar;

    public MultipleGradientEditor(double angle, float[] fractions, Color[] colors, String targetId, CyServiceRegistrar serviceRegistrar) {
        this(GradientType.LINEAR, fractions, colors, targetId, serviceRegistrar);
        this.angle = (int)Math.round(MathUtil.normalizeAngle(angle));
        this.init();
    }

    public MultipleGradientEditor(Point2D centerPoint, float[] fractions, Color[] colors, String targetId, CyServiceRegistrar serviceRegistrar) {
        this(GradientType.RADIAL, fractions, colors, targetId, serviceRegistrar);
        this.centerPoint = (Point2D)centerPoint.clone();
        this.init();
    }

    private MultipleGradientEditor(GradientType type, float[] fractions, Color[] colors, String targetId, CyServiceRegistrar serviceRegistrar) {
        this.type = type;
        this.fractions = (float[])fractions.clone();
        this.colors = (Color[])colors.clone();
        this.targetId = targetId;
        this.serviceRegistrar = serviceRegistrar;
        this.paletteType = BrewerType.ANY;
        this.lastPalette = this.retrievePalette();
        if (this.lastPalette != null) {
            this.setCurrentPalette(this.lastPalette);
        }
    }

    public GradientType getType() {
        return this.type;
    }

    public float[] getFractions() {
        return (float[])this.fractions.clone();
    }

    public Color[] getColors() {
        return (Color[])this.colors.clone();
    }

    public double getAngle() {
        return this.angle;
    }

    public Point2D getCenterPoint() {
        return this.centerPoint != null ? (Point2D)this.centerPoint.clone() : (Point2D)PointPicker.DEFAULT_VALUE.clone();
    }

    public void saveCurrentPalette() {
        if (this.currentPalette != null) {
            PaletteProviderManager mgr = (PaletteProviderManager)this.serviceRegistrar.getService(PaletteProviderManager.class);
            mgr.savePalette((Object)("annotation::" + this.targetId), this.currentPalette);
        }
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.typeGroup.add(this.getLinearToggle());
        this.typeGroup.add(this.getRadialToggle());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(this.getLinearToggle()).addComponent(this.getRadialToggle()).addGap(10, 10, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(5).addComponent(this.getPaletteBtn()).addGap(10, 10, Short.MAX_VALUE).addComponent(this.getReverseBtn()).addGap(5)).addComponent(this.getGrEditor(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.getAddBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getRemoveBtn()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getEditBtn())).addComponent(this.getLinearOptionsPnl()).addComponent(this.getRadialOptionsPnl()));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getLinearToggle(), -2, -1, -2).addComponent(this.getRadialToggle(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getPaletteBtn(), -2, -1, -2).addComponent(this.getReverseBtn(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getGrEditor(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getAddBtn(), -2, -1, -2).addComponent(this.getRemoveBtn(), -2, -1, -2).addComponent(this.getEditBtn(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getLinearOptionsPnl()).addComponent(this.getRadialOptionsPnl()));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.centerLbl});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getLinearToggle(), this.getRadialToggle()});
        JComponent[] otherBtns = new JButton[]{this.getPaletteBtn(), this.getReverseBtn(), this.getAddBtn(), this.getRemoveBtn(), this.getEditBtn()};
        LookAndFeelUtil.makeSmall((JComponent[])otherBtns);
        if (LookAndFeelUtil.isAquaLAF()) {
            int i;
            JToggleButton[] toggleBtns = new JToggleButton[]{this.getLinearToggle(), this.getRadialToggle()};
            for (i = 0; i < toggleBtns.length; ++i) {
                JToggleButton btn = toggleBtns[i];
                btn.putClientProperty("JButton.buttonType", "segmented");
                if (i == 0) {
                    btn.putClientProperty("JButton.segmentPosition", "first");
                    continue;
                }
                if (i == toggleBtns.length - 1) {
                    btn.putClientProperty("JButton.segmentPosition", "last");
                    continue;
                }
                btn.putClientProperty("JButton.segmentPosition", "middle");
            }
            for (i = 0; i < otherBtns.length; ++i) {
                otherBtns[i].putClientProperty("JButton.buttonType", "gradient");
            }
        }
        LookAndFeelUtil.equalizeSize((JComponent[])otherBtns);
        if (this.type == GradientType.LINEAR) {
            this.typeGroup.setSelected(this.getLinearToggle().getModel(), true);
        } else {
            this.typeGroup.setSelected(this.getRadialToggle().getModel(), true);
        }
        this.updateOptionPanel();
    }

    private JToggleButton getLinearToggle() {
        if (this.linearToggle == null) {
            this.linearToggle = new JToggleButton("Linear Gradient");
            this.linearToggle.addActionListener(evt -> {
                if (this.linearToggle.isSelected()) {
                    this.type = GradientType.LINEAR;
                }
                this.updateOptionPanel();
            });
        }
        return this.linearToggle;
    }

    private JToggleButton getRadialToggle() {
        if (this.radialToggle == null) {
            this.radialToggle = new JToggleButton("Radial Gradient");
            this.radialToggle.addActionListener(evt -> {
                if (this.radialToggle.isSelected()) {
                    this.type = GradientType.RADIAL;
                }
                this.updateOptionPanel();
                if (this.radialToggle.isSelected()) {
                    this.centerPoint = this.getPointPicker().getValue();
                }
            });
        }
        return this.radialToggle;
    }

    private JButton getPaletteBtn() {
        if (this.paletteBtn == null) {
            this.paletteBtn = new JButton("Palette");
            this.paletteBtn.setToolTipText("None");
            this.paletteBtn.addActionListener(evt -> {
                CyColorPaletteChooserFactory factory = (CyColorPaletteChooserFactory)this.serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
                CyColorPaletteChooser chooser = factory.getColorPaletteChooser(this.paletteType, false);
                Palette newPalette = chooser.showDialog((Component)this, "Set Palette", this.currentPalette, 9);
                if (newPalette != null) {
                    this.setCurrentPalette(newPalette);
                    Color[] colors = newPalette.getColors(this.colors.length);
                    this.setColors(colors);
                }
            });
        }
        return this.paletteBtn;
    }

    public JButton getReverseBtn() {
        if (this.reverseBtn == null) {
            this.reverseBtn = new JButton("\uf0ec");
            this.reverseBtn.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f));
            this.reverseBtn.setToolTipText("Reverse Colors");
            this.reverseBtn.addActionListener(evt -> this.reverseColors());
        }
        return this.reverseBtn;
    }

    private GradientEditor getGrEditor() {
        if (this.grEditor == null) {
            float[] fractions = this.getFractions();
            Color[] colors = this.getColors();
            this.grEditor = new GradientEditor(fractions, colors, this.serviceRegistrar);
            this.grEditor.addActionListener(evt -> {
                this.fractions = this.grEditor.getPositions();
                this.colors = this.grEditor.getColors();
                this.updatePointButtons();
                if (this.getLinearOptionsPnl().isVisible()) {
                    this.updateAnglePicker();
                } else if (this.getRadialOptionsPnl().isVisible()) {
                    this.updatePointPicker();
                }
            });
            this.grEditor.addPropertyChangeListener("selected", evt -> this.updatePointButtons());
        }
        return this.grEditor;
    }

    private JButton getAddBtn() {
        if (this.addBtn == null) {
            IconManager icoMgr = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.addBtn = new JButton();
            this.addBtn.setIcon((Icon)new TextIcon("\uf067", icoMgr.getIconFont(14.0f), 16, 16));
            this.addBtn.setToolTipText("Add Color");
            this.addBtn.addActionListener(evt -> this.getGrEditor().addPoint());
        }
        return this.addBtn;
    }

    private JButton getRemoveBtn() {
        if (this.removeBtn == null) {
            IconManager icoMgr = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.removeBtn = new JButton();
            this.removeBtn.setIcon((Icon)new TextIcon("\uf014", icoMgr.getIconFont(16.0f), 16, 16));
            this.removeBtn.setToolTipText("Remove Color");
            this.removeBtn.setEnabled(false);
            this.removeBtn.addActionListener(evt -> this.getGrEditor().deletePoint());
        }
        return this.removeBtn;
    }

    private JButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = new JButton();
            this.editBtn.setIcon(new ColorIcon(16, 16));
            this.editBtn.setToolTipText("Edit Color");
            this.editBtn.setEnabled(false);
            this.editBtn.addActionListener(evt -> this.getGrEditor().editPoint());
        }
        return this.editBtn;
    }

    private JPanel getLinearOptionsPnl() {
        if (this.linearOptionsPnl == null) {
            this.linearOptionsPnl = new JPanel();
            this.linearOptionsPnl.setVisible(false);
            GroupLayout layout = new GroupLayout(this.linearOptionsPnl);
            this.linearOptionsPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGroup(layout.createSequentialGroup().addComponent(this.angleLbl).addComponent(this.getAngleCmb(), -2, -1, -2)).addComponent(this.getAnglePicker(), -2, -1, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.angleLbl).addComponent(this.getAngleCmb(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getAnglePicker(), -2, -1, -2));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.angleLbl, this.getAngleCmb()});
        }
        return this.linearOptionsPnl;
    }

    private JComboBox<Integer> getAngleCmb() {
        if (this.angleCmb == null) {
            this.angleCmb = new JComboBox<Integer>(ANGLES);
            this.angleCmb.setEditable(true);
            ((JLabel)((Object)this.angleCmb.getRenderer())).setHorizontalAlignment(4);
            this.angleCmb.setSelectedItem((int)Math.round(this.angle));
            this.angleCmb.setInputVerifier(new DoubleInputVerifier());
            this.angleCmb.addActionListener(e -> {
                Object angle = this.angleCmb.getSelectedItem();
                this.angle = angle instanceof Number ? (double)((Number)angle).intValue() : 0.0;
                this.angle = (int)Math.round(MathUtil.normalizeAngle(this.angle));
                this.updateAnglePicker();
            });
        }
        return this.angleCmb;
    }

    private AnglePicker getAnglePicker() {
        if (this.anglePicker == null) {
            this.anglePicker = new AnglePicker();
            this.anglePicker.setPreferredSize(new Dimension(120, 120));
            this.anglePicker.addPropertyChangeListener("value", evt -> {
                this.angle = ((Number)evt.getNewValue()).intValue();
                this.getAngleCmb().setSelectedItem((int)this.angle);
            });
        }
        return this.anglePicker;
    }

    private JPanel getRadialOptionsPnl() {
        if (this.radialOptionsPnl == null) {
            this.radialOptionsPnl = new JPanel();
            this.radialOptionsPnl.setVisible(false);
            GroupLayout layout = new GroupLayout(this.radialOptionsPnl);
            this.radialOptionsPnl.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.centerLbl).addComponent(this.getPointPicker(), -2, -1, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.centerLbl).addComponent(this.getPointPicker(), -2, -1, -2));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.centerLbl});
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getPaletteBtn(), this.getReverseBtn()});
        }
        return this.radialOptionsPnl;
    }

    private PointPicker getPointPicker() {
        if (this.pointPicker == null) {
            this.pointPicker = new PointPicker(100, 12, this.getCenterPoint(), this.serviceRegistrar);
            this.pointPicker.addPropertyChangeListener("value", evt -> {
                this.centerPoint = (Point2D)evt.getNewValue();
            });
        }
        return this.pointPicker;
    }

    private Palette retrievePalette() {
        PaletteProviderManager mgr = (PaletteProviderManager)this.serviceRegistrar.getService(PaletteProviderManager.class);
        return mgr.retrievePalette((Object)("annotation::" + this.targetId));
    }

    private void setCurrentPalette(Palette palette) {
        this.getPaletteBtn().setToolTipText(palette.toString());
        this.currentPalette = palette;
    }

    private void setColors(Color[] colors) {
        ArrayList<GradientEditor.ControlPoint> controlPoints = new ArrayList<GradientEditor.ControlPoint>();
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            float f = this.fractions[i];
            controlPoints.add(new GradientEditor.ControlPoint(c, f));
        }
        this.grEditor.setPoints(controlPoints);
    }

    private void reverseColors() {
        ArrayList<GradientEditor.ControlPoint> controlPoints = new ArrayList<GradientEditor.ControlPoint>();
        for (int i = this.fractions.length - 1; i >= 0; --i) {
            Color c = this.colors[i];
            float f = 1.0f - this.fractions[i];
            f = Math.max(0.0f, Math.min(1.0f, f));
            controlPoints.add(new GradientEditor.ControlPoint(c, f));
        }
        this.grEditor.setPoints(controlPoints);
    }

    private void updateOptionPanel() {
        this.getLinearOptionsPnl().setVisible(this.getLinearToggle().isSelected());
        this.getRadialOptionsPnl().setVisible(this.getRadialToggle().isSelected());
        if (this.getLinearOptionsPnl().isVisible()) {
            this.updateAnglePicker();
        }
        if (this.getRadialOptionsPnl().isVisible()) {
            this.updatePointPicker();
        }
    }

    private void updatePointButtons() {
        GradientEditor.ControlPoint selected = this.getGrEditor().getSelected();
        List<GradientEditor.ControlPoint> controlPoints = this.getGrEditor().getControlPoints();
        ((ColorIcon)this.getEditBtn().getIcon()).setColor(selected != null ? selected.getColor() : null);
        this.getEditBtn().setEnabled(selected != null);
        this.getRemoveBtn().setEnabled(selected != null && !Objects.equal((Object)selected, (Object)controlPoints.get(0)) && !Objects.equal((Object)selected, (Object)controlPoints.get(controlPoints.size() - 1)));
    }

    private void updateAnglePicker() {
        this.getAnglePicker().update(this.fractions, this.colors, (int)Math.round(this.angle));
    }

    private void updatePointPicker() {
        this.getPointPicker().update(this.fractions, this.colors);
    }

    public static enum GradientType {
        LINEAR("Linear Gradient"),
        RADIAL("Radial Gradient");

        private String label;

        private GradientType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class ColorIcon
    implements Icon {
        private Color color;
        private final int width;
        private final int height;

        public ColorIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconHeight() {
            return this.width;
        }

        @Override
        public int getIconWidth() {
            return this.height;
        }

        public void setColor(Color color) {
            this.color = color;
            MultipleGradientEditor.this.repaint();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (c.isEnabled()) {
                g.setColor(this.color != null ? this.color : Color.WHITE);
                g.fillRect(x, y, w, h);
            }
            g.setColor(c.isEnabled() ? ColorUtil.getContrastingColor(c.getBackground()) : UIManager.getColor("Button.disabledForeground"));
            g.drawRect(x, y, w, h);
            if (this.color == null && c.isEnabled()) {
                g.setColor(Color.RED);
                g.drawLine(x + 1, y + h - 1, x + w - 1, y + 1);
            }
        }
    }
}

