/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class EnhancedSlider
extends JPanel {
    private JSlider slider;
    private JFormattedTextField textField;
    private final int min;
    private final int max;
    private int value;
    private final int defValue;
    private final int majorTickSpacing;
    private final int minorTickSpacing;
    private final List<Object> listeners;
    private boolean ignore;
    private final String newline = System.getProperty("line.separator");
    private static boolean shiftPressed;

    public EnhancedSlider(int value) {
        this(0, 100, value, 50, 25);
    }

    public EnhancedSlider(int min, int max, int value, int majorTickSpacing, int minorTickSpacing) {
        this.min = min;
        this.max = max;
        this.value = this.defValue = value;
        this.majorTickSpacing = majorTickSpacing;
        this.minorTickSpacing = minorTickSpacing;
        this.listeners = new ArrayList<Object>();
        this.initUI();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.ignore = true;
        this.value = value;
        this.getSlider().setValue(value);
        this.getTextField().setValue(value);
        this.ignore = false;
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        Iterator<Object> iter = this.listeners.iterator();
        ChangeEvent evt = new ChangeEvent(this);
        while (iter.hasNext()) {
            ChangeListener cl = (ChangeListener)iter.next();
            cl.stateChanged(evt);
        }
    }

    public JFormattedTextField getTextField() {
        if (this.textField == null) {
            NumberFormat format = NumberFormat.getInstance();
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(Integer.class);
            formatter.setMinimum(Integer.valueOf(this.min));
            formatter.setMaximum(Integer.valueOf(this.max));
            formatter.setAllowsInvalid(false);
            this.textField = new MyFormattedTextField(format);
            this.textField.setHorizontalAlignment(4);
            if (LookAndFeelUtil.isAquaLAF()) {
                this.textField.putClientProperty("JComponent.sizeVariant", "small");
            } else if (this.textField.getFont() != null) {
                this.textField.setFont(this.textField.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            this.textField.addActionListener(evt -> this.textFieldValueChanged());
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    EnhancedSlider.this.textFieldValueChanged();
                }
            });
        }
        return this.textField;
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider(this.min, this.max, this.value){

                @Override
                public boolean getSnapToTicks() {
                    return shiftPressed;
                }
            };
            this.slider.setMajorTickSpacing(this.majorTickSpacing);
            this.slider.setMinorTickSpacing(this.minorTickSpacing);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.setPreferredSize(new Dimension(120, this.slider.getPreferredSize().height));
            this.getTextField().setValue(this.value);
            this.slider.addChangeListener(evt -> {
                if (this.ignore) {
                    return;
                }
                this.ignore = true;
                this.value = this.getSlider().getValue();
                this.value = this.clamp(this.value);
                this.getTextField().setValue(this.value);
                this.fireChangeEvent();
                this.ignore = false;
            });
        }
        return this.slider;
    }

    private void initUI() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getSlider(), -1, -1, Short.MAX_VALUE).addComponent(this.getTextField(), -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getSlider()).addGroup(layout.createSequentialGroup().addGap(LookAndFeelUtil.isAquaLAF() ? 4 : 0).addComponent(this.getTextField(), -2, -1, -2)));
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
    }

    private int getFieldValue() {
        int val = this.defValue;
        Object errorMsg = null;
        try {
            val = Integer.valueOf(this.getTextField().getText());
        }
        catch (NumberFormatException nfe) {
            errorMsg = "Please enter a valid number.";
        }
        if (val < this.min) {
            errorMsg = "Value (" + val + ") is less than lower limit (" + this.min + ")." + this.newline + "Value will be set to the lowest allowed number: " + this.min;
            val = this.min;
        } else if (val > this.max) {
            errorMsg = "Value (" + val + ") is more than upper limit (" + this.max + ")." + this.newline + "Value will be set to the highest allowed number: " + this.max;
            val = this.max;
        }
        if (errorMsg != null) {
            this.showErrorMessage((String)errorMsg, val);
        }
        return val;
    }

    private void showErrorMessage(String msg, int val) {
        this.getTextField().setForeground(LookAndFeelUtil.getErrorColor());
        JOptionPane.showMessageDialog(null, msg, "Invalid Number", 0);
        this.getTextField().setValue(val);
        this.getTextField().setForeground(UIManager.getColor("TextField.foreground"));
    }

    private int clamp(int val) {
        val = Math.min(val, this.max);
        val = Math.max(val, this.min);
        return val;
    }

    private void textFieldValueChanged() {
        if (this.ignore) {
            return;
        }
        this.ignore = true;
        int v = this.getFieldValue();
        if (v != this.value) {
            this.value = v;
            this.getSlider().setValue(this.value);
        }
        this.fireChangeEvent();
        this.ignore = false;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                if (ke.getID() == 401) {
                    if (ke.getKeyCode() == 16) {
                        shiftPressed = true;
                    }
                } else if (ke.getID() == 402 && ke.getKeyCode() == 16) {
                    shiftPressed = false;
                }
                return false;
            }
        });
    }

    private class MyFormattedTextField
    extends JFormattedTextField {
        private final NumberFormat numberFormat;

        public MyFormattedTextField(NumberFormat format) {
            super(format);
            this.numberFormat = format;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (this.getGraphics() != null && this.numberFormat != null) {
                FontMetrics fm = this.getGraphics().getFontMetrics();
                int minW = fm.stringWidth(this.numberFormat.format(EnhancedSlider.this.min));
                int maxW = fm.stringWidth(this.numberFormat.format(EnhancedSlider.this.max));
                int sw = 16 + Math.max(minW, maxW);
                d.width = Math.max(sw, 48);
            }
            return d;
        }
    }
}

