/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.ding.internal.util.MathUtil;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class AnglePicker
extends JPanel {
    private static final int POINT_RADIUS = 4;
    private static final int POINT_BORDER = 2;
    private static final int[] MAIN_ANGLES = new int[]{0, 45, 90, 135, 180, 225, 270, 315};
    private static final int[] ALL_ANGLES = new int[]{0, 45, 90, 135, 180, 225, 270, 315, 360};
    private Color borderColor = UIManager.getColor("Separator.foreground");
    private Color color1 = UIManager.getColor("CyComponent.borderColor");
    private Color color2 = UIManager.getColor("Table.background");
    private Color selColor = UIManager.getColor("Focus.color");
    private Stroke defStroke = new BasicStroke(1.0f);
    private Stroke thickStroke = new BasicStroke(2.0f);
    private Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    private int angle = -1;
    private float[] fractions = new float[]{0.0f, 1.0f};
    private Color[] colors = new Color[]{Color.BLACK, Color.WHITE};
    private boolean mouseDragging;

    public AnglePicker() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnglePicker.this.selectAngle(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AnglePicker.this.mouseDragging = false;
                AnglePicker.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                AnglePicker.this.mouseDragging = true;
                AnglePicker.this.selectAngle(evt);
            }
        });
    }

    private void selectAngle(MouseEvent evt) {
        double oldValue = this.angle;
        int x = evt.getX() - this.getWidth() / 2;
        int y = -evt.getY() + this.getHeight() / 2;
        this.angle = (int)Math.toDegrees(Math.atan2(y, x));
        if (this.angle < 0) {
            this.angle = 360 + this.angle;
        }
        if (evt.isShiftDown()) {
            this.angle = MathUtil.findNearestNumber(ALL_ANGLES, Math.round(this.angle));
        }
        if (this.angle == 360) {
            this.angle = 0;
        }
        this.repaint();
        this.firePropertyChange("value", oldValue, (double)this.angle);
    }

    public void update(float[] fractions, Color[] colors, int angle) {
        this.fractions = fractions;
        this.colors = colors;
        this.angle = (int)Math.round(MathUtil.normalizeAngle(angle));
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        int pr = 4;
        int pb = 2;
        int pad = Math.max(insets.top + insets.bottom, insets.left + insets.right) / 2;
        int r = Math.min(w, h) / 2 - pr - pb / 2 - pad;
        g2.translate(w / 2, h / 2);
        if (this.fractions != null && this.fractions.length > 0 && this.colors != null && this.colors.length > 0) {
            Rectangle bounds = new Rectangle(-r, -r, 2 * r - 4 + pr, 2 * r - 4 + pr);
            Line2D line = MathUtil.getGradientAxis(bounds, this.angle);
            LinearGradientPaint paint = new LinearGradientPaint(line.getP1(), line.getP2(), this.fractions, this.colors);
            g2.setPaint(paint);
            g2.fill(bounds);
            g2.setColor(this.borderColor);
            g2.draw(bounds);
        }
        g2.setStroke(this.dashedStroke);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawLine(-r, 0, r, 0);
        g2.drawLine(0, -r, 0, r);
        g2.setStroke(this.defStroke);
        g2.setColor(this.color1);
        g2.drawOval(-r, -r, r * 2, r * 2);
        g2.setColor(this.color2);
        g2.drawOval(-r + 1, -r + 1, (r - 1) * 2, (r - 1) * 2);
        for (Object angle : (Rectangle)MAIN_ANGLES) {
            int x = (int)((double)r * Math.cos(Math.toRadians((double)angle)));
            int y = (int)((double)r * Math.sin(Math.toRadians((double)angle)));
            g2.setStroke(this.thickStroke);
            g2.setColor(this.color1);
            g2.drawOval(x - pr, y - pr, 2 * pr, 2 * pr);
            g2.setColor(this.color2);
            g2.fillOval(x - pr, y - pr, 2 * pr, 2 * pr);
        }
        if (this.angle >= 0) {
            int x = (int)((double)r * Math.cos(Math.toRadians(this.angle)));
            int y = (int)((double)r * Math.sin(Math.toRadians(this.angle)));
            if (this.mouseDragging) {
                g2.setStroke(this.defStroke);
                g2.setColor(this.selColor);
                g2.drawLine(x, -y, 0, 0);
            }
            g2.setStroke(this.thickStroke);
            g2.setColor(this.color2);
            g2.drawOval(x - pr, -y - pr, 2 * pr, 2 * pr);
            g2.setStroke(this.defStroke);
            g2.setColor(this.selColor);
            g2.fillOval(x - pr, -y - pr, 2 * pr, 2 * pr);
        }
        g2.dispose();
    }
}

