/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.ui;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedEvent;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedListener;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.InputHandlerGlassPane;
import org.cytoscape.ding.impl.cyannotator.AnnotationNode;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.GroupAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.tasks.GroupAnnotationsTask;
import org.cytoscape.ding.impl.cyannotator.tasks.RemoveSelectedAnnotationsTask;
import org.cytoscape.ding.impl.cyannotator.tasks.ReorderAnnotationsTask;
import org.cytoscape.ding.impl.cyannotator.tasks.ReorderSelectedAnnotationsTaskFactory;
import org.cytoscape.ding.impl.cyannotator.tasks.UngroupAnnotationsTask;
import org.cytoscape.ding.impl.cyannotator.ui.AnnotationMainPanel;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationMediator
implements CyStartListener,
CyShutdownListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener,
NetworkViewAddedListener,
NetworkViewAboutToBeDestroyedListener,
SetCurrentNetworkViewListener,
PropertyChangeListener,
CytoPanelComponentSelectedListener {
    private AnnotationMainPanel mainPanel;
    private final Map<String, AnnotationFactory<? extends Annotation>> factories = new LinkedHashMap<String, AnnotationFactory<? extends Annotation>>();
    private final EscapePressedListener escapePressedListener = new EscapePressedListener();
    private boolean appStarted;
    private boolean loadingSession;
    private boolean ignoreSelectedPropChangeEvents;
    private final DebounceTimer updateOrderTimer = new DebounceTimer(100);
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public AnnotationMediator(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(CyStartEvent evt) {
        LinkedHashSet<AnnotationFactory<? extends Annotation>> set = new LinkedHashSet<AnnotationFactory<? extends Annotation>>(this.factories.values());
        ViewUtil.invokeOnEDT(() -> {
            if (this.mainPanel == null) {
                this.mainPanel = new AnnotationMainPanel(this.serviceRegistrar);
                this.serviceRegistrar.registerAllServices((Object)this.mainPanel, new Properties());
            }
            set.forEach(f -> this.addAnnotationButton((AnnotationFactory<? extends Annotation>)f));
            this.mainPanel.setEnabled(false);
            this.mainPanel.getGroupAnnotationsButton().addActionListener(e -> this.groupAnnotations());
            this.mainPanel.getUngroupAnnotationsButton().addActionListener(e -> this.ungroupAnnotations());
            this.mainPanel.getRemoveAnnotationsButton().addActionListener(e -> this.removeSelectedAnnotations());
            this.mainPanel.getPushToBackgroundButton().addActionListener(e -> this.moveAnnotationsToCanvas("background"));
            this.mainPanel.getPullToForegroundButton().addActionListener(e -> this.moveAnnotationsToCanvas("foreground"));
            this.mainPanel.getBackgroundLayerPanel().getForwardButton().addActionListener(e -> this.reorderAnnotations("background", this.mainPanel.getBackgroundTree(), AnnotationTree.Shift.UP_ONE));
            this.mainPanel.getBackgroundLayerPanel().getBackwardButton().addActionListener(e -> this.reorderAnnotations("background", this.mainPanel.getBackgroundTree(), AnnotationTree.Shift.DOWN_ONE));
            this.mainPanel.getForegroundLayerPanel().getForwardButton().addActionListener(e -> this.reorderAnnotations("foreground", this.mainPanel.getForegroundTree(), AnnotationTree.Shift.UP_ONE));
            this.mainPanel.getForegroundLayerPanel().getBackwardButton().addActionListener(e -> this.reorderAnnotations("foreground", this.mainPanel.getForegroundTree(), AnnotationTree.Shift.DOWN_ONE));
            this.mainPanel.getBackgroundTree().getSelectionModel().addTreeSelectionListener(e -> {
                if (!this.mainPanel.getBackgroundTree().isEditing()) {
                    this.mainPanel.updateSelectionButtons();
                    this.selectAnnotationsFromSelectedRows();
                }
            });
            this.mainPanel.getForegroundTree().getSelectionModel().addTreeSelectionListener(e -> {
                if (!this.mainPanel.getForegroundTree().isEditing()) {
                    this.mainPanel.updateSelectionButtons();
                    this.selectAnnotationsFromSelectedRows();
                }
            });
            this.mainPanel.getBackgroundTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AnnotationMediator.this.maybeShowPopupMenu(AnnotationMediator.this.mainPanel.getBackgroundTree(), e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AnnotationMediator.this.maybeShowPopupMenu(AnnotationMediator.this.mainPanel.getBackgroundTree(), e);
                }
            });
            this.mainPanel.getForegroundTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AnnotationMediator.this.maybeShowPopupMenu(AnnotationMediator.this.mainPanel.getForegroundTree(), e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AnnotationMediator.this.maybeShowPopupMenu(AnnotationMediator.this.mainPanel.getForegroundTree(), e);
                }
            });
            this.setKeyBindings(this.mainPanel.getBackgroundTree());
            this.setKeyBindings(this.mainPanel.getForegroundTree());
        });
        this.appStarted = true;
    }

    public void handleEvent(CyShutdownEvent evt) {
        this.appStarted = false;
    }

    public void handleEvent(SessionAboutToBeLoadedEvent evt) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent evt) {
        this.loadingSession = false;
        if (this.mainPanel == null) {
            return;
        }
        this.mainPanel.clearAnnotationButtonSelection();
        Set allViews = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViewSet();
        DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
        allViews.forEach(view -> {
            DRenderingEngine re = dingRenderer.getRenderingEngine((CyNetworkView)view);
            if (re != null) {
                this.addPropertyListeners(re);
                this.addPropertyListeners(re.getCyAnnotator().getAnnotations());
            }
        });
        DRenderingEngine re = this.getCurrentDRenderingEngine();
        ViewUtil.invokeOnEDT(() -> this.mainPanel.update(re));
    }

    public void handleEvent(NetworkViewAddedEvent evt) {
        if (!this.appStarted || this.loadingSession) {
            return;
        }
        CyNetworkView view = evt.getNetworkView();
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        if (re != null) {
            this.addPropertyListeners(re);
            this.addPropertyListeners(re.getCyAnnotator().getAnnotations());
        }
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent evt) {
        CyNetworkView view = evt.getNetworkView();
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        if (re != null) {
            this.removePropertyListeners(re);
            this.removePropertyListeners(re.getCyAnnotator().getAnnotations());
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent evt) {
        if (this.appStarted && !this.loadingSession) {
            this.mainPanel.clearAnnotationButtonSelection();
            CyNetworkView view = evt.getNetworkView();
            DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
            ViewUtil.invokeOnEDT(() -> this.mainPanel.update(re));
        }
    }

    public void handleEvent(CytoPanelComponentSelectedEvent evt) {
        if (this.appStarted && CytoPanelName.WEST == evt.getCytoPanel().getCytoPanelName()) {
            ViewUtil.invokeOnEDT(() -> this.mainPanel.clearAnnotationButtonSelection());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.appStarted || this.loadingSession) {
            return;
        }
        DRenderingEngine re = this.getCurrentDRenderingEngine();
        CyAnnotator cyAnnotator = re != null ? re.getCyAnnotator() : null;
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (source.equals(cyAnnotator)) {
            switch (propertyName) {
                case "annotations": {
                    Set<Annotation> oldList = this.mainPanel.getAllAnnotations();
                    List<DingAnnotation> newList = cyAnnotator.getAnnotations();
                    oldList.removeAll(newList);
                    this.removePropertyListeners(oldList);
                    this.addPropertyListeners((Collection)evt.getNewValue());
                    ViewUtil.invokeOnEDT(() -> this.mainPanel.update(re));
                    break;
                }
                case "annotationsReordered": {
                    if (re == null || !re.equals(this.mainPanel.getRenderingEngine())) break;
                    this.updateOrderTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> this.mainPanel.updateAnnotationsOrder()));
                }
            }
        } else if (source instanceof Annotation && re != null && re.equals(this.mainPanel.getRenderingEngine())) {
            if ("selected".equals(propertyName) && !this.ignoreSelectedPropChangeEvents) {
                ViewUtil.invokeOnEDT(() -> this.mainPanel.setSelected((Annotation)source, (Boolean)evt.getNewValue()));
            } else if ("canvas".equals(propertyName) && !this.ignoreSelectedPropChangeEvents) {
                this.updateOrderTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> this.mainPanel.updateAnnotationsOrder()));
            }
        }
    }

    public void showAnnotationPanel() {
        ViewUtil.invokeOnEDT(() -> {
            int idx;
            CySwingApplication swingApp = (CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class);
            CytoPanel cytoPanel = swingApp.getCytoPanel(AnnotationMainPanel.CYTOPANEL_NAME);
            if (cytoPanel.getState() == CytoPanelState.HIDE) {
                cytoPanel.setState(CytoPanelState.DOCK);
            }
            if ((idx = cytoPanel.indexOfComponent(this.mainPanel.getComponent())) >= 0) {
                cytoPanel.setSelectedIndex(idx);
            }
        });
    }

    public void editAnnotation(Annotation a) {
        this.editAnnotation(a, null);
    }

    public void editAnnotation(Annotation a, Point location) {
        if (a != null) {
            ViewUtil.invokeOnEDT(() -> {
                this.mainPanel.editAnnotation(a, location);
                if (!this.mainPanel.getAppearancePanel().isFloating()) {
                    this.showAnnotationPanel();
                }
            });
        }
    }

    public void renameAnnotation(Annotation a) {
        if (a != null) {
            ViewUtil.invokeOnEDT(() -> this.mainPanel.renameAnnotation(a));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationFactory(AnnotationFactory<? extends Annotation> f, Map<?, ?> props) {
        if (!(f instanceof AbstractDingAnnotationFactory)) {
            return;
        }
        if (f instanceof GroupAnnotationFactory) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.factories.put(f.getId(), f);
        }
        if (this.appStarted) {
            ViewUtil.invokeOnEDT(() -> this.addAnnotationButton(f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationFactory(AnnotationFactory<? extends Annotation> f, Map<?, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            if (this.factories.remove(f.getId()) != null && this.appStarted) {
                ViewUtil.invokeOnEDT(() -> this.mainPanel.removeAnnotationButton(f));
            }
        }
    }

    private void addAnnotationButton(AnnotationFactory<? extends Annotation> factory) {
        JToggleButton btn = this.mainPanel.addAnnotationButton(factory);
        btn.addItemListener(evt -> {
            int state = evt.getStateChange();
            DRenderingEngine re = this.getCurrentDRenderingEngine();
            if (re != null) {
                InputHandlerGlassPane ihGlassPane = re.getInputHandlerGlassPane();
                if (state == 1) {
                    this.addEscapePressedListener();
                    ihGlassPane.beginClickToAddAnnotation(factory, () -> this.mainPanel.clearAnnotationButtonSelection());
                } else {
                    ihGlassPane.cancelClickToAddAnnotation(factory);
                    this.removeEscapePressedListener();
                }
            }
            this.mainPanel.setCreateMode(state == 1);
        });
    }

    private DRenderingEngine getCurrentDRenderingEngine() {
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAnnotationsFromSelectedRows() {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null || re.getCyAnnotator() == null) {
            return;
        }
        List<Annotation> selList = this.mainPanel.getSelectedAnnotations();
        List<DingAnnotation> all = re.getCyAnnotator().getAnnotations();
        if (all != null && !all.isEmpty()) {
            this.ignoreSelectedPropChangeEvents = true;
            try {
                all.forEach(a -> a.setSelected(selList.contains(a)));
            }
            finally {
                this.ignoreSelectedPropChangeEvents = false;
            }
        }
        Annotation a2 = selList.size() > 0 ? selList.get(selList.size() - 1) : null;
        this.mainPanel.maybeUpdateEditingAnnotation(a2);
    }

    private void groupAnnotations() {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null) {
            return;
        }
        List<DingAnnotation> selList = this.mainPanel.getSelectedAnnotations(DingAnnotation.class);
        if (!selList.isEmpty()) {
            GroupAnnotationsTask task = new GroupAnnotationsTask(re, selList);
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(new TaskIterator(new Task[]{task}));
        }
    }

    private void ungroupAnnotations() {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null) {
            return;
        }
        List<GroupAnnotation> selList = this.mainPanel.getSelectedAnnotations(GroupAnnotation.class);
        if (!selList.isEmpty()) {
            UngroupAnnotationsTask task = new UngroupAnnotationsTask(re, selList);
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(new TaskIterator(new Task[]{task}));
        }
    }

    private void removeSelectedAnnotations() {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null) {
            return;
        }
        List<Annotation> selList = this.mainPanel.getSelectedAnnotations();
        if (!selList.isEmpty()) {
            TaskIterator iterator = new TaskIterator(new Task[]{new RemoveSelectedAnnotationsTask(re, selList, this.serviceRegistrar)});
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(iterator);
        }
    }

    private void moveAnnotationsToCanvas(String canvasName) {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null) {
            return;
        }
        if (re != null) {
            DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
            ReorderSelectedAnnotationsTaskFactory factory = new ReorderSelectedAnnotationsTaskFactory(dingRenderer, canvasName);
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(factory.createTaskIterator(re.getViewModel()));
        }
    }

    private void reorderAnnotations(String canvas, JTree tree, AnnotationTree.Shift shift) {
        DRenderingEngine re = this.mainPanel.getRenderingEngine();
        if (re == null) {
            return;
        }
        if (re != null) {
            List<DingAnnotation> annotations = this.mainPanel.getSelectedAnnotations(tree, DingAnnotation.class);
            ReorderAnnotationsTask task = new ReorderAnnotationsTask(re, annotations, null, shift);
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(new TaskIterator(new Task[]{task}));
        }
    }

    private void addPropertyListeners(DRenderingEngine re) {
        if (re == null || re.getCyAnnotator() == null) {
            return;
        }
        this.removePropertyListeners(re);
        re.getCyAnnotator().addPropertyChangeListener("annotations", this);
        re.getCyAnnotator().addPropertyChangeListener("annotationsReordered", this);
    }

    private void removePropertyListeners(DRenderingEngine re) {
        if (re == null || re.getCyAnnotator() == null) {
            return;
        }
        re.getCyAnnotator().removePropertyChangeListener("annotations", this);
        re.getCyAnnotator().removePropertyChangeListener("annotationsReordered", this);
    }

    private void addPropertyListeners(Collection<? extends Annotation> list) {
        if (list != null) {
            list.forEach(a -> {
                if (a instanceof DingAnnotation) {
                    ((DingAnnotation)a).removePropertyChangeListener("selected", this);
                    ((DingAnnotation)a).addPropertyChangeListener("selected", this);
                    ((DingAnnotation)a).removePropertyChangeListener("canvas", this);
                    ((DingAnnotation)a).addPropertyChangeListener("canvas", this);
                }
            });
        }
    }

    private void removePropertyListeners(Collection<? extends Annotation> list) {
        if (list != null) {
            list.forEach(a -> {
                if (a instanceof DingAnnotation) {
                    ((DingAnnotation)a).removePropertyChangeListener("selected", this);
                    ((DingAnnotation)a).removePropertyChangeListener("canvas", this);
                }
            });
        }
    }

    private void maybeShowPopupMenu(JTree tree, MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        DRenderingEngine re = this.getCurrentDRenderingEngine();
        if (re == null) {
            return;
        }
        AnnotationNode node = this.getNodeAt(tree, e.getPoint());
        List<DingAnnotation> annotations = this.mainPanel.getSelectedAnnotations(tree, DingAnnotation.class);
        if (node != null && !annotations.contains(node.getAnnotation())) {
            this.mainPanel.setSelected(node.getAnnotation(), true);
        }
        DialogTaskManager taskMgr = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
        JPopupMenu popup = new JPopupMenu();
        List<DingAnnotation> list = this.mainPanel.getSelectedAnnotations(tree, DingAnnotation.class);
        DingAnnotation a = list.size() == 1 ? list.get(0) : null;
        JMenuItem mi = new JMenuItem("Modify Annotation...");
        mi.addActionListener(evt -> this.editAnnotation(a));
        popup.add(mi);
        mi.setEnabled(a != null && !(a instanceof GroupAnnotation));
        mi = new JMenuItem("Rename Annotation...");
        mi.addActionListener(evt -> this.renameAnnotation(a));
        popup.add(mi);
        mi.setEnabled(a != null);
        popup.addSeparator();
        ReorderSelectedAnnotationsTaskFactory factory = new ReorderSelectedAnnotationsTaskFactory(dingRenderer, AnnotationTree.Shift.TO_FRONT);
        JMenuItem mi2 = new JMenuItem("Bring Annotations to Front");
        mi2.addActionListener(evt -> taskMgr.execute(factory.createTaskIterator(re.getViewModel())));
        popup.add(mi2);
        mi2.setEnabled(factory.isReady(re.getViewModel()));
        factory = new ReorderSelectedAnnotationsTaskFactory(dingRenderer, AnnotationTree.Shift.TO_BACK);
        mi2 = new JMenuItem("Send Annotations to Back");
        mi2.addActionListener(evt -> taskMgr.execute(factory.createTaskIterator(re.getViewModel())));
        popup.add(mi2);
        mi2.setEnabled(factory.isReady(re.getViewModel()));
        popup.addSeparator();
        String text = "foreground".equalsIgnoreCase(tree.getName()) ? "Push Annotations to Background Layer" : "Pull Annotations to Foreground Layer";
        String canvasName = "foreground".equalsIgnoreCase(tree.getName()) ? "background" : "foreground";
        ReorderSelectedAnnotationsTaskFactory factory2 = new ReorderSelectedAnnotationsTaskFactory(dingRenderer, canvasName);
        JMenuItem mi3 = new JMenuItem(text);
        mi3.addActionListener(evt -> taskMgr.execute(factory2.createTaskIterator(re.getViewModel())));
        popup.add(mi3);
        mi3.setEnabled(factory2.isReady(re.getViewModel()));
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private AnnotationNode getNodeAt(JTree tree, Point point) {
        TreePath path = tree.getPathForLocation(point.x, point.y);
        return path == null ? null : (AnnotationNode)path.getLastPathComponent();
    }

    private void addEscapePressedListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.escapePressedListener, 8L);
    }

    private void removeEscapePressedListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.escapePressedListener);
    }

    private void setKeyBindings(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "VK_DELETE");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "VK_DELETE");
        actionMap.put("VK_DELETE", new KeyAction("VK_DELETE"));
    }

    private class EscapePressedListener
    implements AWTEventListener {
        private EscapePressedListener() {
        }

        @Override
        public void eventDispatched(AWTEvent evt) {
            AnnotationMainPanel.AnnotationToggleButton btn;
            KeyEvent key;
            if (evt instanceof KeyEvent && (key = (KeyEvent)evt).getID() == 401 && key.getKeyCode() == 27 && (btn = AnnotationMediator.this.mainPanel.getSelectedAnnotationButton()) != null && btn.isEnabled() && btn.isSelected()) {
                btn.doClick();
            }
        }
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_DELETE = "VK_DELETE";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (cmd.equals(VK_DELETE)) {
                AnnotationMediator.this.removeSelectedAnnotations();
            }
        }
    }
}

