/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationNode;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class AnnotationMainPanel
extends JPanel
implements CytoPanelComponent2 {
    public static final CytoPanelName CYTOPANEL_NAME = CytoPanelName.WEST;
    private static final String TITLE = "Annotation";
    private static final String ID = "org.cytoscape.Annotation";
    private static final Color TREE_BG_COLOR = UIManager.getColor("Table.background");
    private static final Color TREE_FG_COLOR = UIManager.getColor("Table.foreground");
    private static final Color TREE_SEL_BG_COLOR = UIManager.getColor("Table.selectionBackground");
    private static final Color TREE_SEL_FG_COLOR = UIManager.getColor("Table.selectionForeground");
    public static final float STATE_ICON_FONT_SIZE = 11.0f;
    private JPanel toolBarPanel;
    private JTabbedPane contentTabbedPane;
    private JPanel layersPanel;
    private AppearancePanel appearancePanel;
    private JLabel selectionLabel;
    private JButton groupAnnotationsButton;
    private JButton ungroupAnnotationsButton;
    private JButton removeAnnotationsButton;
    private JButton pullToForegroundButton;
    private JButton pushToBackgroundButton;
    private LayerPanel foregroundLayerPanel;
    private LayerPanel backgroundLayerPanel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private final Map<Class<? extends Annotation>, AnnotationToggleButton> buttonMap = new LinkedHashMap<Class<? extends Annotation>, AnnotationToggleButton>();
    private final Map<Class<? extends Annotation>, Icon> iconMap = new LinkedHashMap<Class<? extends Annotation>, Icon>();
    private final ButtonGroup buttonGroup;
    private JFrame appearanceFrame;
    private GroupLayout.SequentialGroup btnHGroup;
    private GroupLayout.ParallelGroup btnVGroup;
    private Icon defIcon;
    private Icon closedAnnotationIcon;
    private Icon openAnnotationIcon;
    private TextIcon icon;
    private DRenderingEngine re;
    private boolean createMode;
    private Annotation editingAnnotation;
    private final CyServiceRegistrar serviceRegistrar;

    public AnnotationMainPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.buttonGroup = new ButtonGroup(){
            private boolean isAdjusting;
            private ButtonModel prevModel;

            @Override
            public void setSelected(ButtonModel m, boolean b) {
                if (this.isAdjusting) {
                    return;
                }
                if (m != null && m.equals(this.prevModel)) {
                    this.isAdjusting = true;
                    this.clearSelection();
                    this.isAdjusting = false;
                } else {
                    super.setSelected(m, b);
                }
                this.prevModel = this.getSelection();
                AnnotationMainPanel.this.getAppearancePanel().update();
            }
        };
        this.init();
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CYTOPANEL_NAME;
    }

    public String getTitle() {
        return TITLE;
    }

    public String getIdentifier() {
        return ID;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            Font font = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f);
            this.icon = new TextIcon("1", font, 16, 16);
        }
        return this.icon;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.clearAnnotationButtonSelection();
        }
        this.buttonMap.values().forEach(btn -> btn.setEnabled(enabled));
        this.updateGroupUngroupButton();
        this.updateRemoveAnnotationsButton();
        this.updateSelectionButtons();
        this.updateMoveToCanvasButtons();
        this.getBackgroundLayerPanel().setEnabled(enabled);
        this.getForegroundLayerPanel().setEnabled(enabled);
    }

    boolean isCreateMode() {
        return this.createMode;
    }

    void setCreateMode(boolean createMode) {
        if (this.createMode != createMode) {
            this.createMode = createMode;
            if (createMode) {
                this.editingAnnotation = null;
            }
            this.updateEditor();
        }
        this.getAppearancePanel().update();
    }

    boolean isEditMode() {
        return !this.createMode && this.editingAnnotation != null;
    }

    Annotation getEditingAnnotation() {
        return this.editingAnnotation;
    }

    void setEditingAnnotation(Annotation a) {
        if (a != null) {
            this.setCreateMode(false);
        }
        if (!Objects.equals(a, this.editingAnnotation)) {
            this.editingAnnotation = a;
            this.updateEditor();
        }
        this.getAppearancePanel().update();
    }

    void editAnnotation(Annotation a, Point location) {
        if (a != null) {
            this.setEditingAnnotation(a);
            if (this.getAppearancePanel().getParent() == this.getContentTabbedPane()) {
                this.getContentTabbedPane().setSelectedComponent(this.getAppearancePanel());
            } else if (this.getAppearancePanel().isFloating()) {
                JFrame frame = this.getAppearanceFrame();
                if (!frame.isVisible()) {
                    if (a instanceof DingAnnotation) {
                        GraphicsConfiguration gc;
                        DRenderingEngine re = ((DingAnnotation)a).getCyAnnotator().getRenderingEngine();
                        JComponent comp = re != null ? re.getComponent() : null;
                        GraphicsConfiguration graphicsConfiguration = gc = comp != null ? comp.getGraphicsConfiguration() : null;
                        if (gc != null) {
                            Window w = SwingUtilities.windowForComponent(comp);
                            int x = gc.getBounds().x + (w != null ? w.getX() : 0);
                            int y = gc.getBounds().y + (w != null ? w.getY() : 0);
                            if (location != null) {
                                x += location.x;
                                y += location.y;
                            }
                            frame.setLocation(x, y);
                        }
                    }
                    frame.pack();
                    frame.setVisible(true);
                }
                frame.toFront();
                frame.requestFocus();
            }
        }
    }

    void renameAnnotation(Annotation a) {
        JTree tree;
        AnnotationTreeModel model;
        TreePath path;
        if (a != null && (path = (model = (AnnotationTreeModel)(tree = this.getLayerTree(a.getCanvasName())).getModel()).pathTo(a)) != null) {
            tree.startEditingAtPath(path);
            this.getContentTabbedPane().setSelectedComponent(this.getLayersPanel());
        }
    }

    JToggleButton addAnnotationButton(AnnotationFactory<? extends Annotation> f) {
        AnnotationToggleButton btn = new AnnotationToggleButton(f);
        btn.setFocusable(false);
        btn.setFocusPainted(false);
        this.buttonGroup.add(btn);
        this.buttonMap.put(f.getType(), btn);
        this.iconMap.put(f.getType(), f.getIcon());
        this.btnHGroup.addComponent(btn, -2, -1, -2);
        this.btnVGroup.addComponent(btn, -2, -1, -2);
        if (LookAndFeelUtil.isAquaLAF()) {
            btn.putClientProperty("JButton.buttonType", "gradient");
        }
        return btn;
    }

    void removeAnnotationButton(AnnotationFactory<? extends Annotation> f) {
        AbstractAnnotationEditor comp;
        AnnotationToggleButton btn = this.buttonMap.remove(f.getType());
        this.iconMap.remove(f.getType());
        if (btn != null) {
            this.getToolBarPanel().remove(btn);
        }
        if (f instanceof AbstractDingAnnotationFactory && (comp = ((AbstractDingAnnotationFactory)f).getEditor()) != null) {
            this.updateEditor();
        }
    }

    AnnotationToggleButton getSelectedAnnotationButton() {
        for (AnnotationToggleButton btn : this.buttonMap.values()) {
            if (!btn.isSelected()) continue;
            return btn;
        }
        return null;
    }

    Set<Annotation> getAllAnnotations() {
        HashSet<Annotation> set = new HashSet<Annotation>();
        set.addAll(((AnnotationTreeModel)this.getBackgroundTree().getModel()).getData());
        set.addAll(((AnnotationTreeModel)this.getForegroundTree().getModel()).getData());
        return set;
    }

    List<Annotation> getSelectedAnnotations() {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        list.addAll(this.getSelectedAnnotations(this.getBackgroundTree()));
        list.addAll(this.getSelectedAnnotations(this.getForegroundTree()));
        return list;
    }

    List<Annotation> getSelectedAnnotations(JTree tree) {
        return this.getSelectedAnnotations(tree, Annotation.class);
    }

    <T extends Annotation> List<T> getSelectedAnnotations(Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.getSelectedAnnotations(this.getBackgroundTree(), type));
        list.addAll(this.getSelectedAnnotations(this.getForegroundTree(), type));
        return list;
    }

    <T extends Annotation> List<T> getSelectedAnnotations(JTree tree, Class<T> type) {
        TreePath[] treePaths;
        ArrayList<Annotation> set = new ArrayList<Annotation>();
        for (TreePath path : treePaths = tree.getSelectionModel().getSelectionPaths()) {
            AnnotationNode node = (AnnotationNode)path.getLastPathComponent();
            Annotation obj = node.getAnnotation();
            if (!type.isAssignableFrom(obj.getClass())) continue;
            set.add(obj);
        }
        return set;
    }

    DRenderingEngine getRenderingEngine() {
        return this.re;
    }

    int getAnnotationCount() {
        return this.getBackgroundTree().getRowCount() + this.getForegroundTree().getRowCount();
    }

    int getSelectedAnnotationCount() {
        return this.getBackgroundTree().getSelectionCount() + this.getForegroundTree().getSelectionCount();
    }

    int getSelectedAnnotationCount(Class<? extends Annotation> type) {
        return this.getSelectedAnnotationCount(this.getBackgroundTree(), type) + this.getSelectedAnnotationCount(this.getForegroundTree(), type);
    }

    int getSelectedAnnotationCount(JTree tree, Class<? extends Annotation> type) {
        TreePath[] treePaths;
        int count = 0;
        for (TreePath path : treePaths = tree.getSelectionModel().getSelectionPaths()) {
            AnnotationNode node = (AnnotationNode)path.getLastPathComponent();
            Annotation obj = node.getAnnotation();
            if (!type.isAssignableFrom(obj.getClass())) continue;
            ++count;
        }
        return count;
    }

    void clearAnnotationButtonSelection() {
        this.buttonGroup.clearSelection();
    }

    void setSelected(Annotation a, boolean selected) {
        if (this.re != null && this.getAnnotationCount() > 0) {
            this.setSelected(a, selected, this.getForegroundTree());
            this.setSelected(a, selected, this.getBackgroundTree());
        }
        this.maybeUpdateEditingAnnotation(a);
    }

    private void setSelected(Annotation a, boolean selected, JTree tree) {
        AnnotationTreeModel model = (AnnotationTreeModel)tree.getModel();
        TreePath path = model.pathTo(a);
        if (path == null) {
            return;
        }
        if (selected) {
            tree.addSelectionPath(path);
            tree.scrollPathToVisible(path);
        } else {
            tree.removeSelectionPath(path);
        }
        a.setSelected(selected);
    }

    void dockAppearancePanel() {
        this.getAppearanceFrame().getContentPane().removeAll();
        this.getAppearanceFrame().setVisible(false);
        if (this.getAppearancePanel().getParent() != this.getContentTabbedPane()) {
            this.getContentTabbedPane().addTab("Appearance", this.getAppearancePanel());
        }
        this.getContentTabbedPane().setSelectedComponent(this.getAppearancePanel());
    }

    void floatAppearancePanel() {
        GraphicsConfiguration gc;
        if (this.getAppearancePanel().getParent() == this.getContentTabbedPane()) {
            this.getContentTabbedPane().remove(this.getAppearancePanel());
        }
        JFrame frame = this.getAppearanceFrame();
        if (SwingUtilities.getWindowAncestor(this.getAppearancePanel()) != frame) {
            frame.getContentPane().removeAll();
            frame.getContentPane().add((Component)this.getAppearancePanel(), "Center");
            frame.pack();
        }
        if ((gc = this.getGraphicsConfiguration()) != null && !gc.equals(frame.getGraphicsConfiguration())) {
            int x = gc.getBounds().x;
            int y = gc.getBounds().y;
            frame.setLocation(x, y);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.requestFocus();
    }

    void update(DRenderingEngine re) {
        AnnotationToggleButton btn;
        this.re = re;
        List annotations = re != null ? re.getCyAnnotator().getAnnotations() : Collections.emptyList();
        this.clearAnnotationButtonSelection();
        this.setEnabled(re != null);
        AnnotationTree annotationTree = AnnotationTree.buildTree(annotations, re == null ? null : re.getCyAnnotator());
        this.getBackgroundLayerPanel().update(annotationTree, "background");
        this.getForegroundLayerPanel().update(annotationTree, "foreground");
        if (this.isEnabled() && (btn = this.buttonMap.get(ArrowAnnotation.class)) != null) {
            btn.setEnabled(this.getAnnotationCount() > 0);
        }
        this.updateEditor();
        this.updateSelectionLabel();
        this.updateSelectionButtons();
        this.updateMoveToCanvasButtons();
    }

    void updateEditor() {
        AbstractAnnotationEditor<Annotation> comp;
        AnnotationFactory<? extends Annotation> f;
        AnnotationToggleButton btn;
        Annotation annotation;
        this.getAppearancePanel().removeEditor();
        Component editComp = ((BorderLayout)this.getAppearancePanel().getLayout()).getLayoutComponent("Center");
        if (editComp instanceof AbstractAnnotationEditor) {
            ((AbstractAnnotationEditor)editComp).setAnnotation(null);
        }
        if (!this.isCreateMode() && (annotation = this.editingAnnotation) instanceof DingAnnotation && (btn = this.buttonMap.get(((DingAnnotation)annotation).getType())) != null && (f = btn.getFactory()) instanceof AbstractDingAnnotationFactory && (comp = ((AbstractDingAnnotationFactory)f).getEditor()) != null) {
            comp.setAnnotation(annotation);
            this.getAppearancePanel().setEditor(comp);
            if (this.getAppearancePanel().isFloating()) {
                this.getAppearanceFrame().pack();
            }
        }
        this.getAppearancePanel().update();
        this.getContentTabbedPane().revalidate();
        this.getContentTabbedPane().repaint();
    }

    void updateSelectionLabel() {
        int total = this.getAnnotationCount();
        if (total == 0) {
            this.getSelectionLabel().setText(null);
        } else {
            int selected = this.getSelectedAnnotationCount();
            this.getSelectionLabel().setText(selected + " of " + total + " Annotation" + (total == 1 ? "" : "s") + " selected");
        }
    }

    private void updateRemoveAnnotationsButton() {
        this.getRemoveAnnotationsButton().setEnabled(this.isEnabled() && this.getSelectedAnnotationCount() > 0);
    }

    private void updateGroupUngroupButton() {
        List<Annotation> annotations = this.getSelectedAnnotations();
        this.getGroupAnnotationsButton().setEnabled(this.isEnabled() && annotations.size() > 1 && AnnotationTree.hasSameParent(annotations));
        this.getUngroupAnnotationsButton().setEnabled(this.isEnabled() && this.getSelectedAnnotationCount(GroupAnnotation.class) > 0);
    }

    void updateSelectionButtons() {
        int total = this.getAnnotationCount();
        int selected = this.getSelectedAnnotationCount();
        this.getSelectAllButton().setEnabled(this.isEnabled() && selected < total);
        this.getSelectNoneButton().setEnabled(this.isEnabled() && selected > 0);
    }

    void updateMoveToCanvasButtons() {
        this.getPushToBackgroundButton().setEnabled(this.getSelectedAnnotationCount(this.getForegroundTree(), DingAnnotation.class) > 0);
        this.getPullToForegroundButton().setEnabled(this.getSelectedAnnotationCount(this.getBackgroundTree(), DingAnnotation.class) > 0);
    }

    void updateAnnotationsOrder() {
        List<Annotation> selectedAnnotations = this.getSelectedAnnotations();
        List annotations = this.re != null ? this.re.getCyAnnotator().getAnnotations() : Collections.emptyList();
        AnnotationTree annotationTree = AnnotationTree.buildTree(annotations, this.re.getCyAnnotator());
        this.getBackgroundLayerPanel().update(annotationTree, "background");
        this.getForegroundLayerPanel().update(annotationTree, "foreground");
        this.getBackgroundTree().clearSelection();
        this.getForegroundTree().clearSelection();
        for (Annotation a : selectedAnnotations) {
            this.setSelected(a, true);
        }
        this.getBackgroundLayerPanel().updateButtons();
        this.getForegroundLayerPanel().updateButtons();
    }

    void maybeUpdateEditingAnnotation(Annotation candidate) {
        if (candidate == null) {
            this.setEditingAnnotation(null);
            return;
        }
        if (this.isCreateMode() || candidate != null && candidate.isSelected() && candidate.equals(this.editingAnnotation)) {
            return;
        }
        Annotation selected = null;
        if (candidate != null && candidate.isSelected() && !(candidate instanceof GroupAnnotation)) {
            selected = candidate;
        } else {
            Stack<Annotation> stack = new Stack<Annotation>();
            if (candidate != null && candidate.isSelected()) {
                stack.add(candidate);
            }
            stack.addAll(this.getSelectedAnnotations(this.getForegroundTree()));
            stack.addAll(this.getSelectedAnnotations(this.getBackgroundTree()));
            while (!stack.isEmpty()) {
                Annotation a = (Annotation)stack.pop();
                if (!a.isSelected()) continue;
                selected = a;
                break;
            }
        }
        this.setEditingAnnotation(selected);
    }

    void stopTreeCellEditing() {
        this.stopCellEditing(this.getBackgroundTree());
        this.stopCellEditing(this.getForegroundTree());
    }

    void stopCellEditing(JTree tree) {
        if (tree.isEditing()) {
            tree.stopEditing();
        }
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getGroupAnnotationsButton(), this.getUngroupAnnotationsButton(), this.getRemoveAnnotationsButton()});
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.getSelectAllButton(), this.getSelectNoneButton()});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getToolBarPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getContentTabbedPane(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getToolBarPanel(), -2, -1, -2).addComponent(this.getContentTabbedPane(), -1, -1, Short.MAX_VALUE));
        this.setEnabled(false);
    }

    JPanel getToolBarPanel() {
        if (this.toolBarPanel == null) {
            this.toolBarPanel = new JPanel();
            this.toolBarPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            if (LookAndFeelUtil.isAquaLAF()) {
                this.toolBarPanel.setOpaque(false);
            }
            GroupLayout layout = new GroupLayout(this.toolBarPanel);
            this.toolBarPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            this.btnHGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(this.btnHGroup).addGap(0, 0, Short.MAX_VALUE)));
            this.btnVGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER, true);
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(this.btnVGroup));
        }
        return this.toolBarPanel;
    }

    JTabbedPane getContentTabbedPane() {
        if (this.contentTabbedPane == null) {
            this.contentTabbedPane = new JTabbedPane(1);
            this.contentTabbedPane.addTab("Layers", this.getLayersPanel());
            this.contentTabbedPane.addTab("Appearance", this.getAppearancePanel());
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.contentTabbedPane});
        }
        return this.contentTabbedPane;
    }

    AppearancePanel getAppearancePanel() {
        if (this.appearancePanel == null) {
            this.appearancePanel = new AppearancePanel();
        }
        return this.appearancePanel;
    }

    JPanel getLayersPanel() {
        if (this.layersPanel == null) {
            this.layersPanel = new JPanel();
            this.layersPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.layersPanel);
            this.layersPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            JPanel rightFiller = new JPanel();
            rightFiller.setPreferredSize(this.getRemoveAnnotationsButton().getPreferredSize());
            rightFiller.setOpaque(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getGroupAnnotationsButton(), -2, -1, -2).addComponent(this.getUngroupAnnotationsButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getSelectionLabel(), -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(rightFiller, -2, -1, -2).addComponent(this.getRemoveAnnotationsButton(), -2, -1, -2).addContainerGap()).addComponent(this.getForegroundLayerPanel(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getPushToBackgroundButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getPullToForegroundButton(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.getBackgroundLayerPanel(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getSelectAllButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSelectNoneButton(), -2, -1, -2).addContainerGap()));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getGroupAnnotationsButton(), -2, -1, -2).addComponent(this.getUngroupAnnotationsButton(), -2, -1, -2).addComponent(this.getSelectionLabel(), -2, -1, -2).addComponent(rightFiller, -2, -1, -2).addComponent(this.getRemoveAnnotationsButton(), -2, -1, -2)).addComponent(this.getForegroundLayerPanel(), -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getPushToBackgroundButton(), -2, -1, -2).addComponent(this.getPullToForegroundButton(), -2, -1, -2)).addComponent(this.getBackgroundLayerPanel(), -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.getSelectAllButton(), -2, -1, -2).addComponent(this.getSelectNoneButton(), -2, -1, -2)));
        }
        return this.layersPanel;
    }

    private JLabel getSelectionLabel() {
        if (this.selectionLabel == null) {
            this.selectionLabel = new JLabel();
            this.selectionLabel.setHorizontalAlignment(0);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.selectionLabel});
        }
        return this.selectionLabel;
    }

    JButton getGroupAnnotationsButton() {
        if (this.groupAnnotationsButton == null) {
            this.groupAnnotationsButton = new JButton("\uf247");
            this.groupAnnotationsButton.setToolTipText("Group Selected Annotations");
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.styleToolBarButton(this.groupAnnotationsButton, iconManager.getIconFont(16.0f));
        }
        return this.groupAnnotationsButton;
    }

    JButton getUngroupAnnotationsButton() {
        if (this.ungroupAnnotationsButton == null) {
            this.ungroupAnnotationsButton = new JButton("\uf248");
            this.ungroupAnnotationsButton.setToolTipText("Ungroup Selected Annotations");
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.styleToolBarButton(this.ungroupAnnotationsButton, iconManager.getIconFont(16.0f));
        }
        return this.ungroupAnnotationsButton;
    }

    JButton getRemoveAnnotationsButton() {
        if (this.removeAnnotationsButton == null) {
            this.removeAnnotationsButton = new JButton("\uf014");
            this.removeAnnotationsButton.setToolTipText("Remove Selected Annotations");
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.styleToolBarButton(this.removeAnnotationsButton, iconManager.getIconFont(18.0f));
        }
        return this.removeAnnotationsButton;
    }

    JButton getPushToBackgroundButton() {
        if (this.pushToBackgroundButton == null) {
            this.pushToBackgroundButton = new JButton("\uf063");
            this.pushToBackgroundButton.setToolTipText("Push Annotations to Background Layer");
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.styleToolBarButton(this.pushToBackgroundButton, iconManager.getIconFont(12.0f));
        }
        return this.pushToBackgroundButton;
    }

    JButton getPullToForegroundButton() {
        if (this.pullToForegroundButton == null) {
            this.pullToForegroundButton = new JButton("\uf062");
            this.pullToForegroundButton.setToolTipText("Pull Annotations to Foreground Layer");
            IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
            this.styleToolBarButton(this.pullToForegroundButton, iconManager.getIconFont(12.0f));
        }
        return this.pullToForegroundButton;
    }

    LayerPanel getForegroundLayerPanel() {
        if (this.foregroundLayerPanel == null) {
            this.foregroundLayerPanel = new LayerPanel("foreground");
        }
        return this.foregroundLayerPanel;
    }

    LayerPanel getBackgroundLayerPanel() {
        if (this.backgroundLayerPanel == null) {
            this.backgroundLayerPanel = new LayerPanel("background");
        }
        return this.backgroundLayerPanel;
    }

    JTree getForegroundTree() {
        return this.getForegroundLayerPanel().getTree();
    }

    JTree getBackgroundTree() {
        return this.getBackgroundLayerPanel().getTree();
    }

    JTree getLayerTree(String canvasName) {
        return "background".equals(canvasName) ? this.getBackgroundTree() : this.getForegroundTree();
    }

    JButton getSelectAllButton() {
        if (this.selectAllButton == null) {
            this.selectAllButton = new JButton("Select All");
            this.selectAllButton.addActionListener(evt -> {
                if (this.getBackgroundTree().getRowCount() > 0) {
                    this.getBackgroundTree().setSelectionInterval(0, this.getBackgroundTree().getRowCount() - 1);
                }
                if (this.getForegroundTree().getRowCount() > 0) {
                    this.getForegroundTree().setSelectionInterval(0, this.getForegroundTree().getRowCount() - 1);
                }
                this.maybeUpdateEditingAnnotation(this.editingAnnotation);
            });
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.selectAllButton});
            if (LookAndFeelUtil.isAquaLAF()) {
                this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
                this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
            }
        }
        return this.selectAllButton;
    }

    JButton getSelectNoneButton() {
        if (this.selectNoneButton == null) {
            this.selectNoneButton = new JButton("Select None");
            this.selectNoneButton.addActionListener(evt -> {
                this.getBackgroundTree().clearSelection();
                this.getForegroundTree().clearSelection();
                this.maybeUpdateEditingAnnotation(null);
            });
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.selectNoneButton});
            if (LookAndFeelUtil.isAquaLAF()) {
                this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
                this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
            }
        }
        return this.selectNoneButton;
    }

    JFrame getAppearanceFrame() {
        if (this.appearanceFrame == null) {
            this.appearanceFrame = new JFrame("Annotation Appearance");
            this.appearanceFrame.setDefaultCloseOperation(1);
        }
        return this.appearanceFrame;
    }

    private void styleToolBarButton(AbstractButton btn, Font font) {
        if (font != null) {
            btn.setFont(font);
        }
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        btn.setContentAreaFilled(false);
        btn.setOpaque(false);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(1);
    }

    private Icon getDefIcon() {
        if (this.defIcon == null) {
            Font font = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f);
            this.defIcon = new TextIcon(new String[]{"X", "Y"}, font, new Color[]{UIManager.getColor("Label.foreground"), Color.WHITE}, 16, 16, new Integer[]{1});
        }
        return this.defIcon;
    }

    private Icon getClosedAnnotationIcon() {
        if (this.closedAnnotationIcon == null) {
            Font font = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(16.0f);
            this.closedAnnotationIcon = new TextIcon("\uf07b", font, UIManager.getColor("Label.foreground"), 16, 16);
        }
        return this.closedAnnotationIcon;
    }

    private Icon getOpenAnnotationIcon() {
        if (this.openAnnotationIcon == null) {
            Font font = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(16.0f);
            this.openAnnotationIcon = new TextIcon("\uf07c", font, UIManager.getColor("Label.foreground"), 16, 16);
        }
        return this.openAnnotationIcon;
    }

    private Icon getAnnotationIcon(Annotation a) {
        Icon icon = null;
        if (a instanceof DingAnnotation) {
            icon = this.iconMap.get(((DingAnnotation)a).getType());
        }
        return icon != null ? icon : this.getDefIcon();
    }

    class LayerPanel
    extends JPanel {
        private JLabel titleLabel;
        private JButton forwardButton;
        private JButton backwardButton;
        private JScrollPane scrollPane;
        private JTree tree;
        private final String canvasName;

        public LayerPanel(String canvasName) {
            this.canvasName = canvasName;
            this.init();
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            this.getTree().getSelectionModel().addTreeSelectionListener(e -> {
                AnnotationMainPanel.this.stopTreeCellEditing();
                AnnotationMainPanel.this.updateSelectionLabel();
                AnnotationMainPanel.this.updateGroupUngroupButton();
                AnnotationMainPanel.this.updateRemoveAnnotationsButton();
                AnnotationMainPanel.this.updateMoveToCanvasButtons();
                this.updateButtons();
            });
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.getTree().setEnabled(enabled);
            this.getTitleLabel().setEnabled(enabled);
            this.updateButtons();
        }

        JButton getForwardButton() {
            if (this.forwardButton == null) {
                this.forwardButton = new JButton("\uf0d8");
                this.forwardButton.setToolTipText("Bring Annotations Forward");
                IconManager iconManager = (IconManager)AnnotationMainPanel.this.serviceRegistrar.getService(IconManager.class);
                AnnotationMainPanel.this.styleToolBarButton(this.forwardButton, iconManager.getIconFont(17.0f));
            }
            return this.forwardButton;
        }

        JButton getBackwardButton() {
            if (this.backwardButton == null) {
                this.backwardButton = new JButton("\uf0d7");
                this.backwardButton.setToolTipText("Send Annotations Backward");
                IconManager iconManager = (IconManager)AnnotationMainPanel.this.serviceRegistrar.getService(IconManager.class);
                AnnotationMainPanel.this.styleToolBarButton(this.backwardButton, iconManager.getIconFont(17.0f));
            }
            return this.backwardButton;
        }

        JScrollPane getScrollPane() {
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane(this.getTree());
                this.scrollPane.setViewportView(this.getTree());
                this.scrollPane.getViewport().setOpaque(false);
                this.scrollPane.getViewport().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        AnnotationMainPanel.this.stopCellEditing(LayerPanel.this.getTree());
                        LayerPanel.this.getTree().clearSelection();
                        LayerPanel.this.scrollPane.requestFocusInWindow();
                    }
                });
                this.scrollPane.setBackground(TREE_BG_COLOR);
                this.scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
            }
            return this.scrollPane;
        }

        JTree getTree() {
            if (this.tree == null) {
                final AnnotationTreeCellRenderer annotationCellRenderer = new AnnotationTreeCellRenderer();
                this.tree = new JTree(new AnnotationTreeModel(null, null)){

                    @Override
                    public TreeCellRenderer getCellRenderer() {
                        return annotationCellRenderer;
                    }

                    @Override
                    public Color getBackground() {
                        return TREE_BG_COLOR;
                    }

                    @Override
                    public void paintComponent(Graphics g) {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        int[] rows = this.getSelectionRows();
                        if (rows != null) {
                            for (int i : rows) {
                                Rectangle r = this.getRowBounds(i);
                                g.setColor(TREE_SEL_BG_COLOR);
                                g.fillRect(0, r.y, this.getWidth(), r.height);
                            }
                        }
                        super.paintComponent(g);
                    }

                    @Override
                    public void setModel(TreeModel newModel) {
                        super.setModel(newModel);
                        this.setRootVisible(true);
                        this.setRootVisible(false);
                        this.expandRow(0);
                    }
                };
                this.tree.setUI(new BasicTreeUI(){

                    @Override
                    public Rectangle getPathBounds(JTree tree, TreePath path) {
                        if (tree != null && this.treeState != null) {
                            return this.getPathBounds(path, tree.getInsets(), new Rectangle());
                        }
                        return null;
                    }

                    private Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
                        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
                            bounds.width = this.tree.getWidth();
                            bounds.y += insets.top;
                        }
                        return bounds;
                    }
                });
                this.tree.setName(this.canvasName);
                this.tree.setOpaque(false);
                this.tree.setRowHeight(24);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.tree});
                this.tree.setEditable(true);
                this.tree.setToggleClickCount(0);
                this.tree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
                this.tree.setInvokesStopCellEditing(true);
                JTextField textField = new JTextField();
                textField.setEditable(true);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{textField});
                DefaultCellEditor txtEditor = new DefaultCellEditor(textField);
                AnnotationTreeCellEditor editor = new AnnotationTreeCellEditor(this.tree, annotationCellRenderer, txtEditor);
                editor.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingStopped(ChangeEvent evt) {
                        AnnotationMainPanel.this.getBackgroundTree().repaint();
                        AnnotationMainPanel.this.getForegroundTree().repaint();
                    }

                    @Override
                    public void editingCanceled(ChangeEvent evt) {
                    }
                });
                this.tree.setCellEditor(editor);
                this.tree.setShowsRootHandles(true);
                this.tree.expandRow(0);
                this.tree.setRootVisible(false);
                this.tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        int row = LayerPanel.this.tree.getRowForLocation(evt.getPoint().x, evt.getPoint().y);
                        if (row < 0) {
                            AnnotationMainPanel.this.stopCellEditing(LayerPanel.this.tree);
                            LayerPanel.this.tree.clearSelection();
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        TreePath selectionPath;
                        if (evt.getClickCount() == 2 && (selectionPath = LayerPanel.this.tree.getSelectionPath()) != null) {
                            LayerPanel.this.tree.startEditingAtPath(selectionPath);
                        }
                    }
                });
            }
            return this.tree;
        }

        private void init() {
            if (LookAndFeelUtil.isAquaLAF()) {
                this.setOpaque(false);
            }
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(layout.createSequentialGroup().addComponent(this.getTitleLabel(), -1, -1, Short.MAX_VALUE).addGap(10, 10, Short.MAX_VALUE).addComponent(this.getForwardButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBackwardButton(), -2, -1, -2)).addComponent(this.getScrollPane(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getTitleLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getForwardButton(), -2, -1, -2).addComponent(this.getBackwardButton(), -2, -1, -2)).addComponent(this.getScrollPane(), -1, -1, Short.MAX_VALUE));
        }

        private JLabel getTitleLabel() {
            if (this.titleLabel == null) {
                String text = this.canvasName.toLowerCase() + " Layer";
                text = text.substring(0, 1).toUpperCase() + text.substring(1);
                this.titleLabel = new JLabel(text);
                this.titleLabel.setVerticalAlignment(3);
                this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 12));
                Border tb = LookAndFeelUtil.createTitledBorder((String)text);
                if (tb instanceof TitledBorder) {
                    this.titleLabel.setFont(((TitledBorder)tb).getTitleFont());
                } else {
                    LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleLabel});
                }
            }
            return this.titleLabel;
        }

        private void update(AnnotationTree annotationTree, String canvas) {
            Annotation a;
            AnnotationNode node;
            TreePath path;
            int i;
            JTree tree = this.getTree();
            HashSet<GroupAnnotation> collapsedGroups = new HashSet<GroupAnnotation>();
            for (i = 0; i < tree.getRowCount(); ++i) {
                path = tree.getPathForRow(i);
                node = (AnnotationNode)path.getLastPathComponent();
                a = node.getAnnotation();
                if (!(a instanceof GroupAnnotation) || !tree.isCollapsed(path)) continue;
                collapsedGroups.add((GroupAnnotation)a);
            }
            tree.setModel(new AnnotationTreeModel(annotationTree, canvas));
            for (i = 0; i < tree.getRowCount(); ++i) {
                path = tree.getPathForRow(i);
                node = (AnnotationNode)path.getLastPathComponent();
                a = node.getAnnotation();
                if (!(a instanceof GroupAnnotation)) continue;
                if (collapsedGroups.contains(a)) {
                    tree.collapsePath(path);
                    continue;
                }
                tree.expandPath(path);
            }
            this.updateButtons();
        }

        private void updateButtons() {
            this.getForwardButton().setEnabled(false);
            this.getBackwardButton().setEnabled(false);
            JTree tree = this.getTree();
            AnnotationTree annotationTree = ((AnnotationTreeModel)tree.getModel()).tree;
            if (annotationTree != null) {
                List<Annotation> selectedAnnotations = AnnotationMainPanel.this.getSelectedAnnotations(tree);
                boolean forward = annotationTree.shiftAllowed(AnnotationTree.Shift.UP_ONE, this.canvasName, selectedAnnotations);
                boolean backward = annotationTree.shiftAllowed(AnnotationTree.Shift.DOWN_ONE, this.canvasName, selectedAnnotations);
                this.getForwardButton().setEnabled(forward);
                this.getBackwardButton().setEnabled(backward);
            }
        }
    }

    class AppearancePanel
    extends JPanel {
        static final String TITLE = "Appearance";
        private JPanel topPanel;
        private JLabel infoLabel;
        private JButton windowStateButton;

        private AppearancePanel() {
            this.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.getTopPanel(), "North");
            this.add((Component)new JLabel(""), "South");
            this.update();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updateWindowStateButton();
        }

        void removeEditor() {
            Component editComp = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (editComp != null) {
                this.remove(editComp);
                if (editComp instanceof AbstractAnnotationEditor) {
                    ((AbstractAnnotationEditor)editComp).setAnnotation(null);
                }
            }
        }

        void setEditor(AbstractAnnotationEditor comp) {
            this.removeEditor();
            if (comp != null) {
                this.add((Component)comp, "Center");
            }
        }

        boolean isFloating() {
            return SwingUtilities.getWindowAncestor(this) == AnnotationMainPanel.this.getAppearanceFrame();
        }

        void update() {
            this.updateWindowStateButton();
            this.updateInfoLabel();
        }

        private void updateWindowStateButton() {
            IconManager iconManager = (IconManager)AnnotationMainPanel.this.serviceRegistrar.getService(IconManager.class);
            Font font = this.isFloating() ? iconManager.getIconFont("cytoscape-3", 11.0f) : iconManager.getIconFont(11.0f);
            this.getWindowStateButton().setFont(font);
            this.getWindowStateButton().setText(this.isFloating() ? "'" : "\uf2d0");
            this.getWindowStateButton().setToolTipText(this.isFloating() ? "Dock" : "Float");
        }

        private void updateInfoLabel() {
            Object text = " ";
            if (AnnotationMainPanel.this.isCreateMode()) {
                for (AnnotationToggleButton btn : AnnotationMainPanel.this.buttonMap.values()) {
                    if (!btn.isSelected()) continue;
                    text = "New " + btn.getFactory().getName() + ": ";
                    text = ArrowAnnotation.class.equals((Object)btn.getFactory().getType()) ? (String)text + "Click another annotation in the view..." : (String)text + "Click anywhere on the view to add it...";
                    break;
                }
            } else if (AnnotationMainPanel.this.editingAnnotation instanceof ArrowAnnotationImpl && ((ArrowAnnotationImpl)AnnotationMainPanel.this.editingAnnotation).getCyAnnotator().getRepositioningArrow() != null) {
                text = (String)text + "Click another annotation or node to create the arrow...";
            } else if (AnnotationMainPanel.this.isEditMode()) {
                String name = AnnotationMainPanel.this.editingAnnotation.getName();
                text = "Edit ";
                text = AnnotationMainPanel.this.editingAnnotation instanceof TextAnnotation || AnnotationMainPanel.this.editingAnnotation instanceof BoundedTextAnnotation ? (String)text + (AnnotationMainPanel.this.editingAnnotation instanceof BoundedTextAnnotation ? "Bounded Text" : "Text") : (String)text + (String)(name != null && !name.isBlank() ? "\"" + name + "\"" : "");
                text = (String)text + ":";
            } else if (this.isEnabled()) {
                text = "Select the annotation you want to add or modify...";
            }
            this.getInfoLabel().setText((String)text);
        }

        private JPanel getTopPanel() {
            if (this.topPanel == null) {
                this.topPanel = new JPanel();
                this.topPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
                this.topPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, UIManager.getColor("Separator.foreground")));
                GroupLayout layout = new GroupLayout(this.topPanel);
                this.topPanel.setLayout(layout);
                layout.setAutoCreateContainerGaps(false);
                layout.setAutoCreateGaps(true);
                JPanel leftFiller = new JPanel();
                leftFiller.setPreferredSize(this.getWindowStateButton().getPreferredSize());
                leftFiller.setOpaque(!LookAndFeelUtil.isAquaLAF());
                layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent(leftFiller, -2, -1, -2).addComponent(this.getInfoLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getWindowStateButton(), -2, -1, -2).addContainerGap());
                layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(leftFiller, -2, -1, -2).addComponent(this.getInfoLabel(), -2, -1, -2).addComponent(this.getWindowStateButton(), -2, -1, -2)).addGap(5));
            }
            return this.topPanel;
        }

        private JLabel getInfoLabel() {
            if (this.infoLabel == null) {
                this.infoLabel = new JLabel(" ");
                this.infoLabel.setHorizontalAlignment(0);
                this.infoLabel.setEnabled(false);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.infoLabel});
            }
            return this.infoLabel;
        }

        private JButton getWindowStateButton() {
            if (this.windowStateButton == null) {
                this.windowStateButton = new JButton("\uf2d0");
                this.windowStateButton.setToolTipText("Float");
                ViewUtils.styleWindowStateButton(this.windowStateButton);
                this.windowStateButton.setFont(((IconManager)AnnotationMainPanel.this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
                this.windowStateButton.addActionListener(evt -> {
                    if (this.isFloating()) {
                        AnnotationMainPanel.this.dockAppearancePanel();
                    } else {
                        AnnotationMainPanel.this.floatAppearancePanel();
                    }
                });
            }
            return this.windowStateButton;
        }
    }

    class AnnotationTreeModel
    extends DefaultTreeModel {
        private AnnotationTree tree;
        private String canvas;

        public AnnotationTreeModel(AnnotationTree tree, String canvas) {
            super(null);
            if (tree != null && canvas != null) {
                AnnotationNode root = tree.getRoot(canvas);
                this.setRoot(root);
                this.tree = tree;
                this.canvas = canvas;
            }
        }

        @Override
        public AnnotationNode getRoot() {
            return (AnnotationNode)super.getRoot();
        }

        public List<Annotation> getData() {
            return this.getRoot().depthFirstOrder();
        }

        public TreePath pathTo(Annotation a) {
            AnnotationNode node = this.tree.get(this.canvas, a);
            return node == null ? null : new TreePath(node.getPath());
        }
    }

    class AnnotationToggleButton
    extends JToggleButton {
        private final AnnotationFactory<? extends Annotation> factory;

        public AnnotationToggleButton(AnnotationFactory<? extends Annotation> f) {
            this.factory = f;
            Icon icon = f.getIcon();
            this.setIcon(icon != null ? icon : AnnotationMainPanel.this.getDefIcon());
            this.setToolTipText("<html>Add <b>" + f.getName() + " Annotation</b>...</html>");
            this.setHorizontalTextPosition(0);
        }

        public AnnotationFactory<? extends Annotation> getFactory() {
            return this.factory;
        }
    }

    class AnnotationTreeCellEditor
    extends DefaultTreeCellEditor {
        public AnnotationTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
            super(tree, renderer, editor);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof AnnotationNode) {
                value = ((AnnotationNode)value).getAnnotation().getName();
            }
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return super.isCellEditable(e) && this.lastPath != null && this.lastPath.getLastPathComponent() instanceof AnnotationNode;
        }

        @Override
        protected Container createContainer() {
            return new DefaultTreeCellEditor.EditorContainer(){

                @Override
                public void paint(Graphics g) {
                    Object obj;
                    if (AnnotationTreeCellEditor.this.lastPath != null && (obj = AnnotationTreeCellEditor.this.lastPath.getLastPathComponent()) instanceof AnnotationNode && !(((AnnotationNode)obj).getAnnotation() instanceof GroupAnnotation)) {
                        AnnotationTreeCellEditor.this.editingIcon = AnnotationMainPanel.this.getAnnotationIcon(((AnnotationNode)obj).getAnnotation());
                    }
                    super.paint(g);
                }
            };
        }
    }

    private final class AnnotationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private AnnotationTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setHorizontalAlignment(2);
            if (value instanceof AnnotationNode) {
                Annotation annotation = ((AnnotationNode)value).getAnnotation();
                if (annotation != null) {
                    this.setText(annotation.getName());
                    this.setToolTipText(annotation.getName());
                    this.setIconTextGap(8);
                }
                if (annotation instanceof GroupAnnotation) {
                    this.setOpenIcon(AnnotationMainPanel.this.getOpenAnnotationIcon());
                    this.setClosedIcon(AnnotationMainPanel.this.getClosedAnnotationIcon());
                } else {
                    Icon icon = AnnotationMainPanel.this.getAnnotationIcon(annotation);
                    this.setLeafIcon(icon);
                    this.setIcon(icon);
                }
            }
            if (selected) {
                this.setForeground(TREE_SEL_FG_COLOR);
                this.setBackground(TREE_SEL_BG_COLOR);
            } else {
                this.setBackground(TREE_BG_COLOR);
                this.setForeground(TREE_FG_COLOR);
            }
            return this;
        }
    }
}

