/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.AnnotationJsonConverter;
import org.cytoscape.ding.impl.cyannotator.tasks.ImageAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.ShapeAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.StandardAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.TextAnnotationTunables;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class UpdateAnnotationTask
extends AbstractTask
implements ObservableTask {
    @Tunable(context="nogui", required=true, description="The UUID or name of the annotation to be updated")
    public String uuidOrName;
    @ContainsTunables
    public StandardAnnotationTunables standardTunables;
    @ContainsTunables
    public TextAnnotationTunables textTunables;
    @ContainsTunables
    public ShapeAnnotationTunables shapeTunables;
    @ContainsTunables
    public ImageAnnotationTunables imageTunables;
    private Annotation updatedAnnotation;
    private final Class<? extends Annotation> type;
    private final CyServiceRegistrar serviceRegistrar;

    public UpdateAnnotationTask(Class<? extends Annotation> type, CyServiceRegistrar serviceRegistrar) {
        this.type = type;
        this.serviceRegistrar = serviceRegistrar;
        if (type.equals(ImageAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
            this.imageTunables = new ImageAnnotationTunables();
        } else if (type.equals(BoundedTextAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.textTunables = new TextAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
        } else if (type.equals(TextAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.textTunables = new TextAnnotationTunables();
        } else if (type.equals(ShapeAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
            this.shapeTunables = new ShapeAnnotationTunables();
        } else if (!type.equals(ArrowAnnotation.class) && type.equals(GroupAnnotation.class)) {
            this.standardTunables = new StandardAnnotationTunables();
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        CyNetworkView view;
        Annotation annotation;
        block13: {
            tm.setTitle("Update Annotation");
            UUID aUUID = null;
            String name = null;
            try {
                aUUID = UUID.fromString(this.uuidOrName);
            }
            catch (IllegalArgumentException e) {
                name = this.uuidOrName;
            }
            CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            AnnotationManager annotationManager = (AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class);
            annotation = null;
            view = null;
            if (aUUID != null) {
                for (CyNetworkView nv : viewManager.getNetworkViewSet()) {
                    for (Annotation a : annotationManager.getAnnotations(nv)) {
                        if (!a.getUUID().equals(aUUID)) continue;
                        annotation = a;
                        view = nv;
                        break block13;
                    }
                }
            } else if (name != null) {
                CyNetworkView currView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
                Set viewSet = currView != null ? Collections.singleton(currView) : viewManager.getNetworkViewSet();
                for (CyNetworkView nv : viewSet) {
                    for (Annotation a : annotationManager.getAnnotations(nv)) {
                        if (!name.equals(a.getName())) continue;
                        annotation = a;
                        view = nv;
                        break block13;
                    }
                }
            }
        }
        if (annotation != null) {
            try {
                this.updateAnnotation(tm, annotation, view);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updatedAnnotation = annotation;
        } else {
            tm.setStatusMessage("Can't find any annotation with UUID or name '" + this.uuidOrName + "'");
        }
    }

    private void updateAnnotation(TaskMonitor tm, Annotation annotation, CyNetworkView view) {
        if (annotation instanceof ImageAnnotation) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
            this.imageTunables.update(tm, annotation);
        } else if (annotation instanceof BoundedTextAnnotation) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
            this.textTunables.update(tm, annotation);
        } else if (annotation instanceof TextAnnotation) {
            this.standardTunables.update(tm, annotation);
            this.textTunables.update(tm, annotation);
        } else if (annotation instanceof ShapeAnnotation) {
            this.standardTunables.update(tm, annotation);
            this.shapeTunables.update(tm, annotation);
        } else if (annotation instanceof GroupAnnotation) {
            this.standardTunables.update(tm, annotation);
        }
        if (this.standardTunables.canvas != null && view != null) {
            DingRenderer dingRenderer = (DingRenderer)this.serviceRegistrar.getService(DingRenderer.class);
            DRenderingEngine re = dingRenderer.getRenderingEngine(view);
            CyAnnotator cyAnnotator = re.getCyAnnotator();
            AnnotationTree tree = cyAnnotator.getAnnotationTree();
            tree.resetZOrder();
            cyAnnotator.fireAnnotationsReordered();
        }
        annotation.update();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Annotation.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(Annotation.class)) {
            return (R)this.updatedAnnotation;
        }
        if (type.equals(String.class)) {
            Object result = this.updatedAnnotation == null ? "Nothing added" : "Updated annotation " + this.updatedAnnotation.toString();
            return (R)result;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.updatedAnnotation == null) {
                    return "{}";
                }
                return AnnotationJsonConverter.toJson((DingAnnotation)this.updatedAnnotation);
            };
            return (R)res;
        }
        return null;
    }
}

