/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.tasks.AbstractAnnotationTunables;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class StandardAnnotationTunables
extends AbstractAnnotationTunables {
    static final String[] CANVASES = new String[]{"foreground", "background"};
    @Tunable(context="nogui", description="The new name for this annotation, which will appear to users in the Annotations Panel")
    public String newName = null;
    @Tunable(context="nogui", required=true, description="The X location for the annotation, in network view units")
    public Double x = null;
    @Tunable(context="nogui", required=true, description="The Y location for the annotation, in network view units")
    public Double y = null;
    @Tunable(context="nogui", description="The Z order for the annotation")
    public Double z = null;
    @Tunable(context="nogui", description="The angle (in degrees) of the annotation")
    public Double angle = null;
    @Tunable(context="nogui", description="The canvas layer this annotation should be on")
    public String canvas = null;

    public Map<String, String> getArgMap(TaskMonitor tm) {
        HashMap<String, String> args = new HashMap<String, String>();
        this.putIfNotNull(tm, args, "x", this.x);
        this.putIfNotNull(tm, args, "y", this.y);
        this.putIfNotNull(tm, args, "z", this.z);
        this.putIfNotNull(tm, args, "name", this.newName);
        this.putIfNotNull(tm, args, "rotation", this.angle);
        this.putIfNotNull(tm, args, "canvas", this.canvas, Arrays.asList(CANVASES));
        return args;
    }

    public void update(TaskMonitor tm, Annotation annotation) {
        Map argMap = annotation.getArgMap();
        if (this.x != null || this.y != null) {
            if (this.x == null) {
                this.x = Double.valueOf((String)argMap.get("x"));
            }
            if (this.y == null) {
                this.y = Double.valueOf((String)argMap.get("y"));
            }
            annotation.moveAnnotation((Point2D)new Point2D.Double(this.x, this.y));
        }
        if (this.canvas != null) {
            annotation.setCanvas(this.canvas);
        }
        if (this.newName != null) {
            annotation.setName(this.newName);
        }
        if (this.angle != null) {
            annotation.setRotation(this.angle.doubleValue());
        }
    }
}

