/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ReorderAnnotationsTask
extends AbstractTask {
    private final DRenderingEngine re;
    private final List<DingAnnotation> annotations;
    private final String canvasName;
    private final AnnotationTree.Shift shift;

    public ReorderAnnotationsTask(DRenderingEngine re, Collection<DingAnnotation> annotations, String canvasName, AnnotationTree.Shift shift) {
        this.re = re;
        this.annotations = annotations != null ? new ArrayList<DingAnnotation>(annotations) : Collections.emptyList();
        this.canvasName = canvasName;
        this.shift = shift;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Reorder Annotations");
        if (this.re == null) {
            return;
        }
        if (this.annotations.isEmpty()) {
            return;
        }
        if (this.canvasName == null && this.shift == null) {
            return;
        }
        CyAnnotator cyAnnotator = this.re.getCyAnnotator();
        cyAnnotator.markUndoEdit("Reorder Annotations");
        if (this.canvasName != null) {
            this.changeCanvas();
        } else if (this.shift != null) {
            ViewUtils.reorder(this.annotations, this.shift, this.re);
        }
        cyAnnotator.postUndoEdit();
        cyAnnotator.fireAnnotationsReordered();
    }

    private void changeCanvas() {
        DingAnnotation.CanvasID id = DingAnnotation.CanvasID.fromArgName(this.canvasName);
        for (DingAnnotation da : this.annotations) {
            da.changeCanvas(id);
        }
        CyAnnotator cyAnnotator = this.re.getCyAnnotator();
        AnnotationTree tree = cyAnnotator.getAnnotationTree();
        tree.resetZOrder();
        this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
    }
}

