/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class RemoveSelectedAnnotationsTask
extends AbstractTask {
    private final DRenderingEngine re;
    private final Collection<? extends Annotation> annotations;
    private final CyServiceRegistrar serviceRegistrar;

    public RemoveSelectedAnnotationsTask(DRenderingEngine re, Collection<? extends Annotation> annotations, CyServiceRegistrar serviceRegistrar) {
        this.re = re;
        this.annotations = annotations;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Remove Annotations");
        tm.setProgress(-1.0);
        if (this.re != null && this.annotations != null && !this.annotations.isEmpty()) {
            tm.setStatusMessage("Deleting " + this.annotations.size() + " annotation(s)...");
            CyAnnotator annotator = this.re.getCyAnnotator();
            annotator.markUndoEdit("Remove Annotations");
            Collection<? extends Annotation> newList = this.annotations;
            while (!(newList = this.remove(newList)).isEmpty()) {
            }
            annotator.postUndoEdit();
        }
    }

    private Collection<? extends Annotation> remove(Collection<? extends Annotation> list) {
        Set<GroupAnnotation> groups = this.getGroups(list);
        ((AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class)).removeAnnotations(list);
        Iterator<GroupAnnotation> iter = groups.iterator();
        while (iter.hasNext()) {
            GroupAnnotation g = iter.next();
            List members = g.getMembers();
            if (members == null) continue;
            if (members.size() > 1) {
                iter.remove();
                continue;
            }
            members.forEach(a -> g.removeMember(a));
        }
        return groups;
    }

    private Set<GroupAnnotation> getGroups(Collection<? extends Annotation> list) {
        HashSet<GroupAnnotation> groups = new HashSet<GroupAnnotation>();
        list.forEach(a -> {
            GroupAnnotation g;
            if (a instanceof DingAnnotation && (g = ((DingAnnotation)a).getGroupParent()) != null) {
                groups.add(g);
            }
        });
        return groups;
    }
}

