/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.tasks.AbstractAnnotationTunables;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ImageAnnotationTunables
extends AbstractAnnotationTunables {
    @Tunable(context="nogui", required=true, description="The url of the image to be displayed")
    public String url = null;
    @Tunable(context="nogui", description="The image contrast adjustment")
    public Integer contrast = null;
    @Tunable(context="nogui", description="The image brightness adjustment")
    public Integer brightness = null;
    @Tunable(context="nogui", description="The image opacity adjustment (0-100)")
    public Double opacity = null;

    public Map<String, String> getArgMap(TaskMonitor tm) {
        HashMap<String, String> args = new HashMap<String, String>();
        this.putIfNotNull(tm, args, "URL", this.url);
        this.putIfNotNull(tm, args, "contrast", this.contrast);
        this.putIfNotNull(tm, args, "brightness", this.brightness);
        if (this.opacity != null) {
            this.putIfNotNull(tm, args, "opacity", Float.valueOf(this.opacity.floatValue() / 100.0f));
        }
        return args;
    }

    public void update(TaskMonitor tm, Annotation annotation) {
        ImageAnnotation iAnnotation = (ImageAnnotation)annotation;
        if (this.url != null) {
            try {
                iAnnotation.setImage(new URL(this.url));
            }
            catch (Exception e) {
                tm.setStatusMessage(e.getMessage());
            }
        }
        if (this.contrast != null) {
            iAnnotation.setImageContrast(this.contrast.intValue());
        }
        if (this.brightness != null) {
            iAnnotation.setImageBrightness(this.brightness.intValue());
        }
        if (this.opacity != null) {
            iAnnotation.setImageOpacity(this.opacity.floatValue() / 100.0f);
        }
    }
}

