/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Function;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;

public class AnnotationJsonConverter {
    public static String toJson(DingAnnotation annotation) {
        Map args = annotation.getArgMap();
        ObjectMapper objectMapper = new ObjectMapper();
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "lineColor");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "sourceColor");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "targetColor");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "color");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "fillColor");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertColor, args, "edgeColor");
        AnnotationJsonConverter.convert(AnnotationJsonConverter::convertFont, args, "fontStyle");
        try {
            return objectMapper.writeValueAsString((Object)args);
        }
        catch (JsonProcessingException e) {
            return "{\"error\":\"" + e.getMessage() + "\"}";
        }
    }

    private static void convert(Function<String, String> converter, Map<String, String> args, String key) {
        if (args.containsKey(key)) {
            String val = args.get(key);
            if ((val = converter.apply(val)) != null) {
                args.put(key, val);
            }
        }
    }

    private static String convertColor(String color) {
        try {
            int rgb = Integer.parseInt(color);
            return String.format("#%06X", 0xFFFFFF & rgb);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String convertFont(String fontCode) {
        try {
            int style = Integer.parseInt(fontCode);
            if (style == 0) {
                return "plain";
            }
            if (style == 1) {
                return "bold";
            }
            if (style == 2) {
                return "italic";
            }
            if (style == 3) {
                return "bolditalic";
            }
            return "";
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

