/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.ArrowAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.BoundedTextAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.ImageAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.ShapeAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.TextAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.tasks.AnnotationJsonConverter;
import org.cytoscape.ding.impl.cyannotator.tasks.ImageAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.ShapeAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.StandardAnnotationTunables;
import org.cytoscape.ding.impl.cyannotator.tasks.TextAnnotationTunables;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AddAnnotationCommandTask
extends AbstractTask
implements ObservableTask {
    private final AnnotationManager annotationManager;
    private final AnnotationFactory<?> annotationFactory;
    private Annotation newAnnotation;
    @Tunable(description="Network View", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", required=true, context="nogui")
    public CyNetworkView view = null;
    @ContainsTunables
    public StandardAnnotationTunables standardTunables = null;
    @ContainsTunables
    public TextAnnotationTunables textTunables = null;
    @ContainsTunables
    public ShapeAnnotationTunables shapeTunables = null;
    @ContainsTunables
    public ImageAnnotationTunables imageTunables = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AddAnnotationCommandTask(AnnotationManager annotationManager, AnnotationFactory<?> annotationFactory) {
        this.annotationManager = annotationManager;
        this.annotationFactory = annotationFactory;
        try {
            if (!(annotationFactory instanceof AbstractDingAnnotationFactory)) return;
            if (annotationFactory instanceof ImageAnnotationFactory) {
                this.standardTunables = new StandardAnnotationTunables();
                this.shapeTunables = new ShapeAnnotationTunables();
                this.imageTunables = new ImageAnnotationTunables();
                return;
            }
            if (annotationFactory instanceof BoundedTextAnnotationFactory) {
                this.standardTunables = new StandardAnnotationTunables();
                this.textTunables = new TextAnnotationTunables();
                this.shapeTunables = new ShapeAnnotationTunables();
                return;
            }
            if (annotationFactory instanceof TextAnnotationFactory) {
                this.standardTunables = new StandardAnnotationTunables();
                this.textTunables = new TextAnnotationTunables();
                return;
            }
            if (annotationFactory instanceof ShapeAnnotationFactory) {
                this.standardTunables = new StandardAnnotationTunables();
                this.shapeTunables = new ShapeAnnotationTunables();
                return;
            }
            if (!(annotationFactory instanceof ArrowAnnotationFactory)) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Add Annotation");
        if (this.view == null) {
            tm.setStatusMessage("No view selected");
            return;
        }
        try {
            if (this.annotationFactory instanceof ImageAnnotationFactory) {
                Map<String, String> args = this.standardTunables.getArgMap(tm);
                args.putAll(this.shapeTunables.getArgMap(tm));
                args.putAll(this.imageTunables.getArgMap(tm));
                this.newAnnotation = ((ImageAnnotationFactory)this.annotationFactory).createAnnotation(ImageAnnotation.class, this.view, args);
            } else if (this.annotationFactory instanceof BoundedTextAnnotationFactory) {
                Map<String, String> args = this.standardTunables.getArgMap(tm);
                args.putAll(this.shapeTunables.getArgMap(tm));
                args.putAll(this.textTunables.getArgMap(tm));
                this.newAnnotation = ((BoundedTextAnnotationFactory)this.annotationFactory).createAnnotation(BoundedTextAnnotation.class, this.view, args);
            } else if (this.annotationFactory instanceof TextAnnotationFactory) {
                Map<String, String> args = this.standardTunables.getArgMap(tm);
                args.putAll(this.textTunables.getArgMap(tm));
                this.newAnnotation = ((TextAnnotationFactory)this.annotationFactory).createAnnotation(TextAnnotation.class, this.view, args);
            } else if (this.annotationFactory instanceof ShapeAnnotationFactory) {
                Map<String, String> args = this.standardTunables.getArgMap(tm);
                args.putAll(this.shapeTunables.getArgMap(tm));
                this.newAnnotation = ((ShapeAnnotationFactory)this.annotationFactory).createAnnotation(ShapeAnnotation.class, this.view, args);
            } else if (this.annotationFactory instanceof ArrowAnnotationFactory) {
                // empty if block
            }
            this.annotationManager.addAnnotation(this.newAnnotation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Annotation.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(Annotation.class)) {
            return (R)this.newAnnotation;
        }
        if (type.equals(String.class)) {
            Object result = this.newAnnotation == null ? "Nothing added" : "Created annotation " + this.newAnnotation.toString();
            return (R)result;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.newAnnotation == null) {
                    return "{}";
                }
                return AnnotationJsonConverter.toJson((DingAnnotation)this.newAnnotation);
            };
            return (R)res;
        }
        return null;
    }
}

