/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.ding.impl.cyannotator.annotations.GraphicsUtilities;
import org.cytoscape.ding.impl.cyannotator.annotations.ShapeAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.utils.EnhancedSlider;
import org.cytoscape.ding.impl.cyannotator.utils.MultipleGradientEditor;
import org.cytoscape.ding.impl.cyannotator.utils.PointPicker;
import org.cytoscape.ding.impl.cyannotator.utils.ShapeIcon;
import org.cytoscape.ding.internal.util.ColorUtil;
import org.cytoscape.ding.internal.util.MathUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;

public class ShapeAnnotationEditor
extends AbstractAnnotationEditor<ShapeAnnotation> {
    private JLabel borderWidthLabel;
    private JLabel shapeLabel;
    private JLabel fillColorLabel;
    private JLabel fillOpacityLabel;
    private JLabel borderColorLabel;
    private JLabel borderOpacityLabel;
    private JLabel rotationLabel;
    private JList<String> shapeList;
    private JComboBox<FillType> fillTypeCombo;
    private ColorButton fillColorButton;
    private GradientButton fillGradientButton;
    private ColorButton borderColorButton;
    private EnhancedSlider fillOpacitySlider;
    private EnhancedSlider borderOpacitySlider;
    private JComboBox<Integer> borderWidthCombo;
    private EnhancedSlider rotationSlider;
    private Shape customShape;
    private boolean ignorePaintEvents;
    private static final LinearGradientPaint defaultGradientPaint = new LinearGradientPaint(new Point2D.Double(), new Point2D.Double(1.0, 0.0), new float[]{0.0f, 1.0f}, new Color[]{Color.WHITE, Color.BLACK});

    public ShapeAnnotationEditor(AnnotationFactory<ShapeAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
    }

    @Override
    public void setAnnotation(ShapeAnnotation annotation) {
        super.setAnnotation(annotation);
        if (annotation instanceof ShapeAnnotationImpl && ((ShapeAnnotationImpl)annotation).getShapeTypeEnum() == ShapeAnnotation.ShapeType.CUSTOM) {
            this.customShape = ((ShapeAnnotationImpl)annotation).getShape();
        }
    }

    @Override
    public void doUpdate() {
        if (this.annotation != null) {
            this.getShapeList().setSelectedValue(((ShapeAnnotation)this.annotation).getShapeType(), true);
            Paint fillPaint = ((ShapeAnnotation)this.annotation).getFillColor();
            if (fillPaint instanceof Color) {
                this.getFillTypeCombo().setSelectedItem((Object)FillType.COLOR);
            } else if (fillPaint instanceof MultipleGradientPaint) {
                this.getFillTypeCombo().setSelectedItem((Object)FillType.GRADIENT);
            } else {
                this.getFillTypeCombo().setSelectedItem((Object)FillType.NONE);
            }
            this.getFillColorButton().setColor(fillPaint instanceof Color ? (Color)fillPaint : Color.BLACK);
            this.ignorePaintEvents = true;
            this.getFillGradientButton().setPaint(fillPaint instanceof MultipleGradientPaint ? (MultipleGradientPaint)fillPaint : defaultGradientPaint);
            this.ignorePaintEvents = false;
            int fillOpacity = (int)((ShapeAnnotation)this.annotation).getFillOpacity();
            this.getFillOpacitySlider().setValue(fillOpacity);
            int borderWidth = (int)((ShapeAnnotation)this.annotation).getBorderWidth();
            Color borderColor = ((ShapeAnnotation)this.annotation).getBorderColor() instanceof Color ? (Color)((ShapeAnnotation)this.annotation).getBorderColor() : null;
            int borderOpacity = (int)((ShapeAnnotation)this.annotation).getBorderOpacity();
            this.getBorderColorButton().setColor(borderColor != null ? borderColor : Color.BLACK);
            this.getBorderOpacitySlider().setValue(borderOpacity);
            ComboBoxModel<Integer> model = this.getBorderWidthCombo().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (borderWidth != (Integer)model.getElementAt(i)) continue;
                this.getBorderWidthCombo().setSelectedIndex(i);
                break;
            }
            double rotation = ((ShapeAnnotation)this.annotation).getRotation();
            this.getRotationSlider().setValue((int)rotation);
        }
        this.updateEnabled();
        this.updateFillButtons();
    }

    @Override
    public void apply(ShapeAnnotation annotation) {
        if (annotation != null) {
            String shapeType = this.getShapeList().getSelectedValue();
            if (ShapeAnnotation.ShapeType.CUSTOM.shapeName().equals(shapeType)) {
                annotation.setCustomShape(this.customShape);
            } else {
                annotation.setShapeType(shapeType);
            }
            Paint fillPaint = null;
            FillType fillType = (FillType)((Object)this.getFillTypeCombo().getSelectedItem());
            if (fillType == FillType.COLOR) {
                fillPaint = this.getFillColorButton().getColor();
            } else if (fillType == FillType.GRADIENT) {
                fillPaint = this.getFillGradientButton().getPaint();
            }
            annotation.setFillColor(fillPaint);
            annotation.setFillOpacity((double)this.getFillOpacitySlider().getValue());
            annotation.setBorderWidth((double)((Integer)this.getBorderWidthCombo().getModel().getSelectedItem()).intValue());
            annotation.setBorderColor((Paint)this.getBorderColorButton().getColor());
            annotation.setBorderOpacity((double)this.getBorderOpacitySlider().getValue());
            annotation.setRotation((double)this.getRotationSlider().getValue());
        }
    }

    @Override
    protected void init() {
        this.borderWidthLabel = new JLabel("Border Width:");
        this.shapeLabel = new JLabel("Shape:");
        this.fillColorLabel = new JLabel("Fill:");
        this.fillOpacityLabel = new JLabel("Fill Opacity:");
        this.borderColorLabel = new JLabel("Border Color:");
        this.borderOpacityLabel = new JLabel("Border Opacity:");
        this.rotationLabel = ShapeAnnotationEditor.createRotationLabel();
        JScrollPane scrollPane = new JScrollPane(this.getShapeList(), 20, 31);
        JSeparator sep1 = new JSeparator();
        JSeparator sep2 = new JSeparator();
        int min = 160;
        int pref = 200;
        int max = 200;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.shapeLabel).addComponent(scrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.fillColorLabel).addComponent(this.fillOpacityLabel).addComponent(this.borderWidthLabel).addComponent(this.borderColorLabel).addComponent(this.borderOpacityLabel).addComponent(this.rotationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.getFillTypeCombo()).addComponent((Component)this.getFillColorButton()).addComponent(this.getFillGradientButton())).addComponent(this.getFillOpacitySlider(), 160, 200, 200).addComponent(sep1, -1, -1, Short.MAX_VALUE).addComponent(this.getBorderWidthCombo(), -2, -1, -2).addComponent((Component)this.getBorderColorButton()).addComponent(this.getBorderOpacitySlider(), 160, 200, 200).addComponent(sep2, -1, -1, Short.MAX_VALUE).addComponent(this.getRotationSlider(), 160, 200, 200))).addGap(0, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.shapeLabel).addComponent(scrollPane, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.fillColorLabel).addComponent(this.getFillTypeCombo(), -2, -1, -2).addComponent((Component)this.getFillColorButton(), -2, -1, -2).addComponent(this.getFillGradientButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fillOpacityLabel).addComponent(this.getFillOpacitySlider(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sep1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderWidthLabel).addComponent(this.getBorderWidthCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.borderColorLabel).addComponent((Component)this.getBorderColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.borderOpacityLabel).addComponent(this.getBorderOpacitySlider(), -2, -1, -2)).addComponent(sep2, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rotationLabel).addComponent(this.getRotationSlider(), -2, -1, -2)))));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.shapeLabel, this.fillColorLabel, this.fillOpacityLabel, this.borderColorLabel, this.borderOpacityLabel, this.borderWidthLabel, this.rotationLabel});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getFillTypeCombo(), this.getFillColorButton(), this.getFillGradientButton(), this.getFillOpacitySlider()});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getBorderColorButton(), this.getBorderOpacitySlider(), this.getBorderWidthCombo()});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getRotationSlider()});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{scrollPane});
    }

    private JList<String> getShapeList() {
        if (this.shapeList == null) {
            List<String> typeList = GraphicsUtilities.getSupportedShapes();
            typeList.remove(ShapeAnnotation.ShapeType.CUSTOM.shapeName());
            this.shapeList = new JList<String>(new Vector<String>(typeList));
            this.shapeList.setSelectionMode(0);
            this.shapeList.setCellRenderer(new DefaultListCellRenderer(){
                final Map<String, ShapeIcon> icons = new HashMap<String, ShapeIcon>();
                final int ICON_SIZE = 12;
                {
                    this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Shape shape;
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String shapeName = "" + value;
                    ShapeIcon shapeIcon = this.icons.get(shapeName);
                    if (shapeIcon == null && (shape = GraphicsUtilities.getShape(shapeName, 0.0, 0.0, 12.0, 12.0)) != null) {
                        shapeIcon = new ShapeIcon(shape, 12, 12);
                        this.icons.put(shapeName, shapeIcon);
                    }
                    this.setIcon(shapeIcon);
                    return this;
                }
            });
            this.shapeList.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            if (this.shapeList.getModel().getSize() > 0) {
                this.shapeList.setSelectedIndex(0);
            }
            this.shapeList.addListSelectionListener(evt -> this.apply());
        }
        return this.shapeList;
    }

    public JComboBox<FillType> getFillTypeCombo() {
        if (this.fillTypeCombo == null) {
            this.fillTypeCombo = new JComboBox<FillType>(FillType.values());
            this.fillTypeCombo.addActionListener(evt -> {
                this.updateFillButtons();
                this.updateEnabled();
                this.apply();
            });
        }
        return this.fillTypeCombo;
    }

    private ColorButton getFillColorButton() {
        if (this.fillColorButton == null) {
            this.fillColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.GRAY, false);
            this.fillColorButton.setToolTipText("Select fill color...");
            this.fillColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.fillColorButton;
    }

    private GradientButton getFillGradientButton() {
        if (this.fillGradientButton == null) {
            this.fillGradientButton = new GradientButton();
            this.fillGradientButton.setToolTipText("Edit fill gradient...");
            this.fillGradientButton.addPropertyChangeListener("paint", evt -> {
                if (!this.ignorePaintEvents) {
                    this.apply();
                }
            });
        }
        return this.fillGradientButton;
    }

    private ColorButton getBorderColorButton() {
        if (this.borderColorButton == null) {
            this.borderColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.GRAY, false);
            this.borderColorButton.setToolTipText("Select border color...");
            this.borderColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.borderColorButton;
    }

    private EnhancedSlider getFillOpacitySlider() {
        if (this.fillOpacitySlider == null) {
            this.fillOpacitySlider = new EnhancedSlider(100);
            this.fillOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.fillOpacitySlider;
    }

    private EnhancedSlider getBorderOpacitySlider() {
        if (this.borderOpacitySlider == null) {
            this.borderOpacitySlider = new EnhancedSlider(100);
            this.borderOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.borderOpacitySlider;
    }

    private JComboBox<Integer> getBorderWidthCombo() {
        if (this.borderWidthCombo == null) {
            this.borderWidthCombo = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
            this.borderWidthCombo.setSelectedIndex(1);
            this.borderWidthCombo.addActionListener(evt -> {
                this.updateEnabled();
                this.apply();
            });
        }
        return this.borderWidthCombo;
    }

    private EnhancedSlider getRotationSlider() {
        if (this.rotationSlider == null) {
            this.rotationSlider = this.createRotationSlider();
        }
        return this.rotationSlider;
    }

    private void updateEnabled() {
        FillType type = (FillType)((Object)this.getFillTypeCombo().getSelectedItem());
        boolean enabled = type != null && type != FillType.NONE;
        this.getFillColorButton().setEnabled(enabled);
        this.getFillGradientButton().setEnabled(enabled);
        this.getFillOpacitySlider().setEnabled(enabled);
        this.fillOpacityLabel.setEnabled(enabled);
        int borderWidth = (Integer)this.borderWidthCombo.getSelectedItem();
        enabled = borderWidth > 0;
        this.borderColorLabel.setEnabled(enabled);
        this.getBorderColorButton().setEnabled(enabled);
        this.borderOpacityLabel.setEnabled(enabled);
        this.getBorderOpacitySlider().setEnabled(enabled);
    }

    private void updateFillButtons() {
        FillType type = (FillType)((Object)this.getFillTypeCombo().getSelectedItem());
        this.getFillColorButton().setVisible(type == FillType.COLOR);
        this.getFillGradientButton().setVisible(type == FillType.GRADIENT);
    }

    private static enum FillType {
        NONE("-- none --"),
        COLOR("Color"),
        GRADIENT("Gradient");

        private String label;

        private FillType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    protected class GradientButton
    extends JButton {
        private static Rectangle DEF_BOUNDS = new Rectangle(0, 0, 1, 1);
        private MultipleGradientPaint paint;
        private double angle;
        private Point2D centerPoint;
        private boolean canceled;

        protected GradientButton() {
            super(" ");
            this.paint = defaultGradientPaint;
            this.centerPoint = (Point2D)PointPicker.DEFAULT_VALUE.clone();
            this.init();
            this.addActionListener(evt -> {
                MultipleGradientEditor.GradientType type = this.paint instanceof RadialGradientPaint ? MultipleGradientEditor.GradientType.RADIAL : MultipleGradientEditor.GradientType.LINEAR;
                float[] fractions = this.paint.getFractions();
                Color[] colors = this.paint.getColors();
                String annUuid = ((ShapeAnnotation)ShapeAnnotationEditor.this.annotation).getUUID().toString();
                MultipleGradientEditor editor = null;
                if (this.paint instanceof RadialGradientPaint) {
                    editor = new MultipleGradientEditor(this.centerPoint, fractions, colors, annUuid, ShapeAnnotationEditor.this.serviceRegistrar);
                } else if (this.paint instanceof LinearGradientPaint) {
                    double angle = MathUtil.getGradientAngle((LinearGradientPaint)this.paint);
                    editor = new MultipleGradientEditor(angle, fractions, colors, annUuid, ShapeAnnotationEditor.this.serviceRegistrar);
                }
                if (editor != null) {
                    editor.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
                    this.showEditorDialog(editor);
                    if (!this.canceled) {
                        type = editor.getType();
                        fractions = editor.getFractions();
                        colors = editor.getColors();
                        if (type == MultipleGradientEditor.GradientType.LINEAR) {
                            this.setLinearGradientPaint(fractions, colors, editor.getAngle());
                        } else {
                            this.setRadialGradientPaint(fractions, colors, editor.getCenterPoint(), 0.5f);
                        }
                    }
                }
            });
        }

        private void init() {
            if (LookAndFeelUtil.isAquaLAF()) {
                this.putClientProperty("JButton.buttonType", "gradient");
            }
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(0);
            this.setIcon(new GradientIcon());
            this.repaint();
        }

        protected void setPaint(MultipleGradientPaint paint) {
            if (!(paint instanceof LinearGradientPaint) && !(paint instanceof RadialGradientPaint)) {
                paint = defaultGradientPaint;
            }
            if (this.paint != paint) {
                MultipleGradientPaint oldValue = this.paint;
                this.paint = paint;
                if (paint instanceof LinearGradientPaint) {
                    this.angle = MathUtil.getGradientAngle((LinearGradientPaint)paint);
                } else if (paint instanceof RadialGradientPaint) {
                    this.centerPoint = ((RadialGradientPaint)paint).getCenterPoint();
                }
                this.repaint();
                this.firePropertyChange("paint", oldValue, paint);
            }
        }

        protected void setLinearGradientPaint(float[] fractions, Color[] colors, double angle) {
            this.angle = angle;
            Line2D line = MathUtil.getGradientAxis(DEF_BOUNDS, angle);
            LinearGradientPaint paint = new LinearGradientPaint(line.getP1(), line.getP2(), fractions, colors);
            MultipleGradientPaint oldValue = this.paint;
            this.paint = paint;
            this.repaint();
            this.firePropertyChange("paint", oldValue, paint);
        }

        protected void setRadialGradientPaint(float[] fractions, Color[] colors, Point2D centerPoint, float radius) {
            this.centerPoint = centerPoint;
            RadialGradientPaint paint = new RadialGradientPaint(centerPoint, radius, fractions, colors);
            MultipleGradientPaint oldValue = this.paint;
            this.paint = paint;
            this.repaint();
            this.firePropertyChange("paint", oldValue, paint);
        }

        protected MultipleGradientPaint getPaint() {
            return this.paint;
        }

        private void showEditorDialog(final MultipleGradientEditor editor) {
            Window owner = SwingUtilities.getWindowAncestor(this);
            final JDialog dialog = new JDialog(owner, "Gradient Editor", Dialog.ModalityType.APPLICATION_MODAL);
            dialog.setDefaultCloseOperation(2);
            JButton okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GradientButton.this.canceled = false;
                    dialog.dispose();
                }
            });
            JButton cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GradientButton.this.canceled = true;
                    dialog.dispose();
                }
            });
            JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okButton, (JButton)cancelButton);
            GroupLayout layout = new GroupLayout(dialog.getContentPane());
            dialog.getContentPane().setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(editor, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(editor, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -2, -1, -2));
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)dialog.getRootPane(), (Action)okButton.getAction(), (Action)cancelButton.getAction());
            this.getRootPane().setDefaultButton(okButton);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent event) {
                    if (!GradientButton.this.canceled) {
                        editor.saveCurrentPalette();
                    }
                }
            });
            dialog.pack();
            dialog.setResizable(false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }

        private class GradientIcon
        implements Icon {
            private GradientIcon() {
            }

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 44;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                Graphics2D g2 = (Graphics2D)g.create();
                if (GradientButton.this.paint != null) {
                    float[] fractions = GradientButton.this.paint.getFractions();
                    Color[] colors = GradientButton.this.paint.getColors();
                    Rectangle bounds = new Rectangle(x, y, w, h);
                    if (GradientButton.this.paint instanceof LinearGradientPaint) {
                        Line2D line = MathUtil.getGradientAxis(bounds, GradientButton.this.angle);
                        g2.setPaint(new LinearGradientPaint(line.getP1(), line.getP2(), fractions, colors));
                    } else if (GradientButton.this.paint instanceof RadialGradientPaint) {
                        Point2D cp = MathUtil.convertCoordinate(GradientButton.this.centerPoint, DEF_BOUNDS, new Rectangle(x, y, w, h));
                        int radius = Math.min(w, h);
                        g2.setPaint(new RadialGradientPaint(cp, radius, fractions, colors));
                    }
                    g2.fillRect(x, y, w, h);
                }
                g2.setColor(ColorUtil.getContrastingColor(c.getBackground()));
                g2.drawRect(x, y, w, h);
                g2.dispose();
            }
        }
    }
}

