/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.util.ImageCustomGraphicsSelector;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.ImageAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationDialog;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadImageDialog
extends AbstractAnnotationDialog<ImageAnnotationImpl> {
    private static final String NAME = "Image";
    private static final String UNDO_LABEL = "Create Image Annotation";
    private ImageCustomGraphicsSelector imageSelector;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public LoadImageDialog(DRenderingEngine re, Point2D start, Window owner, CyServiceRegistrar serviceRegistrar) {
        super(NAME, re, start, owner);
        this.serviceRegistrar = serviceRegistrar;
        this.setTitle("Select an Image");
        this.setResizable(true);
        this.getControlPanel().add((Component)this.getImageSelector(), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (LoadImageDialog.this.getImageSelector().isEmpty()) {
                    LoadImageDialog.this.getImageSelector().loadNewImages();
                }
            }
        });
        this.pack();
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        return panel;
    }

    @Override
    protected ImageAnnotationImpl getPreviewAnnotation() {
        return null;
    }

    @Override
    protected int getPreviewWidth() {
        return 0;
    }

    @Override
    protected int getPreviewHeight() {
        return 0;
    }

    @Override
    protected void apply() {
        try {
            CyCustomGraphics cg = this.getImageSelector().getSelectedImage();
            if (cg != null) {
                this.annotation = this.createAnnotation(cg);
            }
            if (this.annotation != null) {
                Point2D nodePoint = this.re.getTransform().getNodeCoordinates(this.startingLocation);
                double w = ((ImageAnnotationImpl)this.annotation).getWidth();
                double h = ((ImageAnnotationImpl)this.annotation).getHeight();
                ((ImageAnnotationImpl)this.annotation).setLocation(nodePoint.getX() - w / 2.0, nodePoint.getY() - h / 2.0);
                ((ImageAnnotationImpl)this.annotation).update();
                this.cyAnnotator.clearSelectedAnnotations();
                ViewUtils.selectAnnotation(this.re, this.annotation);
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to load the selected image", (Throwable)ex);
        }
    }

    @Override
    protected JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(new AbstractAction("Insert"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoadImageDialog.this.apply();
                    LoadImageDialog.this.dispose();
                }
            });
        }
        return this.applyButton;
    }

    private ImageCustomGraphicsSelector getImageSelector() {
        if (this.imageSelector == null) {
            this.imageSelector = new ImageCustomGraphicsSelector(this.serviceRegistrar);
            this.imageSelector.addActionListener(evt -> this.getApplyButton().doClick());
        }
        return this.imageSelector;
    }

    private ImageAnnotationImpl createAnnotation(CyCustomGraphics<?> cg) {
        ImageAnnotationImpl annotation = null;
        CustomGraphicsManager cgManager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        if (cg instanceof SVGCustomGraphics) {
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (AbstractURLImageCustomGraphics<?>)((SVGCustomGraphics)cg), (int)this.startingLocation.getX(), (int)this.startingLocation.getY(), 0.0, this.re.getZoom(), cgManager);
        } else if (cg instanceof BitmapCustomGraphics) {
            this.cyAnnotator.markUndoEdit(UNDO_LABEL);
            annotation = new ImageAnnotationImpl(this.re, (AbstractURLImageCustomGraphics<?>)((BitmapCustomGraphics)cg), (int)this.startingLocation.getX(), (int)this.startingLocation.getY(), 0.0, this.re.getZoom(), cgManager);
        }
        return annotation;
    }
}

