/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.GraphicsUtilities;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.utils.EnhancedSlider;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;

public class ArrowAnnotationEditor
extends AbstractAnnotationEditor<ArrowAnnotation> {
    private JLabel lineWidthLabel;
    private JLabel lineColorLabel;
    private JLabel lineOpacityLabel;
    private ColorButton lineColorButton;
    private EnhancedSlider lineOpacitySlider;
    private JComboBox<Integer> lineWidthCombo;
    private JPanel linePanel;
    private JPanel arrowsPanel;
    private ArrowPanel sourceArrowPanel;
    private ArrowPanel targetArrowPanel;

    public ArrowAnnotationEditor(AnnotationFactory<ArrowAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
    }

    @Override
    protected void doUpdate() {
        if (this.annotation != null) {
            Color lineColor = (Color)((ArrowAnnotation)this.annotation).getLineColor();
            this.getLineColorButton().setColor(lineColor);
            int opacity = this.getOpacity(lineColor);
            this.getLineOpacitySlider().setValue(opacity);
            int lineWidth = Math.max(1, (int)Math.round(((ArrowAnnotation)this.annotation).getLineWidth()));
            ComboBoxModel<Integer> model = this.getLineWidthCombo().getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                if (lineWidth != (Integer)model.getElementAt(i)) continue;
                this.getLineWidthCombo().setSelectedIndex(i);
                break;
            }
        }
        this.getSourceArrowPanel().update();
        this.getTargetArrowPanel().update();
    }

    @Override
    public void apply(ArrowAnnotation annotation) {
        if (annotation != null) {
            annotation.setLineColor(this.mixColor(this.getLineColorButton().getColor(), this.getLineOpacitySlider().getValue()));
            annotation.setLineWidth((double)((Integer)this.getLineWidthCombo().getSelectedItem()).intValue());
            this.getSourceArrowPanel().apply(annotation);
            this.getTargetArrowPanel().apply(annotation);
        }
    }

    @Override
    protected void init() {
        this.lineWidthLabel = new JLabel("Line Width:");
        this.lineColorLabel = new JLabel("Line Color:");
        this.lineOpacityLabel = new JLabel("Line Opacity:");
        this.getSourceArrowPanel().init();
        this.getTargetArrowPanel().init();
        JSeparator sep = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getLinePanel(), -1, -1, Short.MAX_VALUE).addComponent(sep, -1, -1, Short.MAX_VALUE).addComponent(this.getArrowsPanel(), -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getLinePanel(), -2, -1, -2).addComponent(sep, -2, -1, -2).addComponent(this.getArrowsPanel(), -1, -1, Short.MAX_VALUE));
    }

    private JPanel getLinePanel() {
        if (this.linePanel == null) {
            this.linePanel = new JPanel();
            this.linePanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.linePanel);
            this.linePanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lineWidthLabel).addComponent(this.lineColorLabel).addComponent(this.lineOpacityLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getLineWidthCombo(), -2, -1, -2).addComponent((Component)this.getLineColorButton(), -2, -1, -2).addComponent(this.getLineOpacitySlider(), 100, 140, 140)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lineWidthLabel).addComponent(this.getLineWidthCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.lineColorLabel).addComponent((Component)this.getLineColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lineOpacityLabel).addComponent(this.getLineOpacitySlider(), -2, -1, -2)));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.lineColorLabel, this.lineOpacityLabel, this.lineWidthLabel});
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getLineColorButton(), this.getLineOpacitySlider(), this.getLineWidthCombo()});
        }
        return this.linePanel;
    }

    private JPanel getArrowsPanel() {
        if (this.arrowsPanel == null) {
            this.arrowsPanel = new JPanel();
            this.arrowsPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            JSeparator sep = new JSeparator(1);
            GroupLayout layout = new GroupLayout(this.arrowsPanel);
            this.arrowsPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getSourceArrowPanel(), -2, -1, -2).addComponent(sep, -2, -1, -2).addComponent(this.getTargetArrowPanel(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getSourceArrowPanel(), -2, -1, -2).addComponent(sep, -1, -1, Short.MAX_VALUE).addComponent(this.getTargetArrowPanel(), -2, -1, -2));
        }
        return this.arrowsPanel;
    }

    private ColorButton getLineColorButton() {
        if (this.lineColorButton == null) {
            this.lineColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.BLACK, false);
            this.lineColorButton.setToolTipText("Select line color...");
            this.lineColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.lineColorButton;
    }

    private EnhancedSlider getLineOpacitySlider() {
        if (this.lineOpacitySlider == null) {
            this.lineOpacitySlider = new EnhancedSlider(100);
            this.lineOpacitySlider.addChangeListener(evt -> this.apply());
        }
        return this.lineOpacitySlider;
    }

    private JComboBox<Integer> getLineWidthCombo() {
        if (this.lineWidthCombo == null) {
            this.lineWidthCombo = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
            this.lineWidthCombo.setSelectedIndex(0);
            this.lineWidthCombo.addActionListener(evt -> this.apply());
        }
        return this.lineWidthCombo;
    }

    private ArrowPanel getSourceArrowPanel() {
        if (this.sourceArrowPanel == null) {
            this.sourceArrowPanel = new ArrowPanel(ArrowAnnotation.ArrowEnd.SOURCE, true);
        }
        return this.sourceArrowPanel;
    }

    private ArrowPanel getTargetArrowPanel() {
        if (this.targetArrowPanel == null) {
            this.targetArrowPanel = new ArrowPanel(ArrowAnnotation.ArrowEnd.TARGET, false);
        }
        return this.targetArrowPanel;
    }

    private int getOpacity(Color c) {
        return c == null ? 100 : (int)((double)(100 * c.getAlpha()) / 255.0);
    }

    private Paint mixColor(Paint p, int value) {
        if (p == null || !(p instanceof Color)) {
            return p;
        }
        Color c = (Color)p;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), value * 255 / 100);
    }

    private class ArrowPanel
    extends JPanel {
        private JLabel shapeLabel = new JLabel("Shape:");
        private JLabel colorLabel = new JLabel("Color:");
        private JLabel opacityLabel = new JLabel("Opacity:");
        private JLabel sizeLabel = new JLabel("Size:");
        private JLabel anchorLabel = new JLabel("Anchor:");
        private JComboBox<String> arrowTypeCombo;
        private JCheckBox arrowColorCheck;
        private ColorButton arrowColorButton;
        private EnhancedSlider arrowOpacitySlider;
        private JComboBox<Integer> arrowSizeCombo;
        private JComboBox<String> anchorTypeCombo;
        private final ArrowAnnotation.ArrowEnd arrowEnd;
        private final boolean showLabels;

        ArrowPanel(ArrowAnnotation.ArrowEnd arrowEnd, boolean showLabels) {
            this.arrowEnd = arrowEnd;
            this.showLabels = showLabels;
        }

        void update() {
            if (ArrowAnnotationEditor.this.annotation != null) {
                ArrayList<String> arrows = new ArrayList<String>(((ArrowAnnotation)ArrowAnnotationEditor.this.annotation).getSupportedArrows());
                arrows.sort(new Comparator<String>(){

                    @Override
                    public int compare(String s1, String s2) {
                        if (ArrowAnnotationImpl.ArrowType.NONE.getName().equalsIgnoreCase(s1)) {
                            return -1;
                        }
                        if (ArrowAnnotationImpl.ArrowType.NONE.getName().equalsIgnoreCase(s2)) {
                            return 1;
                        }
                        return s1.compareTo(s2);
                    }
                });
                String arrowType = ((ArrowAnnotation)ArrowAnnotationEditor.this.annotation).getArrowType(this.arrowEnd);
                this.getArrowTypeCombo().setModel(new DefaultComboBoxModel<String>(arrows.toArray(new String[arrows.size()])));
                this.getArrowTypeCombo().setSelectedItem(arrowType);
                Color color = (Color)((ArrowAnnotation)ArrowAnnotationEditor.this.annotation).getArrowColor(this.arrowEnd);
                int opacity = ArrowAnnotationEditor.this.getOpacity(color);
                int arrowSize = Math.max(1, (int)Math.round(((ArrowAnnotation)ArrowAnnotationEditor.this.annotation).getArrowSize(this.arrowEnd)));
                ComboBoxModel<Integer> model = this.getArrowSizeCombo().getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    if (arrowSize != (Integer)model.getElementAt(i)) continue;
                    this.getArrowSizeCombo().setSelectedIndex(i);
                    break;
                }
                this.getAnchorTypeCombo().setSelectedIndex(((ArrowAnnotation)ArrowAnnotationEditor.this.annotation).getAnchorType(this.arrowEnd) == ArrowAnnotation.AnchorType.CENTER ? 1 : 0);
                this.getArrowColorCheck().setSelected(color != null || opacity != 100);
                this.getArrowColorButton().setColor(color);
                this.getArrowOpacitySlider().setValue(opacity);
            }
            this.updateEnabled();
        }

        void apply(ArrowAnnotation annotation) {
            if (annotation != null) {
                String arrowType = (String)this.getArrowTypeCombo().getSelectedItem();
                annotation.setArrowType(this.arrowEnd, arrowType);
                if (this.getArrowColorCheck().isSelected()) {
                    annotation.setArrowColor(this.arrowEnd, ArrowAnnotationEditor.this.mixColor(this.getArrowColorButton().getColor(), this.getArrowOpacitySlider().getValue()));
                } else {
                    annotation.setArrowColor(this.arrowEnd, null);
                }
                annotation.setArrowSize(this.arrowEnd, (double)((Integer)this.getArrowSizeCombo().getSelectedItem()).intValue());
                Object anchorType = this.getAnchorTypeCombo().getSelectedItem();
                annotation.setAnchorType(this.arrowEnd, "Center".equals(anchorType) ? ArrowAnnotation.AnchorType.CENTER : ArrowAnnotation.AnchorType.ANCHOR);
            }
        }

        private void init() {
            JLabel titleLabel = new JLabel(this.arrowEnd == ArrowAnnotation.ArrowEnd.TARGET ? "Target Arrow:" : "Source Arrow:");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{titleLabel});
            this.shapeLabel.setVisible(this.showLabels);
            this.colorLabel.setVisible(this.showLabels);
            this.opacityLabel.setVisible(this.showLabels);
            this.sizeLabel.setVisible(this.showLabels);
            this.anchorLabel.setVisible(this.showLabels);
            if (LookAndFeelUtil.isAquaLAF()) {
                this.setOpaque(false);
            }
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addGap(titleLabel.getPreferredSize().height).addComponent(this.shapeLabel).addComponent(this.colorLabel).addComponent(this.opacityLabel).addComponent(this.sizeLabel).addComponent(this.anchorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(titleLabel).addComponent(this.getArrowTypeCombo(), -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.getArrowColorCheck(), -2, -1, -2).addComponent((Component)this.getArrowColorButton(), -2, -1, -2)).addComponent(this.getArrowOpacitySlider(), 100, 140, 140).addComponent(this.getArrowSizeCombo(), -2, -1, -2).addComponent(this.getAnchorTypeCombo(), -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.shapeLabel).addComponent(this.getArrowTypeCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.colorLabel).addComponent(this.getArrowColorCheck(), -2, -1, -2).addComponent((Component)this.getArrowColorButton(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.opacityLabel).addComponent(this.getArrowOpacitySlider(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.sizeLabel).addComponent(this.getArrowSizeCombo(), -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.anchorLabel).addComponent(this.getAnchorTypeCombo(), -2, -1, -2)));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.shapeLabel, this.colorLabel, this.opacityLabel, this.sizeLabel, this.anchorLabel});
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getArrowTypeCombo(), this.getArrowColorCheck(), this.getArrowColorButton(), this.getArrowOpacitySlider(), this.getArrowSizeCombo(), this.getAnchorTypeCombo()});
        }

        private JComboBox<String> getArrowTypeCombo() {
            if (this.arrowTypeCombo == null) {
                List<String> typeNames = GraphicsUtilities.getSupportedArrowTypeNames();
                this.arrowTypeCombo = new JComboBox<String>(new Vector<String>(typeNames));
                this.arrowTypeCombo.setSelectedItem(this.arrowEnd == ArrowAnnotation.ArrowEnd.SOURCE ? ArrowAnnotationImpl.ArrowType.NONE.toString() : ArrowAnnotationImpl.ArrowType.OPEN.toString());
                this.arrowTypeCombo.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        if (value == null || ArrowAnnotationImpl.ArrowType.NONE.getName().equalsIgnoreCase(value.toString())) {
                            this.setText("-- " + value + " --");
                        }
                        return this;
                    }
                });
                this.arrowTypeCombo.addActionListener(evt -> {
                    this.updateEnabled();
                    ArrowAnnotationEditor.this.apply();
                });
            }
            return this.arrowTypeCombo;
        }

        private JCheckBox getArrowColorCheck() {
            if (this.arrowColorCheck == null) {
                this.arrowColorCheck = new JCheckBox();
                this.arrowColorCheck.addActionListener(evt -> {
                    this.updateEnabled();
                    ArrowAnnotationEditor.this.apply();
                });
            }
            return this.arrowColorCheck;
        }

        private ColorButton getArrowColorButton() {
            if (this.arrowColorButton == null) {
                this.arrowColorButton = new ColorButton(ArrowAnnotationEditor.this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.BLACK, false);
                this.arrowColorButton.setToolTipText("Select arrow color...");
                this.arrowColorButton.addPropertyChangeListener("color", evt -> ArrowAnnotationEditor.this.apply());
            }
            return this.arrowColorButton;
        }

        private EnhancedSlider getArrowOpacitySlider() {
            if (this.arrowOpacitySlider == null) {
                this.arrowOpacitySlider = new EnhancedSlider(100);
                this.arrowOpacitySlider.addChangeListener(evt -> ArrowAnnotationEditor.this.apply());
            }
            return this.arrowOpacitySlider;
        }

        private JComboBox<Integer> getArrowSizeCombo() {
            if (this.arrowSizeCombo == null) {
                this.arrowSizeCombo = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
                this.arrowSizeCombo.setSelectedIndex(0);
                this.arrowSizeCombo.addActionListener(evt -> ArrowAnnotationEditor.this.apply());
            }
            return this.arrowSizeCombo;
        }

        private JComboBox<String> getAnchorTypeCombo() {
            if (this.anchorTypeCombo == null) {
                this.anchorTypeCombo = new JComboBox();
                this.anchorTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Edge", "Center"}));
                this.anchorTypeCombo.addActionListener(evt -> ArrowAnnotationEditor.this.apply());
            }
            return this.anchorTypeCombo;
        }

        private void updateEnabled() {
            String arrowType = (String)this.getArrowTypeCombo().getSelectedItem();
            boolean hasArrow = !ArrowAnnotationImpl.ArrowType.NONE.getName().equalsIgnoreCase(arrowType);
            this.getArrowColorCheck().setEnabled(hasArrow);
            this.getArrowSizeCombo().setEnabled(hasArrow);
            this.getAnchorTypeCombo().setEnabled(hasArrow);
            boolean enabled = hasArrow && this.getArrowColorCheck().isSelected();
            this.getArrowColorButton().setEnabled(enabled);
            this.getArrowOpacitySlider().setEnabled(enabled);
        }
    }
}

