/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.Annotation;

public abstract class AbstractAnnotationDialog<T extends AbstractAnnotation>
extends JDialog {
    protected JComponent controlPanel;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected T annotation;
    protected final CyAnnotator cyAnnotator;
    protected final DRenderingEngine re;
    protected final Point2D startingLocation;
    protected final boolean create;

    protected AbstractAnnotationDialog(String name, T annotation, DRenderingEngine re, Point2D start, Window owner) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.annotation = annotation;
        this.re = re;
        this.cyAnnotator = re.getCyAnnotator();
        this.startingLocation = start != null ? start : re.getComponentCenter();
        this.create = true;
        this.setName(name);
        this.init();
    }

    protected AbstractAnnotationDialog(String name, T annotation, Window owner) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.annotation = annotation;
        this.cyAnnotator = ((AbstractAnnotation)annotation).getCyAnnotator();
        this.re = this.cyAnnotator.getRenderingEngine();
        this.startingLocation = null;
        this.create = false;
        this.setName(name);
        this.init();
    }

    public AbstractAnnotationDialog(String name, DRenderingEngine re, Point2D start, Window owner) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.re = re;
        this.cyAnnotator = re.getCyAnnotator();
        this.startingLocation = start != null ? start : re.getComponentCenter();
        this.create = true;
        this.setName(name);
        this.init();
    }

    public T getAnnotation() {
        return this.annotation;
    }

    protected void init() {
        this.setTitle((this.create ? "Create " : "Modify ") + this.getName() + " Annotation");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getApplyButton(), (JButton)this.getCancelButton());
        JPanel contents = new JPanel();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING, true);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup(hGroup);
        layout.setVerticalGroup(vGroup);
        hGroup.addComponent(this.getControlPanel());
        vGroup.addComponent(this.getControlPanel(), -1, -1, Short.MAX_VALUE);
        hGroup.addComponent(buttonPanel);
        vGroup.addComponent(buttonPanel, -2, -1, -2);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getApplyButton().getAction(), (Action)this.getCancelButton().getAction());
        this.getRootPane().setDefaultButton(this.getApplyButton());
        this.getContentPane().add(contents);
        this.pack();
    }

    protected JComponent getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = this.createControlPanel();
        }
        return this.controlPanel;
    }

    protected JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AbstractAnnotationDialog.this.dispose();
                    AbstractAnnotationDialog.this.cyAnnotator.markUndoEdit((AbstractAnnotationDialog.this.create ? "Create " : "Modify ") + AbstractAnnotationDialog.this.getName() + " Annotation");
                    AbstractAnnotationDialog.this.apply();
                    if (AbstractAnnotationDialog.this.annotation != null) {
                        AbstractAnnotationDialog.this.cyAnnotator.addAnnotation((Annotation)AbstractAnnotationDialog.this.annotation);
                        AbstractAnnotationDialog.this.cyAnnotator.clearSelectedAnnotations();
                        ViewUtils.selectAnnotation(AbstractAnnotationDialog.this.re, AbstractAnnotationDialog.this.annotation);
                        AbstractAnnotationDialog.this.cyAnnotator.postUndoEdit();
                    }
                }
            });
        }
        return this.applyButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AbstractAnnotationDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    protected abstract JComponent createControlPanel();

    protected abstract T getPreviewAnnotation();

    protected abstract int getPreviewWidth();

    protected abstract int getPreviewHeight();

    protected abstract void apply();
}

