/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.create;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.annotations.ImageAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.dialogs.ImageAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.dialogs.LoadImageDialog;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;

public class ImageAnnotationFactory
extends AbstractDingAnnotationFactory<ImageAnnotation> {
    public static final String NAME = "Image";
    private Icon icon;

    public ImageAnnotationFactory(CyServiceRegistrar serviceRegistrar) {
        super(ImageAnnotation.class, serviceRegistrar);
    }

    public LoadImageDialog createLoadImageDialog(CyNetworkView view, Point2D location) {
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        return new LoadImageDialog(re, location, ViewUtil.getActiveWindow(re), this.serviceRegistrar);
    }

    public ImageAnnotationEditor createEditor() {
        return new ImageAnnotationEditor(this, this.serviceRegistrar);
    }

    public ImageAnnotation createAnnotation(Class<? extends ImageAnnotation> type, CyNetworkView view, Map<String, String> argMap) {
        if (!this.type.equals(type)) {
            return null;
        }
        DRenderingEngine re = ((DingRenderer)this.serviceRegistrar.getService(DingRenderer.class)).getRenderingEngine(view);
        if (re == null) {
            return null;
        }
        CustomGraphicsManager cgManager = (CustomGraphicsManager)this.serviceRegistrar.getService(CustomGraphicsManager.class);
        return new ImageAnnotationImpl(re, argMap, cgManager);
    }

    public String getId() {
        return "org.cytoscape.annotation.Image";
    }

    public String getName() {
        return NAME;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            Font font = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 16.0f);
            this.icon = new TextIcon(new String[]{"2", "3"}, font, new Color[]{Color.WHITE, UIManager.getColor("Label.foreground")}, 16, 16, new Integer[]{0});
        }
        return this.icon;
    }
}

