/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class TextAnnotationImpl
extends AbstractAnnotation
implements TextAnnotation {
    public static final String DEF_TEXT = "Text";
    protected static final Font DEF_FONT = new Font("Arial", 0, 12);
    public static final String splitPattern = "(?<!\\\\)" + Pattern.quote("\\n");
    private String[] text = new String[]{"Text"};
    private Font font = DEF_FONT;
    private float fontSize = DEF_FONT.getSize();
    private Color textColor = Color.BLACK;
    private float savedFontSize;
    private boolean updateNameFromText = true;

    public TextAnnotationImpl(DRenderingEngine re, boolean usedForPreviews) {
        super(re, usedForPreviews);
    }

    public TextAnnotationImpl(TextAnnotationImpl c, boolean usedForPreviews) {
        super(c, usedForPreviews);
        this.text = TextAnnotationImpl.splitString(c.getText());
        this.textColor = c.getTextColor();
        this.fontSize = (float)c.getFontSize();
        if (c.getFont() != null) {
            this.font = c.getFont();
        }
        this.name = c.getName() != null ? c.getName() : this.getDefaultName();
    }

    public TextAnnotationImpl(DRenderingEngine re, int x, int y, double rotation, String text, int compCount, double zoom) {
        super(re, x, y, rotation);
        this.text = TextAnnotationImpl.splitString(text);
        this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
    }

    public TextAnnotationImpl(DRenderingEngine re, Map<String, String> argMap) {
        super(re, argMap);
        if (this.name == null && this.text != null && !this.text[0].trim().isEmpty()) {
            this.name = this.text[0].trim();
        }
        this.text = TextAnnotationImpl.splitString(ViewUtils.getString(argMap, "text", ""));
        this.textColor = (Color)ViewUtils.getColor(argMap, "color", Color.BLACK);
        this.font = ViewUtils.getArgFont(argMap, this.font.getFamily(), this.font.getStyle(), this.font.getSize());
        double zoom = TextAnnotationImpl.getLegacyZoom(argMap);
        if (zoom != 1.0) {
            this.font = this.font.deriveFont(this.font.getSize2D() / (float)zoom);
        }
        this.fontSize = this.font.getSize();
        this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
    }

    @Override
    public Map<String, String> getArgMap() {
        Map<String, String> argMap = super.getArgMap();
        argMap.put("type", TextAnnotation.class.getName());
        argMap.put("text", TextAnnotationImpl.joinString(this.text));
        argMap.put("color", ViewUtils.serialize(this.textColor));
        argMap.put("fontFamily", this.font.getFamily());
        argMap.put("fontSize", Integer.toString(this.font.getSize()));
        argMap.put("fontStyle", Integer.toString(this.font.getStyle()));
        return argMap;
    }

    @Override
    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            this.updateNameFromText = false;
        }
        super.setName(name);
    }

    @Override
    public Class<? extends Annotation> getType() {
        return TextAnnotation.class;
    }

    @Override
    public void setZoom(double zoom) {
        if (zoom == this.getZoom()) {
            return;
        }
        this.fontSize = (float)(zoom / this.getZoom() * (double)this.fontSize);
        this.font = this.font.deriveFont(this.fontSize);
        if (!this.usedForPreviews) {
            this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
        }
        super.setZoom(zoom);
    }

    @Override
    public void setSpecificZoom(double zoom) {
        if (zoom == this.getSpecificZoom()) {
            return;
        }
        this.fontSize = (float)(zoom / this.getSpecificZoom() * (double)this.fontSize);
        this.font = this.font.deriveFont(this.fontSize);
        if (!this.usedForPreviews) {
            this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
        }
        super.setSpecificZoom(zoom);
    }

    public void setText(String text) {
        String[] lines = TextAnnotationImpl.splitString(text);
        if (!Objects.equals(lines, this.text)) {
            String oldValue = TextAnnotationImpl.joinString(this.text);
            this.text = lines;
            if (this.updateNameFromText) {
                String string = this.name = text != null ? this.text[0].trim() : "";
            }
            if (!this.usedForPreviews) {
                this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
            }
            this.update();
            this.firePropertyChange("text", oldValue, text);
        }
    }

    public String getText() {
        return TextAnnotationImpl.joinString(this.text);
    }

    public void setTextColor(Color color) {
        if (!Objects.equals(this.textColor, color)) {
            Color oldValue = this.textColor;
            this.textColor = color;
            this.update();
            this.firePropertyChange("textColor", oldValue, this.textColor);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setFontSize(double size) {
        if (this.fontSize != (float)size) {
            float oldValue = this.fontSize;
            this.fontSize = (float)size;
            if (this.font != null) {
                this.font = this.font.deriveFont(this.fontSize);
            }
            if (!this.usedForPreviews) {
                this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
            }
            this.update();
            this.firePropertyChange("fontSize", Float.valueOf(oldValue), Float.valueOf(this.fontSize));
        }
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontStyle(int style) {
        if (this.font != null && style != this.font.getStyle()) {
            int oldValue = this.font.getStyle();
            this.font = this.font.deriveFont(style, this.fontSize);
            if (!this.usedForPreviews) {
                this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
            }
            this.update();
            this.firePropertyChange("fontStyle", oldValue, style);
        }
    }

    public int getFontStyle() {
        return this.font != null ? this.font.getStyle() : 0;
    }

    public void setFontFamily(String family) {
        if (family != null && !family.equalsIgnoreCase(this.getFontFamily())) {
            String oldValue = this.getFontFamily();
            this.font = new Font(family, this.getFontStyle(), (int)this.fontSize);
            if (!this.usedForPreviews) {
                this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
            }
            this.update();
            this.firePropertyChange("fontFamily", oldValue, family);
        }
    }

    public String getFontFamily() {
        return this.font != null ? this.font.getFamily() : null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null && !font.equals(this.font)) {
            Font oldValue = this.font;
            this.font = font;
            this.fontSize = font.getSize2D();
            if (!this.usedForPreviews) {
                this.setSize(this.getAnnotationWidth(), this.getAnnotationHeight());
            }
            this.update();
            this.firePropertyChange("font", oldValue, font);
        }
    }

    @Override
    public void setBounds(Rectangle2D newBounds) {
        if (newBounds.getWidth() == 0.0 || newBounds.getHeight() == 0.0) {
            return;
        }
        Rectangle2D initialBounds = this.getBounds();
        if (initialBounds.getWidth() != 0.0) {
            double factor = newBounds.getWidth() / initialBounds.getWidth();
            double fontSize = (double)this.savedFontSize != 0.0 ? (double)this.savedFontSize * factor : (double)this.fontSize * factor;
            this.setFontSize((float)fontSize);
        }
        super.setBounds(newBounds);
        this.update();
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        if (argMap != null) {
            this.setTextColor((Color)ViewUtils.getColor(argMap, "color", Color.BLACK));
            Font newFont = ViewUtils.getArgFont(argMap, this.font.getFamily(), this.font.getStyle(), this.font.getSize());
            double zoom = TextAnnotationImpl.getLegacyZoom(argMap);
            if (zoom != 1.0) {
                newFont = newFont.deriveFont(newFont.getSize2D() / (float)zoom);
            }
            this.setFont(newFont);
        }
    }

    @Override
    public void paint(Graphics g, boolean showSelection) {
        if (this.text == null || this.textColor == null || this.font == null) {
            return;
        }
        if ((double)this.font.getSize2D() <= 0.0) {
            return;
        }
        super.paint(g, showSelection);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(this.textColor);
        g2.setFont(this.font);
        int alpha = this.textColor.getAlpha();
        float opacity = (float)alpha / 255.0f;
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, opacity));
        AffineTransform currentTransform = g2.getTransform();
        float yValue = (float)this.getY();
        if (this.rotation != 0.0) {
            g2.rotate(Math.toRadians(this.rotation), (int)(this.getX() + this.getWidth() / 2.0), (int)(this.getY() + this.getHeight() / 2.0));
            g2.setClip(this.getBounds());
            for (String t : this.text) {
                LineMetrics metrics = this.font.getLineMetrics(t, new FontRenderContext(null, true, true));
                float ascent = metrics.getAscent();
                g2.drawString(t, (float)this.getX(), yValue + ascent);
                yValue += metrics.getHeight();
            }
            g2.setTransform(currentTransform);
        } else {
            g2.setClip(this.getBounds());
            for (String t : this.text) {
                LineMetrics metrics = this.font.getLineMetrics(t, new FontRenderContext(null, true, true));
                float ascent = metrics.getAscent();
                g2.drawString(t, (float)this.getX(), yValue + ascent);
                yValue += metrics.getHeight();
            }
        }
        g2.setComposite(originalComposite);
        g2.dispose();
    }

    @Override
    protected String getDefaultName() {
        return this.text != null ? this.text[0] : DEF_TEXT;
    }

    private double getAnnotationWidth() {
        return this.getTextWidth() + 1.0;
    }

    private double getAnnotationHeight() {
        return this.getTextHeight() + 1.0;
    }

    double getTextWidth() {
        if (this.text == null) {
            return 0.0;
        }
        double width = 0.0;
        for (String t : this.text) {
            width = Math.max(width, this.font.getStringBounds(t, new FontRenderContext(null, true, true)).getWidth());
        }
        return width;
    }

    double getTextHeight() {
        if (this.text == null) {
            return 0.0;
        }
        double height = 0.0;
        for (String t : this.text) {
            height += this.font.getStringBounds(t, new FontRenderContext(null, true, true)).getHeight();
        }
        return height;
    }

    protected static String[] splitString(String str) {
        String[] res = str.split("\n");
        if (res.length > 1) {
            return res;
        }
        return str.split(splitPattern);
    }

    protected static String joinString(String[] lines) {
        return String.join((CharSequence)"\\n", lines);
    }
}

