/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public interface DingAnnotation
extends Annotation {
    public static final String TYPE = "type";
    public static final String ANNOTATION_ID = "uuid";
    public static final String PARENT_ID = "parent";

    public void changeCanvas(CanvasID var1);

    public CanvasID getCanvas();

    default public String getCanvasName() {
        return this.getCanvas().toArgName();
    }

    public CyAnnotator getCyAnnotator();

    public boolean isUsedForPreviews();

    public void contentChanged();

    public void paint(Graphics var1, boolean var2);

    public void setGroupParent(GroupAnnotation var1);

    public GroupAnnotation getGroupParent();

    public Class<? extends Annotation> getType();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public double getRotation();

    public void setLocation(double var1, double var3);

    public double getWidth();

    public double getHeight();

    default public boolean contains(double x, double y) {
        return x > this.getX() && y > this.getY() && x - this.getX() < this.getWidth() && y - this.getY() < this.getHeight();
    }

    default public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public int getZOrder();

    public void setZOrder(int var1);

    default public void setZoom(double zoom) {
    }

    default public double getZoom() {
        return 1.0;
    }

    default public void setSpecificZoom(double zoom) {
        this.setZoom(zoom);
    }

    default public double getSpecificZoom() {
        return this.getZoom();
    }

    default public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setSize(double var1, double var3);

    public void saveBounds();

    public Rectangle2D getInitialBounds();

    public void setStyle(Map<String, String> var1);

    public String toString();

    public static enum CanvasID {
        FOREGROUND,
        BACKGROUND;


        public String toArgName() {
            return this == BACKGROUND ? "background" : "foreground";
        }

        public static CanvasID fromArgName(String prop) {
            return "background".equals(prop) ? BACKGROUND : FOREGROUND;
        }
    }
}

