/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.AnchorLocation;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.property.values.Position;

public class AnnotationSelection
implements Iterable<DingAnnotation> {
    public static final int HANDLER_SIZE = 8;
    public static final int WIDTH = 1;
    public static final Color COLOR_1 = Color.GRAY;
    public static final Color COLOR_2 = Color.WHITE;
    private final DRenderingEngine re;
    private final CyAnnotator cyAnnotator;
    private final Set<DingAnnotation> selectedAnnotations = new HashSet<DingAnnotation>();
    private final Map<DingAnnotation, Double> initialRotations = new HashMap<DingAnnotation, Double>();
    private final Map<DingAnnotation, Rectangle2D> initialBounds = new HashMap<DingAnnotation, Rectangle2D>();
    private Rectangle2D union;
    private Rectangle2D savedUnion;
    private Rectangle2D shiftResizeUnion;
    private final Map<Position, Rectangle> anchors = new EnumMap<Position, Rectangle>(Position.class);
    private Point movingStartOffset;
    private Point2D initialCenter;
    private AnchorLocation resizingAnchor;
    private final Object lock = new Object();

    public AnnotationSelection(CyAnnotator cyAnnotator) {
        this.cyAnnotator = cyAnnotator;
        this.re = cyAnnotator.getRenderingEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DingAnnotation a) {
        Object object = this.lock;
        synchronized (object) {
            this.selectedAnnotations.add(a);
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Annotation a) {
        Object object = this.lock;
        synchronized (object) {
            this.selectedAnnotations.remove(a);
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.selectedAnnotations.isEmpty()) {
                this.selectedAnnotations.clear();
                this.updateBounds();
            }
        }
    }

    public int size() {
        return this.selectedAnnotations.size();
    }

    public boolean contains(DingAnnotation a) {
        return this.selectedAnnotations.contains(a);
    }

    @Override
    public Iterator<DingAnnotation> iterator() {
        return this.selectedAnnotations.iterator();
    }

    public boolean isEmpty() {
        return this.selectedAnnotations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DingAnnotation> getSelectedAnnotations() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<DingAnnotation>(this.selectedAnnotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBounds() {
        this.savedUnion = this.union;
        Object object = this.lock;
        synchronized (object) {
            for (DingAnnotation da : this.selectedAnnotations) {
                da.saveBounds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        Object object = this.lock;
        synchronized (object) {
            this.union = AnnotationSelection.unionBounds(this.selectedAnnotations);
        }
    }

    private static Rectangle2D unionBounds(Collection<DingAnnotation> annotations) {
        Rectangle2D union = null;
        for (DingAnnotation a : annotations) {
            Rectangle2D bounds = a.getRotatedBounds();
            if (bounds == null) continue;
            union = union == null ? bounds : union.createUnion(bounds);
        }
        return union;
    }

    public Rectangle2D getBounds() {
        this.updateBounds();
        return this.union;
    }

    public Point2D getLocation() {
        Rectangle2D bounds = this.getBounds();
        return bounds == null ? null : new Point2D.Double(bounds.getX(), bounds.getY());
    }

    public AnchorLocation overAnchor(int mouseX, int mouseY) {
        for (Position p : Position.values()) {
            Rectangle rect = this.anchors.get(p);
            if (rect == null || !rect.contains(mouseX, mouseY)) continue;
            int mouseOffsetX = mouseX - rect.x;
            int mouseOffsetY = mouseY - rect.y;
            return new AnchorLocation(p, rect.x, rect.y, mouseOffsetX, mouseOffsetY);
        }
        return null;
    }

    public void startResizing(AnchorLocation resizingAnchor) {
        this.resizingAnchor = resizingAnchor;
        this.saveBounds();
    }

    public void stopResizing() {
        this.resizingAnchor = null;
    }

    public boolean isResizing() {
        return this.resizingAnchor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeAnnotationsRelative(int mouseX, int mouseY, boolean keepAspectRatio) {
        if (keepAspectRatio && this.shiftResizeUnion == null) {
            this.shiftResizeUnion = AnnotationSelection.unionBounds(this.selectedAnnotations);
        } else if (!keepAspectRatio && this.shiftResizeUnion != null) {
            this.shiftResizeUnion = null;
        }
        Position position = this.resizingAnchor.getPosition();
        if (AnchorLocation.isNorth(position)) {
            mouseY += 4 - this.resizingAnchor.getMouseOffsetY();
        }
        if (AnchorLocation.isSouth(position)) {
            mouseY -= this.resizingAnchor.getMouseOffsetY();
        }
        if (AnchorLocation.isWest(position)) {
            mouseX += 4 - this.resizingAnchor.getMouseOffsetX();
        }
        if (AnchorLocation.isEast(position)) {
            mouseX -= this.resizingAnchor.getMouseOffsetX();
        }
        Point2D node = this.re.getTransform().getNodeCoordinates(mouseX, mouseY);
        Rectangle2D newOutlineBounds = this.resize(position, node.getX(), node.getY());
        Object object = this.lock;
        synchronized (object) {
            for (DingAnnotation a : this) {
                ((AbstractAnnotation)a).resizeAnnotationRelative(this.savedUnion, newOutlineBounds);
                a.update();
            }
        }
        this.updateBounds();
    }

    private Rectangle2D resize(Position position, double mouseX, double mouseY) {
        double boundsX = this.savedUnion.getX();
        double boundsY = this.savedUnion.getY();
        double boundsWidth = this.savedUnion.getWidth();
        double boundsHeight = this.savedUnion.getHeight();
        double boundsYBottom = boundsY + boundsHeight;
        double boundsXRight = boundsX + boundsWidth;
        double x = boundsX;
        double y = boundsY;
        double w = boundsWidth;
        double h = boundsHeight;
        if (AnchorLocation.isNorth(position)) {
            if (mouseY > boundsYBottom) {
                y = boundsYBottom;
                h = mouseY - boundsYBottom;
            } else {
                y = mouseY;
                h = boundsYBottom - mouseY;
            }
        } else if (AnchorLocation.isSouth(position)) {
            if (mouseY < boundsY) {
                y = mouseY;
                h = boundsY - mouseY;
            } else {
                h = mouseY - boundsY;
            }
        }
        if (AnchorLocation.isWest(position)) {
            if (mouseX > boundsXRight) {
                x = boundsXRight;
                w = mouseX - boundsXRight;
            } else {
                x = mouseX;
                w = boundsXRight - mouseX;
            }
        } else if (AnchorLocation.isEast(position)) {
            if (mouseX < boundsX) {
                x = mouseX;
                w = boundsX - mouseX;
            } else {
                w = mouseX - boundsX;
            }
        }
        if (this.shiftResizeUnion != null && AnchorLocation.isCorner(position)) {
            boundsX = this.shiftResizeUnion.getX();
            boundsY = this.shiftResizeUnion.getY();
            boundsWidth = this.shiftResizeUnion.getWidth();
            boundsHeight = this.shiftResizeUnion.getHeight();
            boundsYBottom = boundsY + boundsHeight;
            boundsXRight = boundsX + boundsWidth;
            double f1 = w / boundsWidth;
            double f2 = h / boundsHeight;
            double f = Math.max(f1, f2);
            w = boundsWidth * f;
            h = boundsHeight * f;
            if (AnchorLocation.isNorth(position) && mouseY < boundsYBottom) {
                y = boundsYBottom - h;
            } else if (AnchorLocation.isSouth(position) && mouseY < boundsY) {
                y = boundsY - h;
            }
            if (AnchorLocation.isWest(position) && mouseX < boundsXRight) {
                x = boundsXRight - w;
            } else if (AnchorLocation.isEast(position) && mouseX < boundsX) {
                x = boundsX - w;
            }
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    public void setMovingStartOffset(Point offset) {
        this.movingStartOffset = offset;
        if (this.union != null) {
            this.initialCenter = new Point2D.Double(this.union.getX() + this.union.getWidth() / 2.0, this.union.getY() + this.union.getHeight() / 2.0);
        }
    }

    public void setRotations() {
        for (DingAnnotation a : this.selectedAnnotations) {
            this.initialRotations.put(a, a.getRotation());
            this.initialBounds.put(a, a.getBounds());
        }
    }

    public void stopRotating() {
        this.initialRotations.clear();
        this.initialBounds.clear();
    }

    public boolean isRotating() {
        return !this.initialRotations.isEmpty();
    }

    public void rotateSelection(Point p) {
        HashSet<DingAnnotation> annotationsToMove = this.annotationsToChange();
        double centerX = this.initialCenter.getX();
        double centerY = this.initialCenter.getY();
        NetworkTransform transform = this.cyAnnotator.getRenderingEngine().getTransform();
        Point2D nodePt = transform.getNodeCoordinates(p);
        Point2D offsetPt = transform.getNodeCoordinates(this.movingStartOffset);
        double angle1 = Math.atan2(centerY - offsetPt.getY(), centerX - offsetPt.getX());
        double angle2 = Math.atan2(centerY - nodePt.getY(), centerX - nodePt.getX());
        for (DingAnnotation a : annotationsToMove) {
            double angle = this.initialRotations.get(a) == null ? 0.0 - Math.toDegrees(angle1 - angle2) : this.initialRotations.get(a) - Math.toDegrees(angle1 - angle2);
            Rectangle2D bounds = this.initialBounds.get(a);
            Point2D aCenter = this.getCenter(bounds);
            double x = aCenter.getX() - centerX;
            double y = aCenter.getY() - centerY;
            if (Math.abs(x) > 0.1 || Math.abs(y) > 0.1) {
                double aRadians = Math.toRadians(angle);
                double newCenterX = x * Math.cos(aRadians) - y * Math.sin(aRadians);
                double newCenterY = y * Math.cos(aRadians) + x * Math.sin(aRadians);
                a.setLocation((newCenterX += centerX) - bounds.getWidth() / 2.0, (newCenterY += centerY) - bounds.getHeight() / 2.0);
            }
            a.setRotation(angle);
            a.update();
        }
        this.updateBounds();
    }

    public void moveSelection(Point p) {
        this.moveSelection(p.x, p.y);
    }

    public void moveSelection(int x, int y) {
        if (this.movingStartOffset == null) {
            return;
        }
        HashSet<DingAnnotation> annotationsToMove = this.annotationsToChange();
        NetworkTransform transform = this.cyAnnotator.getRenderingEngine().getTransform();
        Point2D nodePt = transform.getNodeCoordinates(x, y);
        Point2D offsetPt = transform.getNodeCoordinates(this.movingStartOffset);
        double dx = nodePt.getX() - offsetPt.getX();
        double dy = nodePt.getY() - offsetPt.getY();
        for (DingAnnotation a : annotationsToMove) {
            a.setLocation(a.getX() + dx, a.getY() + dy);
            a.update();
        }
        this.updateBounds();
    }

    public void stopMoving() {
        this.movingStartOffset = null;
    }

    public void paint(Graphics2D g) {
        if (this.isEmpty()) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.setStroke(new BasicStroke(1.0f));
        double dpiScale = this.re.getTransform().getDpiScaleFactor();
        g.scale(dpiScale, dpiScale);
        Rectangle r1 = this.getShapeImageCoords();
        g.setPaint(COLOR_1);
        g.draw(r1);
        Rectangle r2 = new Rectangle(r1.x - 1, r1.y - 1, r1.width + 2, r1.height + 2);
        g.setPaint(COLOR_2);
        g.draw(r2);
        this.updateAnchors(r1);
        if (this.annotationSelectionEnabled()) {
            g.setPaint(COLOR_2);
            this.anchors.values().forEach(g::fill);
            g.setPaint(COLOR_1);
            g.setStroke(new BasicStroke(1.0f));
            this.anchors.values().forEach(g::draw);
        }
        g.setComposite(originalComposite);
    }

    private Rectangle getShapeImageCoords() {
        Rectangle r = this.re.getTransform().getImageCoordinates(this.union);
        return new Rectangle(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<DingAnnotation> annotationsToChange() {
        HashSet<DingAnnotation> annotationsToMove = new HashSet<DingAnnotation>(this.selectedAnnotations);
        Object object = this.lock;
        synchronized (object) {
            block3: for (DingAnnotation annotation : this.selectedAnnotations) {
                for (DingAnnotation ancestor : AnnotationTree.getAncestors(annotation)) {
                    if (!this.selectedAnnotations.contains(ancestor)) continue;
                    annotationsToMove.remove(annotation);
                    continue block3;
                }
            }
        }
        return annotationsToMove;
    }

    private Point2D getCenter(Rectangle2D bounds) {
        return new Point2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
    }

    private void updateAnchors(Rectangle shape) {
        int s = 8;
        int w = shape.width;
        int h = shape.height;
        int xw = s / 2;
        int xe = w + s / 2;
        int xc = w / 2 + s / 2;
        int yn = s / 2;
        int ys = h + s / 2;
        int yc = h / 2 + s / 2;
        this.anchors.clear();
        this.anchors.put(Position.NORTH_WEST, new Rectangle(xw, yn, s, s));
        this.anchors.put(Position.NORTH, new Rectangle(xc, yn, s, s));
        this.anchors.put(Position.NORTH_EAST, new Rectangle(xe, yn, s, s));
        this.anchors.put(Position.WEST, new Rectangle(xw, yc, s, s));
        this.anchors.put(Position.EAST, new Rectangle(xe, yc, s, s));
        this.anchors.put(Position.SOUTH_WEST, new Rectangle(xw, ys, s, s));
        this.anchors.put(Position.SOUTH, new Rectangle(xc, ys, s, s));
        this.anchors.put(Position.SOUTH_EAST, new Rectangle(xe, ys, s, s));
        this.anchors.values().forEach(r -> r.translate(shape.x - s, shape.y - s));
    }

    private boolean annotationSelectionEnabled() {
        return (Boolean)this.re.getViewModelSnapshot().getVisualProperty(DVisualLexicon.NETWORK_ANNOTATION_SELECTION);
    }
}

