/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.GroupAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public abstract class AbstractAnnotation
implements DingAnnotation {
    protected final CyAnnotator cyAnnotator;
    private UUID uuid = UUID.randomUUID();
    private Set<ArrowAnnotation> arrowList = new HashSet<ArrowAnnotation>();
    protected final boolean usedForPreviews;
    protected DRenderingEngine re;
    protected DingAnnotation.CanvasID canvas;
    protected GroupAnnotationImpl groupParent;
    protected String name;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected double rotation;
    protected int zOrder;
    protected Rectangle2D initialBounds;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected AbstractAnnotation(DRenderingEngine re, boolean usedForPreviews) {
        this.re = re;
        this.cyAnnotator = re == null ? null : re.getCyAnnotator();
        this.usedForPreviews = usedForPreviews;
        this.canvas = DingAnnotation.CanvasID.FOREGROUND;
        this.name = this.getDefaultName();
    }

    protected AbstractAnnotation(AbstractAnnotation c, boolean usedForPreviews) {
        this(c.re, usedForPreviews);
        this.arrowList = new HashSet<ArrowAnnotation>(c.arrowList);
        this.canvas = c.canvas;
    }

    protected AbstractAnnotation(DRenderingEngine re, double x, double y, double rotation) {
        this(re, false);
        this.setLocation(x, y);
        this.rotation = rotation;
    }

    protected AbstractAnnotation(DRenderingEngine re, Map<String, String> argMap) {
        this(re, false);
        String canvasString;
        if (argMap.get("x") != null) {
            try {
                this.x = Double.parseDouble(argMap.get("x"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (argMap.get("y") != null) {
            try {
                this.y = Double.parseDouble(argMap.get("y"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (argMap.get("rotation") != null) {
            try {
                this.rotation = Double.parseDouble(argMap.get("rotation"));
            }
            catch (Exception exception) {}
        } else {
            this.rotation = 0.0;
        }
        try {
            this.zOrder = ViewUtils.getDouble(argMap, "z", 0.0).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (argMap.get("name") != null) {
            this.name = argMap.get("name");
        }
        if ((canvasString = ViewUtils.getString(argMap, "canvas", "foreground")) != null && canvasString.equals("background")) {
            this.canvas = DingAnnotation.CanvasID.BACKGROUND;
        }
        if (argMap.containsKey("uuid")) {
            this.uuid = UUID.fromString(argMap.get("uuid"));
        }
    }

    protected static double getLegacyZoom(Map<String, String> argMap) {
        double zoom = ViewUtils.getDouble(argMap, "zoom", 1.0);
        if (zoom == 0.0) {
            zoom = 1.0;
        }
        return zoom;
    }

    protected String getDefaultName() {
        if (this.cyAnnotator == null) {
            return "Annotation";
        }
        return this.cyAnnotator.getDefaultAnnotationName(this.getType().getSimpleName().replace("Annotation", ""));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.zOrder;
    }

    @Override
    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.zOrder = (int)z;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        if (this.rotation != rotation) {
            double oldValue = this.rotation;
            this.rotation = rotation;
            while (this.rotation < -180.0) {
                this.rotation += 360.0;
            }
            while (this.rotation > 180.0) {
                this.rotation -= 360.0;
            }
            this.update();
            if (this.isSelected()) {
                this.cyAnnotator.getAnnotationSelection().getBounds();
            }
            this.firePropertyChange("rotation", oldValue, rotation);
        }
    }

    public void setBounds(Rectangle2D bounds) {
        this.x = bounds.getX();
        this.y = bounds.getY();
        this.setSize(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getRotatedBounds() {
        Rectangle2D bounds = this.getBounds();
        if (this.getRotation() != 0.0) {
            AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
            bounds = transform.createTransformedShape(bounds).getBounds2D();
        }
        return bounds;
    }

    @Override
    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void saveBounds() {
        this.initialBounds = this.getBounds().getBounds2D();
    }

    @Override
    public Rectangle2D getInitialBounds() {
        return this.initialBounds;
    }

    public void resizeAnnotationRelative(Rectangle2D initialBounds, Rectangle2D outlineBounds) {
        Rectangle2D daBounds = this.getInitialBounds();
        double deltaW = outlineBounds.getWidth() / initialBounds.getWidth();
        double deltaH = outlineBounds.getHeight() / initialBounds.getHeight();
        double deltaX = (daBounds.getX() - initialBounds.getX()) / initialBounds.getWidth();
        double deltaY = (daBounds.getY() - initialBounds.getY()) / initialBounds.getHeight();
        Rectangle2D newBounds = AbstractAnnotation.adjustBounds(daBounds, outlineBounds, deltaX, deltaY, deltaW, deltaH);
        this.setBounds(newBounds);
    }

    private static Rectangle2D adjustBounds(Rectangle2D bounds, Rectangle2D outerBounds, double dx, double dy, double dw, double dh) {
        double newX = outerBounds.getX() + dx * outerBounds.getWidth();
        double newY = outerBounds.getY() + dy * outerBounds.getHeight();
        double newWidth = bounds.getWidth() * dw;
        double newHeight = bounds.getHeight() * dh;
        return new Rectangle2D.Double(newX, newY, newWidth, newHeight);
    }

    @Override
    public double getZoom() {
        return 1.0;
    }

    @Override
    public DingAnnotation.CanvasID getCanvas() {
        return this.canvas;
    }

    public void setCanvas(String name) {
        DingAnnotation.CanvasID canvasID = DingAnnotation.CanvasID.fromArgName(name);
        this.changeCanvas(canvasID);
        this.update();
    }

    @Override
    public void changeCanvas(DingAnnotation.CanvasID canvas) {
        if (!Objects.equals((Object)canvas, (Object)this.canvas)) {
            DingAnnotation.CanvasID oldValue = this.canvas;
            this.canvas = canvas;
            this.firePropertyChange("canvas", (Object)oldValue, (Object)canvas);
            for (ArrowAnnotation arrow : this.arrowList) {
                if (!(arrow instanceof DingAnnotation)) continue;
                ((DingAnnotation)arrow).changeCanvas(canvas);
            }
        }
    }

    public CyNetworkView getNetworkView() {
        return this.re.getViewModel();
    }

    public DRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int z) {
        this.zOrder = z;
    }

    @Override
    public CyAnnotator getCyAnnotator() {
        return this.cyAnnotator;
    }

    @Override
    public void setGroupParent(GroupAnnotation parent) {
        if (parent instanceof GroupAnnotationImpl) {
            this.groupParent = (GroupAnnotationImpl)parent;
        } else if (parent == null) {
            this.groupParent = null;
        }
    }

    @Override
    public GroupAnnotation getGroupParent() {
        return this.groupParent;
    }

    public void moveAnnotation(Point2D location) {
        if (!(this instanceof ArrowAnnotationImpl)) {
            this.setLocation(location.getX(), location.getY());
        }
    }

    public void removeAnnotation() {
        this.cyAnnotator.removeAnnotation(this);
        for (ArrowAnnotation arrow : this.arrowList) {
            if (!(arrow instanceof DingAnnotation)) continue;
            ((DingAnnotation)arrow).removeAnnotation();
        }
        if (this.groupParent != null) {
            this.groupParent.removeMember(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!Objects.equals(name, this.name)) {
            String oldValue = this.name;
            this.name = name;
            this.update();
            this.firePropertyChange("name", oldValue, name);
        }
    }

    public boolean isSelected() {
        return this.cyAnnotator.getAnnotationSelection().contains(this);
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected()) {
            this.cyAnnotator.setSelectedAnnotation(this, selected);
            this.update();
            this.firePropertyChange("selected", !selected, selected);
        }
    }

    public void addArrow(ArrowAnnotation arrow) {
        this.arrowList.add(arrow);
        this.update();
    }

    public void removeArrow(ArrowAnnotation arrow) {
        this.arrowList.remove(arrow);
        this.update();
    }

    public Set<ArrowAnnotation> getArrows() {
        return this.arrowList;
    }

    public Map<String, String> getArgMap() {
        HashMap<String, String> argMap = new HashMap<String, String>();
        if (this.name != null) {
            argMap.put("name", this.name);
        }
        argMap.put("x", Double.toString(this.getX()));
        argMap.put("y", Double.toString(this.getY()));
        argMap.put("rotation", Double.toString(this.getRotation()));
        argMap.put("canvas", this.canvas.toArgName());
        argMap.put("uuid", this.uuid.toString());
        if (this.groupParent != null) {
            argMap.put("parent", this.groupParent.getUUID().toString());
        }
        argMap.put("z", Integer.toString(this.getZOrder()));
        return argMap;
    }

    @Override
    public boolean isUsedForPreviews() {
        return this.usedForPreviews;
    }

    public void update() {
        this.contentChanged();
    }

    @Override
    public void paint(Graphics g, boolean showSelected) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.isUsedForPreviews()) {
            g2.setComposite(AlphaComposite.Src);
        }
    }

    @Override
    public void contentChanged() {
        if (this.re != null) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String toString() {
        Map<String, String> args = this.getArgMap();
        String type = args.get("type");
        if (type.endsWith("BoundedTextAnnotation")) {
            return "Bounded Text annotation at " + (int)this.x + "," + (int)this.y + " named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        if (type.endsWith("TextAnnotation")) {
            return "Text annotation at " + (int)this.x + "," + (int)this.y + " named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        if (type.endsWith("ShapeAnnotation")) {
            return "Shape annotation at " + (int)this.x + "," + (int)this.y + " named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        if (type.endsWith("ImageAnnotation")) {
            return "Image annotation at " + (int)this.x + "," + (int)this.y + " named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        if (type.endsWith("ArrowAnnotation")) {
            return "Arrow annotation named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        if (type.endsWith("GroupAnnotation")) {
            return "Group annotation at " + (int)this.x + "," + (int)this.y + " named \"" + this.getName() + "\" with ID: " + this.getUUID();
        }
        return "Unknown annotation type";
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public int hashCode() {
        int prime = 41;
        int result = 17;
        result = 41 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnnotation)) {
            return false;
        }
        AbstractAnnotation other = (AbstractAnnotation)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

