/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class AnnotationFactoryManager {
    private List<AnnotationFactory<? extends Annotation>> annotationFactories = new CopyOnWriteArrayList<AnnotationFactory<? extends Annotation>>();

    public Annotation createAnnotation(String type, CyNetworkView view, Map<String, String> argMap) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(type);
            if (Annotation.class.isAssignableFrom(clazz)) {
                return this.createAnnotation(clazz, view, argMap);
            }
            return null;
        }
        catch (Exception e) {
            clazz = null;
            if (type.equals("ARROW") || type.equals("org.cytoscape.view.presentation.annotations.ArrowAnnotation")) {
                return this.createAnnotation(ArrowAnnotation.class, view, argMap);
            }
            if (type.equals("SHAPE") || type.equals("org.cytoscape.view.presentation.annotations.ShapeAnnotation")) {
                return this.createAnnotation(ShapeAnnotation.class, view, argMap);
            }
            if (type.equals("TEXT") || type.equals("org.cytoscape.view.presentation.annotations.TextAnnotation")) {
                return this.createAnnotation(TextAnnotation.class, view, argMap);
            }
            if (type.equals("BOUNDEDTEXT") || type.equals("org.cytoscape.view.presentation.annotations.BoundedTextAnnotation")) {
                return this.createAnnotation(BoundedTextAnnotation.class, view, argMap);
            }
            if (type.equals("IMAGE") || type.equals("org.cytoscape.view.presentation.annotations.ImageAnnotation")) {
                return this.createAnnotation(ImageAnnotation.class, view, argMap);
            }
            return null;
        }
    }

    public Annotation createAnnotation(Class type, CyNetworkView view, Map<String, String> argMap) {
        for (AnnotationFactory<? extends Annotation> factory : this.annotationFactories) {
            Annotation annotation = factory.createAnnotation(type, view, argMap);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public void addAnnotationFactory(AnnotationFactory<?> factory, Map<?, ?> props) {
        if (factory != null) {
            this.annotationFactories.add(factory);
        }
    }

    public void removeAnnotationFactory(AnnotationFactory<?> factory, Map<?, ?> props) {
        if (factory != null) {
            this.annotationFactories.remove(factory);
        }
    }

    public List<AnnotationFactory<?>> getAnnotationFactories() {
        return new ArrayList(this.annotationFactories);
    }
}

