/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugProgressMonitorFactory;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.TransformChangeListener;
import org.cytoscape.ding.impl.canvas.CompositeImageCanvas;
import org.cytoscape.ding.impl.canvas.ImageFuture;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;

public abstract class RenderComponent
extends JComponent {
    protected DRenderingEngine re;
    protected CompositeImageCanvas fastCanvas;
    protected CompositeImageCanvas slowCanvas;
    private ImageFuture slowFuture;
    private ImageFuture fastFuture;
    private DRenderingEngine.UpdateType updateType = DRenderingEngine.UpdateType.ALL_FULL;
    private RenderDetailFlags lastFastRenderFlags;
    private boolean initialized = false;
    private Runnable initializedCallback;
    private double dpiScaleFactor = 1.0;
    private NetworkTransform.Snapshot slowCanvasLastPaintSnapshot;
    private NetworkTransform.Snapshot fastCanvasPanStartedSnapshot;
    private NetworkTransform.Snapshot fastCanvasLastPaintSnapshot;

    public RenderComponent(DRenderingEngine re, GraphLOD lod) {
        this.re = re;
        this.slowCanvas = new CompositeImageCanvas(re, lod, 1, 1);
        this.fastCanvas = new CompositeImageCanvas(re, lod.faster(), 1, 1);
    }

    abstract ProgressMonitor getSlowProgressMonitor();

    abstract DebugFrameType getDebugFrameType(DRenderingEngine.UpdateType var1);

    public void startPan() {
        this.fastCanvasPanStartedSnapshot = this.getTransform().snapshot();
    }

    private void takeSlowPaintSnapshot() {
        this.slowCanvasLastPaintSnapshot = this.getTransform().snapshot();
    }

    private void takeFastPaintSnapshot() {
        this.fastCanvasLastPaintSnapshot = this.getTransform().snapshot();
    }

    public void endPan() {
        this.slowCanvasLastPaintSnapshot = null;
        this.fastCanvasPanStartedSnapshot = null;
        this.fastCanvasLastPaintSnapshot = null;
    }

    public void setInitializedCallback(Runnable callback) {
        this.initializedCallback = callback;
    }

    public double getDpiScaleFactor() {
        return this.dpiScaleFactor;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.resizeImageBuffers();
        if (!this.initialized) {
            this.initialized = true;
            if (this.initializedCallback != null) {
                this.initializedCallback.run();
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateView(DRenderingEngine.UpdateType.ALL_FULL);
        }
    }

    private void resizeImageBuffers() {
        int bufferWidth = this.getWidth();
        int bufferHeight = this.getHeight();
        this.fastCanvas.getTransform().setViewport(bufferWidth, bufferHeight);
        this.slowCanvas.getTransform().setViewport(bufferWidth, bufferHeight);
    }

    private void updateDPIScaleFactor() {
        this.fastCanvas.getTransform().setDPIScaleFactor(this.dpiScaleFactor);
        this.slowCanvas.getTransform().setDPIScaleFactor(this.dpiScaleFactor);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public RenderDetailFlags getLastFastRenderFlags() {
        return this.lastFastRenderFlags;
    }

    public NetworkTransform getTransform() {
        return this.fastCanvas.getTransform();
    }

    public void addTransformChangeListener(TransformChangeListener l) {
        this.fastCanvas.getTransform().addTransformChangeListener(l);
    }

    public void removeTransformChangeListener(TransformChangeListener l) {
        this.fastCanvas.getTransform().removeTransformChangeListener(l);
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.fastCanvas.setBackgroundPaint(backgroundPaint);
        this.slowCanvas.setBackgroundPaint(backgroundPaint);
    }

    public Color getBackgroundPaint() {
        return this.fastCanvas.getBackgroundPaint();
    }

    public void setLOD(GraphLOD lod) {
        this.slowCanvas.setLOD(lod);
    }

    public void setCenter(double x, double y) {
        this.slowCanvas.getTransform().setCenter(x, y);
        this.fastCanvas.getTransform().setCenter(x, y);
    }

    public void setScaleFactor(double scaleFactor) {
        this.slowCanvas.getTransform().setScaleFactor(scaleFactor);
        this.fastCanvas.getTransform().setScaleFactor(scaleFactor);
    }

    public void setScaleFactorAndCenter(double scaleFactor, double x, double y) {
        this.slowCanvas.getTransform().setScaleFactorAndCenter(scaleFactor, x, y);
        this.fastCanvas.getTransform().setScaleFactorAndCenter(scaleFactor, x, y);
    }

    public void updateView(DRenderingEngine.UpdateType updateType) {
        ViewUtil.invokeOnEDTAndWait(() -> {
            if (this.slowFuture != null) {
                this.slowFuture.cancel();
            }
            if (this.fastFuture != null) {
                this.fastFuture.cancel();
            }
            this.updateType = updateType;
            this.repaint();
        });
    }

    public Image getImage() {
        Image[] image = new Image[]{null};
        ViewUtil.invokeOnEDTAndWait(() -> {
            ImageFuture future = this.slowFuture != null && this.slowFuture.isReady() ? this.slowFuture : (this.fastFuture != null && this.fastFuture.isReady() ? this.fastFuture : this.fastCanvas.paint(null));
            image[0] = future.join();
        });
        return image[0];
    }

    private CompositeImageCanvas.PaintParameters getFastCanvasPaintParams() {
        RenderDetailFlags flags = this.fastCanvas.getRenderDetailFlags(this.updateType);
        if (flags.has(1024)) {
            if (flags.renderEdges() != GraphLOD.RenderEdges.NONE) {
                return CompositeImageCanvas.PaintParameters.updateType(this.updateType);
            }
            if (this.updateType == DRenderingEngine.UpdateType.JUST_ANNOTATIONS && Objects.equals(this.slowCanvasLastPaintSnapshot, this.fastCanvasLastPaintSnapshot)) {
                return CompositeImageCanvas.PaintParameters.pan(0, 0, this.slowCanvas, "slow");
            }
            if ((this.updateType == DRenderingEngine.UpdateType.ALL_FAST || this.updateType == DRenderingEngine.UpdateType.ALL_FULL) && this.fastCanvasPanStartedSnapshot != null) {
                if (Objects.equals(this.slowCanvasLastPaintSnapshot, this.fastCanvasPanStartedSnapshot)) {
                    int[] dxdy = this.getBufferPanDxDy(this.slowCanvasLastPaintSnapshot);
                    int dx = dxdy[0];
                    int dy = dxdy[1];
                    return CompositeImageCanvas.PaintParameters.pan(dx, dy, this.slowCanvas, "slow");
                }
                if (this.fastCanvasLastPaintSnapshot != null) {
                    int[] dxdy = this.getBufferPanDxDy(this.fastCanvasLastPaintSnapshot);
                    int dx = dxdy[0];
                    int dy = dxdy[1];
                    return CompositeImageCanvas.PaintParameters.pan(dx, dy, this.fastCanvas, "fast");
                }
            }
        }
        return CompositeImageCanvas.PaintParameters.updateType(this.updateType);
    }

    private int[] getBufferPanDxDy(NetworkTransform.Snapshot snapshot) {
        NetworkTransform currentTransform = this.fastCanvas.getTransform();
        double[] coords = new double[]{snapshot.x, snapshot.y};
        currentTransform.xformNodeToImageCoords(coords);
        double oldX = coords[0];
        double oldY = coords[1];
        coords[0] = currentTransform.getCenterX();
        coords[1] = currentTransform.getCenterY();
        currentTransform.xformNodeToImageCoords(coords);
        double newX = coords[0];
        double newY = coords[1];
        double dpiScale = currentTransform.getDpiScaleFactor();
        int dx = (int)((oldX - newX) * dpiScale);
        int dy = (int)((oldY - newY) * dpiScale);
        return new int[]{dx, dy};
    }

    @Override
    public void paint(Graphics g) {
        double scaleX;
        if (this.re.getGraphLOD().isHidpiEnabled()) {
            GraphicsConfiguration config = ((Graphics2D)g).getDeviceConfiguration();
            AffineTransform trans = config.getDefaultTransform();
            scaleX = trans.getScaleX();
        } else {
            scaleX = 1.0;
        }
        if (scaleX != this.dpiScaleFactor) {
            this.dpiScaleFactor = scaleX;
            if (this.slowFuture != null) {
                this.slowFuture.cancel();
            }
            if (this.fastFuture != null) {
                this.fastFuture.cancel();
            }
            this.updateDPIScaleFactor();
        }
        super.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        ImageFuture future;
        super.paintComponent(g);
        if (this.slowFuture != null && this.slowFuture.isReady()) {
            future = this.slowFuture;
        } else if (this.fastFuture != null && this.fastFuture.isReady()) {
            future = this.fastFuture;
        } else {
            if (this.slowFuture != null) {
                this.slowFuture.cancel();
                if (!this.slowFuture.isCompletedExceptionally()) {
                    this.slowFuture.join();
                }
                this.slowFuture = null;
            }
            CompositeImageCanvas.PaintParameters paintParams = this.getFastCanvasPaintParams();
            this.fastFuture = this.fastCanvas.paint(this.debugPm(this.updateType), paintParams);
            this.fastFuture.thenRun(() -> {
                if (!paintParams.isPan()) {
                    this.takeFastPaintSnapshot();
                }
            });
            this.fastFuture.join();
            this.lastFastRenderFlags = this.fastFuture.getLastRenderDetail();
            future = this.fastFuture;
            if (this.updateType == DRenderingEngine.UpdateType.ALL_FULL && !this.sameDetail()) {
                ProgressMonitor slowPm = this.debugPm(this.updateType, this.getSlowProgressMonitor());
                this.slowFuture = this.slowCanvas.paint(slowPm, CompositeImageCanvas.PaintParameters.updateType(this.updateType));
                this.slowFuture.thenRun(() -> {
                    this.takeSlowPaintSnapshot();
                    this.repaint();
                });
            }
            this.updateType = DRenderingEngine.UpdateType.ALL_FAST;
        }
        Image image = future.join();
        this.setRenderDetailFlags(future.getLastRenderDetail());
        int w = (int)((double)image.getWidth(null) / this.dpiScaleFactor);
        int h = (int)((double)image.getHeight(null) / this.dpiScaleFactor);
        g.drawImage(image, 0, 0, w, h, null);
    }

    protected void setRenderDetailFlags(RenderDetailFlags flags) {
    }

    private ProgressMonitor debugPm(DRenderingEngine.UpdateType updateType) {
        return this.debugPm(updateType, null);
    }

    private ProgressMonitor debugPm(DRenderingEngine.UpdateType updateType, ProgressMonitor pm) {
        DebugProgressMonitorFactory factory = this.re.getDebugProgressMonitorFactory();
        if (factory != null) {
            DebugFrameType debugType = this.getDebugFrameType(updateType);
            return factory.create(debugType, pm);
        }
        return pm;
    }

    private boolean sameDetail() {
        return this.fastFuture.getLastRenderDetail().equals(this.slowCanvas.getRenderDetailFlags(this.updateType));
    }

    public void dispose() {
        this.fastCanvas.dispose();
        this.slowCanvas.dispose();
        this.re = null;
    }

    public void showAnnotationSelection(boolean show) {
        this.fastCanvas.showAnnotationSelection(show);
        this.slowCanvas.showAnnotationSelection(show);
    }
}

