/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.util.Set;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.DingCanvas;
import org.cytoscape.ding.impl.canvas.GraphicsProvider;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.graph.render.stateful.GraphRenderer;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;

public class NodeCanvas<GP extends GraphicsProvider>
extends DingCanvas<GP> {
    private final VisualMappingManager vmm;
    private final DRenderingEngine re;
    private final GraphGraphics graphGraphics;

    public NodeCanvas(GP graphics, DRenderingEngine re) {
        super(graphics);
        this.re = re;
        this.vmm = (VisualMappingManager)re.getServiceRegistrar().getService(VisualMappingManager.class);
        this.graphGraphics = new GraphGraphics((GraphicsProvider)graphics);
    }

    @Override
    public String getCanvasDebugName() {
        return "Nodes";
    }

    private Set<VisualPropertyDependency<?>> getVPDeps() {
        CyNetworkView netView = this.re.getViewModel();
        return this.vmm.getVisualStyle(netView).getAllVisualPropertyDependencies();
    }

    @Override
    public void paint(ProgressMonitor pm, RenderDetailFlags flags) {
        Set<VisualPropertyDependency<?>> dependencies = this.getVPDeps();
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        NodeDetails nodeDetails = this.re.getNodeDetails();
        LabelInfoProvider labelProvider = flags.has(2048) ? this.re.getLabelCache() : LabelInfoProvider.NO_CACHE;
        this.graphGraphics.update(flags, true);
        GraphRenderer.renderNodes(pm, this.graphGraphics, snapshot, flags, nodeDetails, dependencies, labelProvider);
    }
}

