/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.ding.impl.TransformChangeListener;

public class NetworkTransform {
    private int width;
    private int height;
    private double x = 0.0;
    private double y = 0.0;
    private double scaleFactor = 1.0;
    private double dpiScaleFactor = 1.0;
    private final AffineTransform windowXform = new AffineTransform();
    private final AffineTransform paintXform = new AffineTransform();
    private final Rectangle2D.Float area = new Rectangle2D.Float();
    private final List<TransformChangeListener> transformChangeListeners = new CopyOnWriteArrayList<TransformChangeListener>();

    public NetworkTransform(int width, int height) {
        this.width = width;
        this.height = height;
        this.updateTransform();
    }

    public NetworkTransform(int width, int height, double x, double y, double scaleFactor) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.scaleFactor = scaleFactor;
        this.updateTransform();
    }

    public NetworkTransform(NetworkTransform t) {
        this.width = t.width;
        this.height = t.height;
        this.x = t.x;
        this.y = t.y;
        this.scaleFactor = t.scaleFactor;
        this.dpiScaleFactor = t.dpiScaleFactor;
        this.updateTransform();
    }

    public Snapshot snapshot() {
        return new Snapshot(this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelWidth() {
        return (int)((double)this.width * this.dpiScaleFactor);
    }

    public int getPixelHeight() {
        return (int)((double)this.height * this.dpiScaleFactor);
    }

    public double getCenterX() {
        return this.x;
    }

    public double getCenterY() {
        return this.y;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.x, this.y);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getDpiScaleFactor() {
        return this.dpiScaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (this.scaleFactor != scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.updateTransform();
        }
    }

    public void setDPIScaleFactor(double dpiScaleFactor) {
        if (this.dpiScaleFactor != dpiScaleFactor) {
            this.dpiScaleFactor = dpiScaleFactor;
            this.updateTransform();
        }
    }

    public void setCenter(double x, double y) {
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
            this.updateTransform();
        }
    }

    public void setViewport(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.updateTransform();
        }
    }

    public void setScaleFactorAndCenter(double scaleFactor, double x, double y) {
        if (this.x != x || this.y != y || this.scaleFactor != scaleFactor) {
            this.x = x;
            this.y = y;
            this.scaleFactor = scaleFactor;
            this.updateTransform();
        }
    }

    private void updateTransform() {
        this.windowXform.setToTranslation(0.5 * (double)this.width, 0.5 * (double)this.height);
        this.windowXform.scale(this.scaleFactor, this.scaleFactor);
        this.windowXform.translate(-this.x, -this.y);
        this.paintXform.setToTranslation(0.5 * (double)this.getPixelWidth(), 0.5 * (double)this.getPixelHeight());
        this.paintXform.scale(this.scaleFactor, this.scaleFactor);
        this.paintXform.scale(this.dpiScaleFactor, this.dpiScaleFactor);
        this.paintXform.translate(-this.x, -this.y);
        float xMin = (float)(this.x - 0.5 * (double)this.width / this.scaleFactor);
        float yMin = (float)(this.y - 0.5 * (double)this.height / this.scaleFactor);
        float xMax = (float)(this.x + 0.5 * (double)this.width / this.scaleFactor);
        float yMax = (float)(this.y + 0.5 * (double)this.height / this.scaleFactor);
        this.area.setRect(xMin, yMin, xMax - xMin, yMax - yMin);
        this.fireTransformChanged();
    }

    public void addTransformChangeListener(TransformChangeListener l) {
        this.transformChangeListeners.add(l);
    }

    public void removeTransformChangeListener(TransformChangeListener l) {
        this.transformChangeListeners.remove(l);
    }

    private void fireTransformChanged() {
        for (TransformChangeListener l : this.transformChangeListeners) {
            l.transformChanged();
        }
    }

    public Rectangle2D.Float getNetworkVisibleAreaNodeCoords() {
        return this.area;
    }

    public AffineTransform getPaintAffineTransform() {
        return this.paintXform;
    }

    public AffineTransform getWindowAffineTransform() {
        return this.windowXform;
    }

    public final void xformImageToNodeCoords(double[] coords) {
        try {
            this.windowXform.inverseTransform(coords, 0, coords, 0, 1);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException("noninvertible matrix - cannot happen");
        }
    }

    public final void xformNodeToImageCoords(double[] coords) {
        this.windowXform.transform(coords, 0, coords, 0, 1);
    }

    public GeneralPath pathInNodeCoords(GeneralPath path) {
        try {
            GeneralPath transformedPath = new GeneralPath(path);
            transformedPath.transform(this.windowXform.createInverse());
            return transformedPath;
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public Rectangle2D getNodeCoordinates(Rectangle2D bounds) {
        double x1 = bounds.getX();
        double y1 = bounds.getY();
        double[] p1 = new double[]{x1, y1};
        this.xformImageToNodeCoords(p1);
        double x2 = bounds.getX() + bounds.getWidth();
        double y2 = bounds.getY() + bounds.getHeight();
        double[] p2 = new double[]{x2, y2};
        this.xformImageToNodeCoords(p2);
        return new Rectangle2D.Double(p1[0], p1[1], p2[0] - p1[0], p2[1] - p1[1]);
    }

    public Rectangle getImageCoordinates(Rectangle2D bounds) {
        double x1 = bounds.getX();
        double y1 = bounds.getY();
        double[] p1 = new double[]{x1, y1};
        this.xformNodeToImageCoords(p1);
        double x2 = bounds.getX() + bounds.getWidth();
        double y2 = bounds.getY() + bounds.getHeight();
        double[] p2 = new double[]{x2, y2};
        this.xformNodeToImageCoords(p2);
        return new Rectangle((int)p1[0], (int)p1[1], (int)(p2[0] - p1[0]), (int)(p2[1] - p1[1]));
    }

    public Point2D getNodeCoordinates(double x, double y) {
        double[] p1 = new double[]{x, y};
        this.xformImageToNodeCoords(p1);
        return new Point2D.Double(p1[0], p1[1]);
    }

    public Point2D getNodeCoordinates(Point2D p) {
        return this.getNodeCoordinates(p.getX(), p.getY());
    }

    public Point getImageCoordinates(double x, double y) {
        double[] p1 = new double[]{x, y};
        this.xformNodeToImageCoords(p1);
        return new Point((int)p1[0], (int)p1[1]);
    }

    public Point getImageCoordinates(Point2D p) {
        return this.getImageCoordinates(p.getX(), p.getY());
    }

    public float getNodeDistance(int imageUnits) {
        return (float)((double)imageUnits / this.scaleFactor);
    }

    public static class Snapshot {
        public final double x;
        public final double y;
        public final double scaleFactor;

        private Snapshot(NetworkTransform nt) {
            this.x = nt.x;
            this.y = nt.y;
            this.scaleFactor = nt.scaleFactor;
        }

        public int hashCode() {
            return Objects.hash(this.scaleFactor, this.x, this.y);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Snapshot)) {
                return false;
            }
            Snapshot other = (Snapshot)obj;
            return this.scaleFactor == other.scaleFactor && this.x == other.x && this.y == other.y;
        }
    }
}

