/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.AnnotationCanvas;
import org.cytoscape.ding.impl.canvas.AnnotationThumbnailCanvas;
import org.cytoscape.ding.impl.canvas.DingCanvas;
import org.cytoscape.ding.impl.canvas.EdgeCanvas;
import org.cytoscape.ding.impl.canvas.EdgeThumbnailCanvas;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.canvas.NodeCanvas;
import org.cytoscape.ding.impl.canvas.NodeThumbnailCanvas;
import org.cytoscape.ding.impl.canvas.SimpleGraphicsProvider;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.work.NoOutputProgressMonitor;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.presentation.annotations.Annotation;

public class CompositeGraphicsCanvas {
    public static void paint(Graphics2D graphics, Color bgPaint, GraphLOD lod, NetworkTransform transform, DRenderingEngine re, boolean pdfFontHack) {
        SimpleGraphicsProvider g = new SimpleGraphicsProvider(transform, graphics);
        CyNetworkViewSnapshot snapshot = re.getViewModelSnapshot();
        NoOutputProgressMonitor pm = new NoOutputProgressMonitor();
        RenderDetailFlags flags = RenderDetailFlags.create(snapshot, transform, lod, null);
        if (pdfFontHack) {
            flags = flags.add(4096);
        }
        List<DingCanvas> canvasList = Arrays.asList(new AnnotationCanvas<SimpleGraphicsProvider>(g, re, DingAnnotation.CanvasID.FOREGROUND, false), new NodeCanvas<SimpleGraphicsProvider>(g, re), new EdgeCanvas<SimpleGraphicsProvider>(g, re), new AnnotationCanvas<SimpleGraphicsProvider>(g, re, DingAnnotation.CanvasID.BACKGROUND, false));
        Collections.reverse(canvasList);
        g.fill(bgPaint);
        for (DingCanvas canvas : canvasList) {
            canvas.paint(pm, flags);
        }
    }

    public static void paintThumbnail(Graphics2D graphics, Color bgPaint, GraphLOD lod, NetworkTransform transform, CyNetworkViewSnapshot snapshot, Collection<Annotation> annotations) {
        SimpleGraphicsProvider g = new SimpleGraphicsProvider(transform, graphics);
        RenderDetailFlags flags = RenderDetailFlags.create(snapshot, transform, lod, null);
        NoOutputProgressMonitor pm = new NoOutputProgressMonitor();
        ArrayList<Annotation> foreground = new ArrayList<Annotation>();
        ArrayList<Annotation> background = new ArrayList<Annotation>();
        if (annotations != null) {
            for (Annotation a : annotations) {
                if ("foreground".equals(a.getCanvasName())) {
                    foreground.add(a);
                }
                if (!"background".equals(a.getCanvasName())) continue;
                background.add(a);
            }
        }
        List<DingCanvas> canvasList = Arrays.asList(new AnnotationThumbnailCanvas<SimpleGraphicsProvider>(g, foreground), new NodeThumbnailCanvas<SimpleGraphicsProvider>(g, snapshot), new EdgeThumbnailCanvas<SimpleGraphicsProvider>(g, snapshot), new AnnotationThumbnailCanvas<SimpleGraphicsProvider>(g, background));
        Collections.reverse(canvasList);
        g.fill(bgPaint);
        for (DingCanvas canvas : canvasList) {
            canvas.paint(pm, flags);
        }
    }
}

