/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.DingCanvas;
import org.cytoscape.ding.impl.canvas.GraphicsProvider;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.work.DiscreteProgressMonitor;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;

public class AnnotationCanvas<GP extends GraphicsProvider>
extends DingCanvas<GP> {
    private final DingAnnotation.CanvasID canvasID;
    private final DRenderingEngine re;
    private boolean showSelection = true;

    public AnnotationCanvas(GP graphics, DRenderingEngine re, DingAnnotation.CanvasID canvasID) {
        super(graphics);
        this.re = re;
        this.canvasID = canvasID;
    }

    public AnnotationCanvas(GP graphics, DRenderingEngine re, DingAnnotation.CanvasID canvasID, boolean showSelection) {
        this(graphics, re, canvasID);
        this.showSelection = showSelection;
    }

    public DingAnnotation.CanvasID getCanvasID() {
        return this.canvasID;
    }

    @Override
    public String getCanvasDebugName() {
        return "Annotation " + this.canvasID.name().toLowerCase().substring(0, 4);
    }

    public void setShowSelection(boolean showSelection) {
        this.showSelection = showSelection;
    }

    @Override
    public void paint(ProgressMonitor pm, RenderDetailFlags flags) {
        Graphics2D g = this.graphicsProvider.getGraphics(true);
        if (g == null) {
            return;
        }
        List<DingAnnotation> annotations = this.re.getCyAnnotator().getAnnotations(this.canvasID, false);
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        NetworkTransform transform = this.graphicsProvider.getTransform();
        g.transform(transform.getPaintAffineTransform());
        Rectangle2D.Float visibleArea = transform.getNetworkVisibleAreaNodeCoords();
        DiscreteProgressMonitor dpm = pm.toDiscrete(annotations.size());
        for (DingAnnotation a : annotations) {
            if (pm.isCancelled()) {
                return;
            }
            if (visibleArea.intersects(a.getBounds())) {
                a.paint(g, this.showSelection);
            }
            dpm.increment();
        }
        g.dispose();
    }
}

