/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.ThumbnailChangeListener;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;

public class ThumbnailView
extends JComponent
implements RenderingEngine<CyNetwork>,
ThumbnailChangeListener {
    private final DRenderingEngine re;
    private Image thumbnail;
    private double dpiScaleFactor = 1.0;

    public ThumbnailView(DRenderingEngine re) {
        this.re = Objects.requireNonNull(re);
        re.addThumbnailChangeListener(this);
    }

    @Override
    public void thumbnailChanged(Image image) {
        if (image == null) {
            this.thumbnail = null;
        } else {
            int thumbWidth = (int)((double)this.getWidth() * this.dpiScaleFactor);
            int thumbHeight = (int)((double)this.getHeight() * this.dpiScaleFactor);
            this.thumbnail = ThumbnailView.scaleAndClip(image, thumbWidth, thumbHeight);
        }
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width != this.getWidth() || height != this.getHeight()) {
            super.setBounds(x, y, width, height);
            this.thumbnail = null;
        }
    }

    public void dispose() {
        this.re.removeThumbnailChangeListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        double scaleX;
        if (this.re.getGraphLOD().isHidpiEnabled()) {
            GraphicsConfiguration config = ((Graphics2D)g).getDeviceConfiguration();
            AffineTransform trans = config.getDefaultTransform();
            scaleX = trans.getScaleX();
        } else {
            scaleX = 1.0;
        }
        if (scaleX != this.dpiScaleFactor) {
            this.dpiScaleFactor = scaleX;
            this.thumbnail = null;
        }
        if (this.thumbnail == null) {
            Image image = this.re.getImage();
            int thumbWidth = (int)((double)this.getWidth() * this.dpiScaleFactor);
            int thumbHeight = (int)((double)this.getHeight() * this.dpiScaleFactor);
            this.thumbnail = ThumbnailView.scaleAndClip(image, thumbWidth, thumbHeight);
        }
        int w = (int)((double)this.thumbnail.getWidth(null) / this.dpiScaleFactor);
        int h = (int)((double)this.thumbnail.getHeight(null) / this.dpiScaleFactor);
        g.drawImage(this.thumbnail, 0, 0, w, h, null);
    }

    private static Image scaleAndClip(Image image, int w, int h) {
        double rectRatio;
        if (w <= 0 || h <= 0) {
            return null;
        }
        int vw = image.getWidth(null);
        int vh = image.getHeight(null);
        double viewRatio = (double)vh / (double)vw;
        double scale = viewRatio > (rectRatio = (double)h / (double)w) ? (double)w / (double)vw : (double)h / (double)vh;
        int svw = (int)Math.round((double)vw * scale);
        int svh = (int)Math.round((double)vh * scale);
        BufferedImage resized = new BufferedImage(svw, svh, 2);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, svw, svh, 0, 0, vw, vh, null);
        g.dispose();
        BufferedImage thumbnail = resized.getSubimage((svw - w) / 2, (svh - h) / 2, w, h);
        return thumbnail;
    }

    public View<CyNetwork> getViewModel() {
        return this.re.getViewModel();
    }

    public VisualLexicon getVisualLexicon() {
        return this.re.getVisualLexicon();
    }

    public Printable createPrintable() {
        return this.re.createPrintable();
    }

    public <V> Icon createIcon(VisualProperty<V> vp, V value, int width, int height) {
        return this.re.createIcon(vp, value, width, height);
    }

    public void printCanvas(Graphics printCanvas) {
        throw new UnsupportedOperationException("Printing is not supported for Thumbnail view.");
    }

    public String getRendererId() {
        return "org.cytoscape.ding";
    }
}

