/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.HandleInfo;
import org.cytoscape.ding.impl.LabelSelection;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.graph.render.immed.EdgeAnchors;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.graph.render.stateful.EdgeDetails;
import org.cytoscape.graph.render.stateful.GraphRenderer;
import org.cytoscape.graph.render.stateful.LabelInfo;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.spacial.EdgeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.NetworkSpacialIndex2D;
import org.cytoscape.view.model.spacial.SpacialIndex2DEnumerator;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.EdgeStackingVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class NetworkPicker {
    private final DRenderingEngine re;
    private final NodeDetails nodeDetails;
    private final EdgeDetails edgeDetails;
    private RenderDetailFlags renderDetailFlags;

    public NetworkPicker(DRenderingEngine re, RenderDetailFlags renderDetailFlags) {
        this.re = re;
        this.nodeDetails = re.getNodeDetails();
        this.edgeDetails = re.getEdgeDetails();
        this.renderDetailFlags = renderDetailFlags;
    }

    public RenderDetailFlags getLastRenderDetail() {
        return this.renderDetailFlags;
    }

    public RenderDetailFlags getFlags() {
        return this.renderDetailFlags;
    }

    public void setRenderDetailFlags(RenderDetailFlags renderDetailFlags) {
        this.renderDetailFlags = renderDetailFlags;
    }

    private boolean treatNodeShapesAsRectangle() {
        return this.renderDetailFlags.treatNodeShapesAsRectangle();
    }

    public View<CyNode> getNodeAt(Point2D pt) {
        double[] locn = new double[]{pt.getX(), pt.getY()};
        this.re.getTransform().xformImageToNodeCoords(locn);
        float x = (float)locn[0];
        float y = (float)locn[1];
        List<Long> suids = this.getNodesIntersectingRectangle(x, y, x, y);
        if (suids.isEmpty()) {
            return null;
        }
        Long suid = suids.get(suids.size() - 1);
        return this.re.getViewModelSnapshot().getNodeView(suid.longValue());
    }

    public View<CyNode> getNodeForArrowAnnotation(double centerX, double centerY) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        float x = (float)centerX;
        float y = (float)centerY;
        SpacialIndex2DEnumerator under = snapshot.getSpacialIndex2D().queryOverlap(x, y, x, y);
        Long suid = null;
        while (under.hasNext()) {
            suid = (Long)under.next();
        }
        return suid == null ? null : this.re.getViewModelSnapshot().getMutableNodeView(suid.longValue());
    }

    public LabelSelection getEdgeLabelShape(View<CyEdge> edge, LabelInfoProvider labelProvider, float[] floatBuff1, float[] floatBuff2, View<CyNode>[] nodes) {
        EdgeAnchors anchors;
        float trgArrowSize;
        float srcArrowSize;
        ArrowShape trgArrow;
        ArrowShape srcArrow;
        String text = this.edgeDetails.getLabelText(edge);
        if (text == null || text.length() == 0) {
            return null;
        }
        EdgeStacking stacking = this.edgeDetails.getStacking(edge);
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        SnapshotEdgeInfo edgeInfo = snapshot.getEdgeInfo(edge);
        View<CyNode> sourceNode = nodes[0];
        View<CyNode> targetNode = nodes[1];
        NetworkSpacialIndex2D spacialIndex = snapshot.getSpacialIndex2D();
        byte srcShape = this.nodeDetails.getShape(sourceNode);
        byte trgShape = this.nodeDetails.getShape(targetNode);
        float[] floatBuff3 = new float[2];
        float[] floatBuff4 = new float[2];
        float[] floatBuff5 = new float[8];
        if (!this.renderDetailFlags.has(128)) {
            return null;
        }
        if (this.renderDetailFlags.not(16) || stacking == EdgeStackingVisualProperty.HAYSTACK) {
            trgArrow = srcArrow = ArrowShapeVisualProperty.NONE;
            srcArrowSize = 0.0f;
            trgArrowSize = 0.0f;
        } else {
            srcArrow = this.edgeDetails.getSourceArrowShape(edge);
            trgArrow = this.edgeDetails.getTargetArrowShape(edge);
            srcArrowSize = srcArrow == ArrowShapeVisualProperty.NONE ? 0.0f : this.edgeDetails.getSourceArrowSize(edge);
            trgArrowSize = trgArrow == ArrowShapeVisualProperty.NONE ? 0.0f : this.edgeDetails.getTargetArrowSize(edge);
        }
        EdgeAnchors edgeAnchors = anchors = this.renderDetailFlags.not(64) ? null : this.edgeDetails.getAnchors(snapshot, edge);
        if (stacking == EdgeStackingVisualProperty.HAYSTACK) {
            return null;
        }
        GraphRenderer.computeEdgeEndpoints(floatBuff1, srcShape, srcArrow, srcArrowSize, anchors, floatBuff2, trgShape, trgArrow, trgArrowSize, floatBuff3, floatBuff4);
        double degrees = this.edgeDetails.getLabelRotation(edge);
        double rise = floatBuff4[1] - floatBuff3[1];
        double run = floatBuff4[0] - floatBuff3[0];
        double slope = rise / run;
        double lineAngle = Math.atan2(rise, run);
        double theta = this.edgeDetails.getLabelRotation(edge, rise, run) * 0.01745329252;
        double edgeLabelWidth = this.edgeDetails.getLabelWidth(edge);
        Font font = this.edgeDetails.getLabelFont(edge);
        double[] doubleBuff1 = new double[4];
        double[] offsetBuff = new double[2];
        FontRenderContext frc = new FontRenderContext(null, false, false);
        LabelInfo labelInfo = labelProvider.getLabelInfo(text, font, edgeLabelWidth, frc);
        GraphRenderer.getEdgeLabelPosition(edge, this.edgeDetails, this.renderDetailFlags, labelInfo, floatBuff3, floatBuff4, anchors, offsetBuff, doubleBuff1);
        ObjectPosition originalPosition = (ObjectPosition)edge.getVisualProperty(BasicVisualLexicon.EDGE_LABEL_POSITION);
        double h = labelInfo.getTotalHeight();
        double w = labelInfo.getMaxLineWidth();
        double textXCenter = doubleBuff1[0];
        double textYCenter = doubleBuff1[1];
        double edgeAnchorPointX = doubleBuff1[2];
        double edgeAnchorPointY = doubleBuff1[3];
        double xMin = textXCenter - w / 2.0;
        double yMin = textYCenter - h / 2.0;
        double labelAnchorX = edgeAnchorPointX + offsetBuff[0];
        double labelAnchorY = edgeAnchorPointY + offsetBuff[1];
        Shape shape = new Rectangle2D.Double(xMin, yMin, w, h);
        if (degrees != 0.0) {
            double angle = degrees * 0.01745329252;
            AffineTransform rotateTransform = AffineTransform.getRotateInstance(angle, textXCenter, textYCenter);
            shape = rotateTransform.createTransformedShape(shape);
        }
        return new LabelSelection(edge, shape, originalPosition, labelAnchorX, labelAnchorY, degrees, slope, lineAngle);
    }

    public LabelSelection getNodeLabelShape(View<CyNode> node, LabelInfoProvider labelProvider) {
        String text = this.nodeDetails.getLabelText(node);
        if (text == null || text.isBlank()) {
            return null;
        }
        double[] doubleBuff1 = new double[4];
        double[] doubleBuff2 = new double[2];
        ObjectPosition originalPosition = (ObjectPosition)node.getVisualProperty(BasicVisualLexicon.NODE_LABEL_POSITION);
        Font font = this.nodeDetails.getLabelFont(node);
        Position textAnchor = this.nodeDetails.getLabelTextAnchor(node);
        Position nodeAnchor = this.nodeDetails.getLabelNodeAnchor(node);
        float offsetVectorX = this.nodeDetails.getLabelOffsetVectorX(node);
        float offsetVectorY = this.nodeDetails.getLabelOffsetVectorY(node);
        double degrees = this.nodeDetails.getLabelRotation(node);
        double nodeLabelWidth = this.nodeDetails.getLabelWidth(node);
        double x = this.nodeDetails.getXPosition(node);
        double y = this.nodeDetails.getYPosition(node);
        double nodeWidth = this.nodeDetails.getWidth(node);
        double nodeHeight = this.nodeDetails.getHeight(node);
        doubleBuff1[0] = x - nodeWidth / 2.0;
        doubleBuff1[1] = y - nodeHeight / 2.0;
        doubleBuff1[2] = x + nodeWidth / 2.0;
        doubleBuff1[3] = y + nodeHeight / 2.0;
        GraphRenderer.computeAnchor(nodeAnchor, doubleBuff1, doubleBuff2);
        double nodeAnchorPointX = doubleBuff2[0];
        double nodeAnchorPointY = doubleBuff2[1];
        FontRenderContext frc = new FontRenderContext(null, false, false);
        LabelInfo labelInfo = labelProvider.getLabelInfo(text, font, nodeLabelWidth, frc);
        doubleBuff1[0] = -0.5 * labelInfo.getMaxLineWidth();
        doubleBuff1[1] = -0.5 * labelInfo.getTotalHeight();
        doubleBuff1[2] = 0.5 * labelInfo.getMaxLineWidth();
        doubleBuff1[3] = 0.5 * labelInfo.getTotalHeight();
        GraphRenderer.computeAnchor(textAnchor, doubleBuff1, doubleBuff2);
        double textXCenter = nodeAnchorPointX - doubleBuff2[0] + (double)offsetVectorX;
        double textYCenter = nodeAnchorPointY - doubleBuff2[1] + (double)offsetVectorY;
        double h = labelInfo.getTotalHeight();
        double w = labelInfo.getMaxLineWidth();
        double xMin = textXCenter - w / 2.0;
        double yMin = textYCenter - h / 2.0;
        double labelAnchorX = nodeAnchorPointX + (double)offsetVectorX;
        double labelAnchorY = nodeAnchorPointY + (double)offsetVectorY;
        Shape shape = new Rectangle2D.Double(xMin, yMin, w, h);
        if (degrees != 0.0) {
            double angle = degrees * 0.01745329252;
            AffineTransform rotateTransform = AffineTransform.getRotateInstance(angle, labelAnchorX, labelAnchorY);
            shape = rotateTransform.createTransformedShape(shape);
        }
        return new LabelSelection(node, shape, originalPosition, labelAnchorX, labelAnchorY, degrees);
    }

    public LabelSelection getNodeLabelAt(Point2D mousePoint) {
        LabelInfoProvider labelProvider;
        if (!this.renderDetailFlags.has(8)) {
            return null;
        }
        Point2D point = this.re.getTransform().getNodeCoordinates(mousePoint);
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        Rectangle2D.Float area = this.re.getTransform().getNetworkVisibleAreaNodeCoords();
        SpacialIndex2DEnumerator nodeHits = snapshot.getSpacialIndex2D().queryOverlap(area.x, area.y, area.x + area.width, area.y + area.height);
        LabelInfoProvider labelInfoProvider = labelProvider = this.re.getGraphLOD().isLabelCacheEnabled() ? this.re.getLabelCache() : LabelInfoProvider.NO_CACHE;
        while (nodeHits.hasNext()) {
            Long suid = (Long)nodeHits.next();
            View node = snapshot.getNodeView(suid.longValue());
            LabelSelection labelSelection = this.getNodeLabelShape((View<CyNode>)node, labelProvider);
            if (labelSelection == null || !labelSelection.getShape().contains(point)) continue;
            return labelSelection;
        }
        return null;
    }

    public LabelSelection getEdgeLabelAt(Point2D mousePoint) {
        if (!this.renderDetailFlags.has(128)) {
            return null;
        }
        Point2D point = this.re.getTransform().getNodeCoordinates(mousePoint);
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        Rectangle2D.Float area = this.re.getTransform().getNetworkVisibleAreaNodeCoords();
        EdgeSpacialIndex2DEnumerator edgeHits = snapshot.getSpacialIndex2D().queryOverlapEdges(area.x, area.y, area.x + area.width, area.y + area.height, null);
        LabelInfoProvider labelProvider = this.re.getGraphLOD().isLabelCacheEnabled() ? this.re.getLabelCache() : LabelInfoProvider.NO_CACHE;
        float[] sourceExtents = new float[4];
        float[] targetExtents = new float[4];
        View[] nodes = new View[2];
        while (edgeHits.hasNext()) {
            LabelSelection labelSelection;
            View edge = edgeHits.nextEdgeWithNodeExtents(sourceExtents, targetExtents, nodes);
            EdgeStacking stacking = this.edgeDetails.getStacking((View<CyEdge>)edge);
            if (stacking == EdgeStackingVisualProperty.HAYSTACK || (labelSelection = this.getEdgeLabelShape((View<CyEdge>)edge, labelProvider, sourceExtents, targetExtents, nodes)) == null || !labelSelection.getShape().contains(point)) continue;
            return labelSelection;
        }
        return null;
    }

    public View<CyEdge> getEdgeAt(Point2D pt) {
        List<Long> edges = this.getEdgesIntersecting((int)pt.getX(), (int)pt.getY(), (int)pt.getX(), (int)pt.getY());
        if (edges.isEmpty()) {
            return null;
        }
        long chosenEdge = edges.get(edges.size() - 1);
        return this.re.getViewModelSnapshot().getEdgeView(chosenEdge);
    }

    public HandleInfo getHandleAt(Point2D pt) {
        Rectangle r = new Rectangle((int)pt.getX(), (int)pt.getY(), 1, 1);
        List<HandleInfo> handles = this.getHandlesIntersecting(r, 1);
        if (handles.isEmpty()) {
            return null;
        }
        return handles.get(0);
    }

    public List<HandleInfo> getHandlesInRectangle(Rectangle r) {
        return this.getHandlesIntersecting(r, -1);
    }

    private List<HandleInfo> getHandlesIntersecting(Rectangle r, int maxCount) {
        Rectangle2D selectionArea = this.re.getTransform().getNodeCoordinates(r);
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        ArrayList<HandleInfo> resultHandles = maxCount == 1 ? new ArrayList<HandleInfo>(1) : new ArrayList();
        Rectangle2D.Float area = this.re.getTransform().getNetworkVisibleAreaNodeCoords();
        EdgeSpacialIndex2DEnumerator edgeHits = snapshot.getSpacialIndex2D().queryOverlapEdges(area.x, area.y, area.x + area.width, area.y + area.height, null);
        while (edgeHits.hasNext()) {
            View edge = edgeHits.nextEdge();
            this.getHandles(snapshot, (View<CyEdge>)edge, selectionArea, resultHandles);
            if (maxCount <= 0 || resultHandles.size() < maxCount) continue;
            return resultHandles.subList(0, maxCount);
        }
        return resultHandles;
    }

    private void getHandles(CyNetworkViewSnapshot snapshot, View<CyEdge> edge, Rectangle2D selectionAreaNode, List<HandleInfo> resultHandles) {
        List handles;
        Bend bend;
        if (this.edgeDetails.isSelected(edge) && (bend = this.edgeDetails.getBend(edge)) != null && (handles = bend.getAllHandles()) != null) {
            for (Handle handle : handles) {
                Point2D p = handle.calculateHandleLocation((CyNetworkView)snapshot, edge);
                float size = 12.0f;
                if (!selectionAreaNode.intersects(p.getX() - (double)(size / 2.0f), p.getY() - (double)(size / 2.0f), size, size)) continue;
                resultHandles.add(new HandleInfo(edge, bend, handle));
            }
        }
    }

    private List<View<CyNode>> suidsToNodes(List<Long> suids) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        ArrayList<View<CyNode>> selectedNodes = new ArrayList<View<CyNode>>(suids.size());
        for (Long suid : suids) {
            View node = snapshot.getNodeView(suid.longValue());
            if (this.nodeDetails.isSelected((View<CyNode>)node)) continue;
            selectedNodes.add((View<CyNode>)node);
        }
        return selectedNodes;
    }

    private List<View<CyEdge>> suidsToEdges(List<Long> suids) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        ArrayList<View<CyEdge>> selectedEdges = new ArrayList<View<CyEdge>>(suids.size());
        for (Long suid : suids) {
            View edge = snapshot.getEdgeView(suid.longValue());
            if (this.edgeDetails.isSelected((View<CyEdge>)edge)) continue;
            selectedEdges.add((View<CyEdge>)edge);
        }
        return selectedEdges;
    }

    public List<View<CyEdge>> getEdgesInRectangle(Rectangle r) {
        List<Long> suids = this.getEdgesIntersecting(r.x, r.y, r.x + r.width, r.y + r.height);
        return this.suidsToEdges(suids);
    }

    public List<Long> getEdgesIntersecting(int xMini, int yMini, int xMaxi, int yMaxi) {
        double[] ptBuff = new double[]{xMini, yMini};
        this.re.getTransform().xformImageToNodeCoords(ptBuff);
        float xMin = (float)ptBuff[0];
        float yMin = (float)ptBuff[1];
        ptBuff[0] = xMaxi;
        ptBuff[1] = yMaxi;
        this.re.getTransform().xformImageToNodeCoords(ptBuff);
        float xMax = (float)ptBuff[0];
        float yMax = (float)ptBuff[1];
        float[] srcExtents = new float[4];
        float[] trgExtents = new float[4];
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        Rectangle2D.Float area = this.re.getTransform().getNetworkVisibleAreaNodeCoords();
        EdgeSpacialIndex2DEnumerator edgeHits = snapshot.getSpacialIndex2D().queryOverlapEdges(area.x, area.y, area.x + area.width, area.y + area.height, null);
        ArrayList<Long> resultEdges = new ArrayList<Long>();
        if (this.getFlags().not(2)) {
            Line2D.Float line = new Line2D.Float();
            while (edgeHits.hasNext()) {
                View edge = edgeHits.nextEdgeWithNodeExtents(srcExtents, trgExtents, null);
                float sourceNodeX = (srcExtents[0] + srcExtents[2]) / 2.0f;
                float sourceNodeY = (srcExtents[1] + srcExtents[3]) / 2.0f;
                float targetNodeX = (trgExtents[0] + trgExtents[2]) / 2.0f;
                float targetNodeY = (trgExtents[1] + trgExtents[3]) / 2.0f;
                line.setLine(sourceNodeX, sourceNodeY, targetNodeX, targetNodeY);
                if (!line.intersects(xMin, yMin, xMax - xMin, yMax - yMin)) continue;
                resultEdges.add(edge.getSUID());
            }
        } else {
            byte[] haystackDataBuff = new byte[16];
            float[] floatBuff1 = new float[4];
            float[] floatBuff2 = new float[4];
            while (edgeHits.hasNext()) {
                EdgeAnchors anchors;
                float srcArrowSize;
                float trgArrowSize;
                ArrowShape srcArrow;
                ArrowShape trgArrow;
                View edge = edgeHits.nextEdgeWithNodeExtents(srcExtents, trgExtents, null);
                SnapshotEdgeInfo edgeInfo = snapshot.getEdgeInfo(edge);
                long edgeSuid = edgeInfo.getSUID();
                double segThicknessDiv2 = (double)this.edgeDetails.getWidth((View<CyEdge>)edge) / 2.0;
                EdgeStacking stacking = this.edgeDetails.getStacking((View<CyEdge>)edge);
                View sourceNode = edgeInfo.getSourceNodeView();
                View targetNode = edgeInfo.getTargetNodeView();
                byte srcShape = this.nodeDetails.getShape((View<CyNode>)sourceNode);
                byte trgShape = this.nodeDetails.getShape((View<CyNode>)targetNode);
                long srcSuid = sourceNode.getSUID();
                long trgSuid = targetNode.getSUID();
                if (this.getFlags().not(16) || stacking == EdgeStackingVisualProperty.HAYSTACK) {
                    srcArrow = trgArrow = ArrowShapeVisualProperty.NONE;
                    trgArrowSize = 0.0f;
                    srcArrowSize = 0.0f;
                } else {
                    srcArrow = this.edgeDetails.getSourceArrowShape((View<CyEdge>)edge);
                    trgArrow = this.edgeDetails.getTargetArrowShape((View<CyEdge>)edge);
                    srcArrowSize = srcArrow == ArrowShapeVisualProperty.NONE ? 0.0f : this.edgeDetails.getSourceArrowSize((View<CyEdge>)edge);
                    trgArrowSize = trgArrow == ArrowShapeVisualProperty.NONE ? 0.0f : this.edgeDetails.getTargetArrowSize((View<CyEdge>)edge);
                }
                EdgeAnchors edgeAnchors = anchors = this.getFlags().not(64) ? null : this.edgeDetails.getAnchors(snapshot, (View<CyEdge>)edge);
                if (stacking == EdgeStackingVisualProperty.HAYSTACK) {
                    float radiusModifier = this.edgeDetails.getStackingDensity((View<CyEdge>)edge);
                    GraphRenderer.computeEdgeEndpointsHaystack(srcExtents, trgExtents, srcSuid, trgSuid, edgeSuid, radiusModifier, stacking, floatBuff1, floatBuff2, haystackDataBuff);
                } else {
                    GraphRenderer.computeEdgeEndpoints(srcExtents, srcShape, srcArrow, srcArrowSize, anchors, trgExtents, trgShape, trgArrow, trgArrowSize, floatBuff1, floatBuff2);
                }
                GeneralPath path = new GeneralPath();
                GeneralPath path2 = new GeneralPath();
                GraphGraphics.getEdgePath(srcArrow, srcArrowSize, trgArrow, trgArrowSize, floatBuff1[0], floatBuff1[1], anchors, floatBuff2[0], floatBuff2[1], path);
                GraphRenderer.computeClosedPath(path.getPathIterator(null), path2);
                if (!path2.intersects((double)xMin - segThicknessDiv2, (double)yMin - segThicknessDiv2, (double)(xMax - xMin) + segThicknessDiv2 * 2.0, (double)(yMax - yMin) + segThicknessDiv2 * 2.0)) continue;
                resultEdges.add(edge.getSUID());
            }
        }
        return resultEdges;
    }

    public List<View<CyNode>> getNodesInRectangle(Rectangle r) {
        double[] ptBuff = new double[]{r.x, r.y};
        this.re.getTransform().xformImageToNodeCoords(ptBuff);
        float xMin = (float)ptBuff[0];
        float yMin = (float)ptBuff[1];
        ptBuff[0] = r.x + r.width;
        ptBuff[1] = r.y + r.height;
        this.re.getTransform().xformImageToNodeCoords(ptBuff);
        float xMax = (float)ptBuff[0];
        float yMax = (float)ptBuff[1];
        List<Long> nodesXSect = this.getNodesIntersectingRectangle(xMin, yMin, xMax, yMax);
        return this.suidsToNodes(nodesXSect);
    }

    public List<Long> getNodesIntersectingRectangle(double xMinimum, double yMinimum, double xMaximum, double yMaximum) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        float xMin = (float)xMinimum;
        float yMin = (float)yMinimum;
        float xMax = (float)xMaximum;
        float yMax = (float)yMaximum;
        SpacialIndex2DEnumerator under = snapshot.getSpacialIndex2D().queryOverlap(xMin, yMin, xMax, yMax);
        if (!under.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Long> returnVal = new ArrayList<Long>(under.size());
        if (this.treatNodeShapesAsRectangle()) {
            while (under.hasNext()) {
                returnVal.add((Long)under.next());
            }
        } else {
            double x = xMin;
            double y = yMin;
            double w = (double)xMax - (double)xMin;
            double h = (double)yMax - (double)yMin;
            float[] extentsBuff = new float[4];
            while (under.hasNext()) {
                long suid = (Long)under.nextExtents(extentsBuff);
                View cyNode = snapshot.getNodeView(suid);
                if (extentsBuff[0] < xMin && extentsBuff[1] < yMin || extentsBuff[0] < xMin && extentsBuff[3] > yMax || extentsBuff[2] > xMax && extentsBuff[3] > yMax || extentsBuff[2] > xMax && extentsBuff[1] < yMin) {
                    GeneralPath path = new GeneralPath();
                    GraphGraphics.getNodeShape(this.nodeDetails.getShape((View<CyNode>)cyNode), extentsBuff[0], extentsBuff[1], extentsBuff[2], extentsBuff[3], path);
                    if (w > 0.0 && h > 0.0) {
                        if (!path.intersects(x, y, w, h)) continue;
                        returnVal.add(suid);
                        continue;
                    }
                    if (!path.contains(x, y)) continue;
                    returnVal.add(suid);
                    continue;
                }
                returnVal.add(suid);
            }
        }
        return returnVal;
    }

    public List<View<CyNode>> getNodesInPath(GeneralPath path) {
        path = this.re.getTransform().pathInNodeCoords(path);
        if (path == null) {
            return Collections.emptyList();
        }
        List<Long> nodesXSect = this.getNodesIntersectingPath(path);
        return this.suidsToNodes(nodesXSect);
    }

    public List<Long> getNodesIntersectingPath(GeneralPath path) {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        Rectangle2D mbr = path.getBounds2D();
        SpacialIndex2DEnumerator under = snapshot.getSpacialIndex2D().queryOverlap((float)mbr.getMinX(), (float)mbr.getMinY(), (float)mbr.getMaxX(), (float)mbr.getMaxY());
        if (!under.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(under.size());
        float[] extents = new float[4];
        if (this.treatNodeShapesAsRectangle()) {
            while (under.hasNext()) {
                Long suid = (Long)under.nextExtents(extents);
                float x = extents[0];
                float y = extents[1];
                float w = extents[2] - x;
                float h = extents[3] - y;
                if (!path.intersects(x, y, w, h)) continue;
                result.add(suid);
            }
        } else {
            while (under.hasNext()) {
                Long suid = (Long)under.nextExtents(extents);
                View nodeView = snapshot.getNodeView(suid.longValue());
                GeneralPath nodeShape = new GeneralPath();
                GraphGraphics.getNodeShape(this.nodeDetails.getShape((View<CyNode>)nodeView), extents[0], extents[1], extents[2], extents[3], nodeShape);
                Area pathArea = new Area(path);
                Area nodeArea = new Area(nodeShape);
                pathArea.intersect(nodeArea);
                if (pathArea.isEmpty()) continue;
                result.add(suid);
            }
        }
        return result;
    }

    public DingAnnotation getAnnotationAt(DingAnnotation.CanvasID canvasId, Point2D p) {
        List<DingAnnotation> annotations = this.re.getCyAnnotator().getAnnotations(canvasId, true);
        Point2D nodeP = this.re.getTransform().getNodeCoordinates(p);
        DingAnnotation hit = null;
        for (DingAnnotation a : annotations) {
            if (!a.contains(nodeP)) continue;
            hit = a;
            break;
        }
        if (hit != null) {
            while (hit.getGroupParent() != null) {
                hit = (DingAnnotation)hit.getGroupParent();
            }
        }
        return hit;
    }

    public DingAnnotation getAnnotationAt(Point2D p) {
        DingAnnotation a = this.getAnnotationAt(DingAnnotation.CanvasID.FOREGROUND, p);
        if (a == null) {
            a = this.getAnnotationAt(DingAnnotation.CanvasID.BACKGROUND, p);
        }
        return a;
    }

    public List<DingAnnotation> getAnnotationsAt(DingAnnotation.CanvasID canvasId, Point p) {
        List<DingAnnotation> annotations = this.re.getCyAnnotator().getAnnotations(canvasId, true);
        Point2D nodeP = this.re.getTransform().getNodeCoordinates(p);
        ArrayList<DingAnnotation> list = new ArrayList<DingAnnotation>();
        for (DingAnnotation a : annotations) {
            if (!a.contains(nodeP)) continue;
            while (a.getGroupParent() != null) {
                a = (DingAnnotation)a.getGroupParent();
            }
            if (list.contains(a)) continue;
            list.add(a);
        }
        return list;
    }

    public List<DingAnnotation> getAnnotationsAt(Point p) {
        List<DingAnnotation> a = this.getAnnotationsAt(DingAnnotation.CanvasID.FOREGROUND, p);
        a.addAll(this.getAnnotationsAt(DingAnnotation.CanvasID.BACKGROUND, p));
        return a;
    }

    public List<DingAnnotation> getAnnotationsInRectangle(Rectangle rect) {
        Rectangle2D nodeRect = this.re.getTransform().getNodeCoordinates(rect);
        ArrayList<DingAnnotation> anns = new ArrayList<DingAnnotation>();
        for (DingAnnotation a : this.re.getCyAnnotator().getAnnotations()) {
            Rectangle2D bounds = a.getBounds();
            if (a.getGroupParent() != null || !nodeRect.contains(bounds)) continue;
            anns.add(a);
        }
        return anns;
    }

    public List<DingAnnotation> getAnnotationsInPath(GeneralPath path) {
        GeneralPath nodePath = this.re.getTransform().pathInNodeCoords(path);
        ArrayList<DingAnnotation> anns = new ArrayList<DingAnnotation>();
        for (DingAnnotation a : this.re.getCyAnnotator().getAnnotations()) {
            Rectangle2D bounds = a.getBounds();
            if (a.getGroupParent() != null || !nodePath.intersects(bounds)) continue;
            anns.add(a);
        }
        return anns;
    }

    class FalseBooleanSupplier
    implements BooleanSupplier {
        FalseBooleanSupplier() {
        }

        @Override
        public boolean getAsBoolean() {
            return false;
        }
    }
}

