/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.LabelSelection;
import org.cytoscape.ding.impl.canvas.NetworkTransform;

public class LabelSelectionManager {
    public static final String PROP_SELECTION = "selection";
    private final DRenderingEngine re;
    private final SwingPropertyChangeSupport propChangeSupport = new SwingPropertyChangeSupport(this);
    private Set<LabelSelection> selectedNodeLabels = new HashSet<LabelSelection>();
    private Set<LabelSelection> selectedEdgeLabels = new HashSet<LabelSelection>();
    private LabelSelection primarySelection;
    private Point currentDragPoint;

    public LabelSelectionManager(DRenderingEngine re) {
        this.re = re;
    }

    public void add(LabelSelection sel) {
        boolean changed = false;
        changed = sel.getNode() != null ? this.selectedNodeLabels.add(sel) : this.selectedEdgeLabels.add(sel);
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void remove(LabelSelection sel) {
        boolean changed = false;
        changed = sel.getNode() != null ? this.selectedNodeLabels.remove(sel) : this.selectedEdgeLabels.remove(sel);
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void clear() {
        boolean changed = false;
        if (!this.selectedNodeLabels.isEmpty()) {
            this.selectedNodeLabels.clear();
            changed = true;
        }
        if (!this.selectedEdgeLabels.isEmpty()) {
            this.selectedEdgeLabels.clear();
            changed = true;
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void setPrimary(LabelSelection sel) {
        this.primarySelection = sel;
    }

    public Collection<LabelSelection> getSelectedNodeLabels() {
        return this.selectedNodeLabels;
    }

    public Collection<LabelSelection> getSelectedEdgeLabels() {
        return this.selectedEdgeLabels;
    }

    public boolean isEmpty() {
        return this.selectedNodeLabels.isEmpty() && this.selectedEdgeLabels.isEmpty();
    }

    public boolean contains(LabelSelection sel) {
        if (sel.getNode() != null) {
            return this.selectedNodeLabels.contains(sel);
        }
        return this.selectedEdgeLabels.contains(sel);
    }

    public void setCurrentDragPoint(Point offset) {
        this.currentDragPoint = offset;
    }

    public void move(Point p) {
        NetworkTransform transform = this.re.getTransform();
        Point2D nodePt = transform.getNodeCoordinates(p);
        Point2D offsetPt = transform.getNodeCoordinates(this.currentDragPoint);
        double dx = nodePt.getX() - offsetPt.getX();
        double dy = nodePt.getY() - offsetPt.getY();
        this.selectedNodeLabels.forEach(sl -> sl.translate(dx, dy));
        this.selectedEdgeLabels.forEach(sl -> sl.translate(dx, dy));
        this.currentDragPoint = p;
    }

    public void rotate(Point p) {
        if (this.primarySelection == null) {
            return;
        }
        double anchorX = this.primarySelection.getAnchorX();
        double anchorY = this.primarySelection.getAnchorY();
        NetworkTransform transform = this.re.getTransform();
        Point2D pt1 = transform.getNodeCoordinates(this.currentDragPoint);
        Point2D pt2 = transform.getNodeCoordinates(p);
        double angle1 = Math.atan2(pt1.getY() - anchorY, pt1.getX() - anchorX);
        double angle2 = Math.atan2(pt2.getY() - anchorY, pt2.getX() - anchorX);
        double angle = angle2 - angle1;
        this.selectedNodeLabels.forEach(sl -> sl.rotate(angle));
        this.selectedEdgeLabels.forEach(sl -> sl.rotate(angle));
    }

    public void paint(Graphics2D graphics) {
        Shape transformedShape;
        Shape shape;
        Graphics2D g = (Graphics2D)graphics.create();
        g.setColor(UIManager.getColor("Focus.color"));
        AffineTransform transform = this.re.getTransform().getWindowAffineTransform();
        double dpiScale = this.re.getTransform().getDpiScaleFactor();
        g.scale(dpiScale, dpiScale);
        for (LabelSelection sel : this.selectedNodeLabels) {
            shape = sel.getShape();
            transformedShape = transform.createTransformedShape(shape);
            g.draw(transformedShape);
        }
        for (LabelSelection sel : this.selectedEdgeLabels) {
            shape = sel.getShape();
            transformedShape = transform.createTransformedShape(shape);
            g.draw(transformedShape);
        }
    }

    private void fireSelectionChanged() {
        this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL, true);
        this.propChangeSupport.firePropertyChange(PROP_SELECTION, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

