/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Objects;
import org.cytoscape.graph.render.stateful.GraphRenderer;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public class LabelSelection {
    private final View<CyNode> node;
    private final View<CyEdge> edge;
    private final ObjectPosition originalPosition;
    private final double originalAngleDeg;
    private boolean angleChanged = false;
    private double angleRad;
    private double offsetX;
    private double offsetY;
    private double labelAnchorX;
    private double labelAnchorY;
    private Shape shape;
    private double edgeSlope;
    private double edgeAngle;

    public LabelSelection(View<CyEdge> edge, Shape shape, ObjectPosition originalPosition, double labelAnchorX, double labelAnchorY, double angleDegrees, double edgeSlope, double edgeAngle) {
        this.node = null;
        this.edge = edge;
        this.shape = shape;
        this.angleRad = Math.toRadians(angleDegrees);
        this.originalAngleDeg = angleDegrees;
        this.originalPosition = originalPosition;
        this.offsetX = originalPosition.getOffsetX();
        this.offsetY = originalPosition.getOffsetY();
        this.labelAnchorX = labelAnchorX;
        this.labelAnchorY = labelAnchorY;
        this.edgeSlope = edgeSlope;
        this.edgeAngle = edgeAngle;
    }

    public LabelSelection(View<CyNode> node, Shape shape, ObjectPosition originalPosition, double labelAnchorX, double labelAnchorY, double angleDegrees) {
        this.node = node;
        this.edge = null;
        this.shape = shape;
        this.angleRad = Math.toRadians(angleDegrees);
        this.originalAngleDeg = angleDegrees;
        this.originalPosition = originalPosition;
        this.offsetX = originalPosition.getOffsetX();
        this.offsetY = originalPosition.getOffsetY();
        this.labelAnchorX = labelAnchorX;
        this.labelAnchorY = labelAnchorY;
    }

    public View<CyNode> getNode() {
        return this.node;
    }

    public View<CyEdge> getEdge() {
        return this.edge;
    }

    public Shape getShape() {
        return this.shape;
    }

    public double getOriginalAngleDegrees() {
        return this.originalAngleDeg;
    }

    public double getAngleDegrees() {
        return this.angleChanged ? Math.toDegrees(this.angleRad) : this.originalAngleDeg;
    }

    public ObjectPosition getOriginalPosition() {
        return this.originalPosition;
    }

    public ObjectPosition getPosition() {
        ObjectPosition op = new ObjectPosition(this.originalPosition);
        op.setOffsetX(this.offsetX);
        op.setOffsetY(this.offsetY);
        return op;
    }

    public void translate(double dx, double dy) {
        AffineTransform t = AffineTransform.getTranslateInstance(dx, dy);
        this.shape = t.createTransformedShape(this.shape);
        if (this.edge != null && this.edgeSlope != 0.0) {
            double[] xy1 = new double[2];
            double[] xy2 = new double[2];
            GraphRenderer.updateOffset(this.offsetX, this.offsetY, this.edgeSlope, this.edgeAngle, xy1);
            double newX = xy1[0] + dx;
            double newY = xy1[1] + dy;
            GraphRenderer.reverseOffset(newX, newY, this.edgeSlope, this.edgeAngle, xy2);
            dx = xy2[0] - this.offsetX;
            dy = xy2[1] - this.offsetY;
        }
        this.labelAnchorX += dx;
        this.labelAnchorY += dy;
        this.offsetX += dx;
        this.offsetY += dy;
    }

    public void rotate(double rads) {
        AffineTransform t = AffineTransform.getRotateInstance(rads, this.labelAnchorX, this.labelAnchorY);
        this.shape = t.createTransformedShape(this.shape);
        this.angleRad += rads;
        this.angleChanged = true;
    }

    public double getAnchorX() {
        return this.labelAnchorX;
    }

    public double getAnchorY() {
        return this.labelAnchorY;
    }

    public double getEdgeSlope() {
        return this.edgeSlope;
    }

    public double getEdgeAngle() {
        return this.edgeAngle;
    }

    public boolean equals(Object other) {
        if (other instanceof LabelSelection) {
            if (this.node != null) {
                return Objects.equals(((LabelSelection)other).node.getSUID(), this.node.getSUID());
            }
            return Objects.equals(((LabelSelection)other).edge.getSUID(), this.edge.getSUID());
        }
        return false;
    }

    public int hashCode() {
        if (this.node != null) {
            return this.node.getSUID().hashCode();
        }
        return this.edge.getSUID().hashCode();
    }
}

