/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.osgi.framework.Version;

public class DingGraphLOD
implements GraphLOD,
PropertyUpdatedListener {
    private static final int coarseDetailThreshold_default = 8000;
    private static final int nodeBorderThreshold_default = 800;
    private static final int nodeLabelThreshold_default = 400;
    private static final int edgeArrowThreshold_default = 1200;
    private static final int edgeLabelThreshold_default = 400;
    protected int coarseDetailThreshold;
    protected int nodeBorderThreshold;
    protected int nodeLabelThreshold;
    protected int edgeArrowThreshold;
    protected int edgeLabelThreshold;
    protected boolean edgeBufferPan;
    protected boolean labelCache;
    protected boolean hidpi;
    private final Properties props;
    private final CyProperty<Properties> cyProp;
    private final CyServiceRegistrar serviceRegistrar;

    public DingGraphLOD(CyServiceRegistrar serviceRegistrar) {
        this.cyProp = (CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.props = (Properties)this.cyProp.getProperties();
        this.serviceRegistrar = serviceRegistrar;
        this.readProps();
    }

    private void readProps() {
        this.coarseDetailThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.coarseDetailThreshold"), 8000);
        this.nodeBorderThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.nodeBorderThreshold"), 800);
        this.nodeLabelThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.nodeLabelThreshold"), 400);
        this.edgeArrowThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.edgeArrowThreshold"), 1200);
        this.edgeLabelThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.edgeLabelThreshold"), 400);
        this.edgeBufferPan = DingGraphLOD.parseBoolean(this.props.getProperty("render.edgeBufferPan"));
        this.labelCache = DingGraphLOD.parseBoolean(this.props.getProperty("render.labelCache"));
        this.hidpi = DingGraphLOD.parseBoolean(this.props.getProperty("render.hidpi"));
    }

    private static int parseInt(String intString, int defaultValue) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean parseBoolean(String boolString) {
        return !"false".equalsIgnoreCase(boolString);
    }

    public void updatePropsForNewVersionOfCytoscape() {
        String lastUpdated;
        String currentVersion = this.props.getProperty("cytoscape.version.number");
        if (this.shouldUpdateProps(currentVersion, lastUpdated = this.props.getProperty("render.lastUpdated"))) {
            this.readProps();
            if (this.coarseDetailThreshold < 8000) {
                this.props.setProperty("render.coarseDetailThreshold", String.valueOf(8000));
            }
            if (this.nodeBorderThreshold < 800) {
                this.props.setProperty("render.nodeBorderThreshold", String.valueOf(800));
            }
            if (this.nodeLabelThreshold < 400) {
                this.props.setProperty("render.nodeLabelThreshold", String.valueOf(400));
            }
            if (this.edgeArrowThreshold < 1200) {
                this.props.setProperty("render.edgeArrowThreshold", String.valueOf(1200));
            }
            if (this.edgeLabelThreshold < 400) {
                this.props.setProperty("render.edgeLabelThreshold", String.valueOf(400));
            }
            this.props.setProperty("render.lastUpdated", currentVersion);
            System.out.println("render props upgraded to " + currentVersion);
        }
    }

    private boolean shouldUpdateProps(String currentVersionString, String lastUpdatedVersionString) {
        if (currentVersionString == null) {
            return false;
        }
        if (lastUpdatedVersionString == null) {
            return true;
        }
        try {
            Version current = new Version(DingGraphLOD.removeMavenQualifier(currentVersionString));
            Version lastUpdated = new Version(DingGraphLOD.removeMavenQualifier(lastUpdatedVersionString));
            return current.compareTo(lastUpdated) > 0;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String removeMavenQualifier(String ver) {
        int i = ver.indexOf("-");
        if (i >= 0) {
            ver = ver.substring(0, i);
        }
        return ver;
    }

    @Override
    public GraphLOD faster() {
        return new GraphLOD(){

            @Override
            public GraphLOD.RenderEdges renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
                return DingGraphLOD.this.renderEdges(false, visibleNodeCount, totalNodeCount, totalEdgeCount);
            }

            @Override
            public boolean detail(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.detail(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.nodeBorders(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.nodeLabels(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
                return renderNodeCount < DingGraphLOD.this.nodeLabelThreshold;
            }

            @Override
            public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeArrows(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.dashedEdges(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeAnchors(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeLabels(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.textAsShape(renderNodeCount, renderEdgeCount);
            }

            @Override
            public double getNestedNetworkImageScaleFactor() {
                return DingGraphLOD.this.getNestedNetworkImageScaleFactor();
            }

            @Override
            public boolean isEdgeBufferPanEnabled() {
                return DingGraphLOD.this.isEdgeBufferPanEnabled();
            }

            @Override
            public boolean isLabelCacheEnabled() {
                return DingGraphLOD.this.isLabelCacheEnabled();
            }

            @Override
            public boolean isHidpiEnabled() {
                return DingGraphLOD.this.isHidpiEnabled();
            }
        };
    }

    public void handleEvent(PropertyUpdatedEvent e) {
        if (!((CyProperty)e.getSource()).equals(this.cyProp)) {
            return;
        }
        this.readProps();
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (view != null) {
            view.updateView();
        }
    }

    @Override
    public GraphLOD.RenderEdges renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        return this.renderEdges(true, visibleNodeCount, totalNodeCount, totalEdgeCount);
    }

    private GraphLOD.RenderEdges renderEdges(boolean drawEdges, int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        if (totalEdgeCount >= Math.min(this.edgeArrowThreshold, this.edgeLabelThreshold)) {
            if (drawEdges || visibleNodeCount <= Math.max(this.edgeArrowThreshold, this.edgeLabelThreshold) / 2) {
                return GraphLOD.RenderEdges.TOUCHING_VISIBLE_NODES;
            }
            return GraphLOD.RenderEdges.NONE;
        }
        return GraphLOD.RenderEdges.ALL;
    }

    @Override
    public boolean detail(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount + renderEdgeCount < this.coarseDetailThreshold;
    }

    @Override
    public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    @Override
    public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeLabelThreshold;
    }

    @Override
    public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    @Override
    public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    @Override
    public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    @Override
    public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    @Override
    public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeLabelThreshold;
    }

    @Override
    public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    @Override
    public boolean isEdgeBufferPanEnabled() {
        return this.edgeBufferPan;
    }

    @Override
    public boolean isLabelCacheEnabled() {
        return this.labelCache;
    }

    @Override
    public boolean isHidpiEnabled() {
        return this.hidpi;
    }

    @Override
    public double getNestedNetworkImageScaleFactor() {
        String scaleFactor = this.props.getProperty("nestedNetwork.imageScaleFactor", "1.0");
        try {
            double d = Double.valueOf(scaleFactor);
            return d <= 0.0 ? 1.0 : d;
        }
        catch (Exception e) {
            return 1.0;
        }
    }
}

