/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedListener;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.PrintLOD;
import org.cytoscape.ding.debug.DebugProgressMonitorFactory;
import org.cytoscape.ding.debug.DingDebugMediator;
import org.cytoscape.ding.icon.VisualPropertyIconFactory;
import org.cytoscape.ding.impl.BendStore;
import org.cytoscape.ding.impl.ContentChangeListener;
import org.cytoscape.ding.impl.DEdgeDetails;
import org.cytoscape.ding.impl.DNodeDetails;
import org.cytoscape.ding.impl.DingGraphLOD;
import org.cytoscape.ding.impl.DingGraphLODAll;
import org.cytoscape.ding.impl.DingLock;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.InputHandlerGlassPane;
import org.cytoscape.ding.impl.LabelSelection;
import org.cytoscape.ding.impl.LabelSelectionManager;
import org.cytoscape.ding.impl.NetworkPicker;
import org.cytoscape.ding.impl.ThumbnailChangeListener;
import org.cytoscape.ding.impl.TransformChangeListener;
import org.cytoscape.ding.impl.canvas.CompositeGraphicsCanvas;
import org.cytoscape.ding.impl.canvas.MainRenderComponent;
import org.cytoscape.ding.impl.canvas.NetworkImageBuffer;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.cyannotator.AnnotationFactoryManager;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.graph.render.stateful.EdgeDetails;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.LabelInfoCache;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewListener;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.spacial.NetworkSpacialIndex2D;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.HandleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRenderingEngine
implements RenderingEngine<CyNetwork>,
Printable,
CyNetworkViewListener {
    private static final Logger logger = LoggerFactory.getLogger(DRenderingEngine.class);
    protected static int DEF_SNAPSHOT_SIZE = 400;
    private final CyServiceRegistrar serviceRegistrar;
    private final CyEventHelper eventHelper;
    private final DVisualLexicon lexicon;
    private final CyNetworkView viewModel;
    private CyNetworkViewSnapshot viewModelSnapshot;
    final DingLock dingLock = new DingLock();
    private final NodeDetails nodeDetails;
    private final EdgeDetails edgeDetails;
    private final DingGraphLOD dingGraphLOD;
    private MainRenderComponent renderComponent;
    private NetworkPicker picker;
    private BufferedImage snapshotImage;
    private boolean latestSnapshot;
    private final CyAnnotator cyAnnotator;
    private final LabelSelectionManager labelSelectionManager;
    private final List<ContentChangeListener> contentChangeListeners = new CopyOnWriteArrayList<ContentChangeListener>();
    private final List<ThumbnailChangeListener> thumbnailChangeListeners = new CopyOnWriteArrayList<ThumbnailChangeListener>();
    private final int timerDelay = 30;
    private boolean animateEdges = false;
    private int animationCounter = 0;
    private final Timer modelAndAnimationTimer;
    private final DebounceTimer eventFireTimer;
    private final LabelInfoCache labelInfoCache;
    private final BendStore bendStore;
    private InputHandlerGlassPane inputHandler = null;
    private DebugProgressMonitorFactory debugProgressMonitorFactory;
    private final ExecutorService singleThreadExecutor;

    public DRenderingEngine(CyNetworkView view, DVisualLexicon dingLexicon, AnnotationFactoryManager annMgr, DingGraphLOD dingGraphLOD, HandleFactory handleFactory, CyServiceRegistrar registrar) {
        this.serviceRegistrar = registrar;
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
        this.viewModel = view;
        this.lexicon = dingLexicon;
        this.dingGraphLOD = dingGraphLOD;
        this.singleThreadExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("ding-" + thread.getName());
            return thread;
        });
        this.bendStore = new BendStore(this, this.eventHelper, handleFactory);
        this.nodeDetails = new DNodeDetails(registrar);
        this.edgeDetails = new DEdgeDetails(this);
        this.cyAnnotator = new CyAnnotator(this, annMgr, registrar);
        registrar.registerService((Object)this.cyAnnotator, SessionAboutToBeSavedListener.class);
        registrar.registerService((Object)this.cyAnnotator, CustomGraphicsLibraryUpdatedListener.class);
        this.labelSelectionManager = new LabelSelectionManager(this);
        this.renderComponent = new MainRenderComponent(this, dingGraphLOD);
        this.picker = new NetworkPicker(this, null);
        this.addContentChangeListener(ut -> {
            this.latestSnapshot = false;
        });
        this.viewModelSnapshot = this.viewModel.createSnapshot();
        this.labelInfoCache = new LabelInfoCache(1000, DingDebugMediator.showDebugPanel(registrar));
        this.eventFireTimer = new DebounceTimer(240);
        this.modelAndAnimationTimer = new Timer(30, e -> this.timerCheckModelAndAnimate());
        this.modelAndAnimationTimer.setRepeats(true);
        this.modelAndAnimationTimer.start();
        this.renderComponent.addTransformChangeListener(() -> this.fireThumbnailChanged(null));
    }

    public void install(RootPaneContainer rootPane) {
        InputHandlerGlassPane glassPane = this.getInputHandlerGlassPane();
        rootPane.setGlassPane(glassPane);
        rootPane.setContentPane(this.renderComponent);
        glassPane.setVisible(true);
    }

    public void install(JComponent component) {
        component.setLayout(new BorderLayout());
        component.add((Component)this.renderComponent, "Center");
    }

    public void setDebugProgressMonitorFactory(DebugProgressMonitorFactory factory) {
        this.debugProgressMonitorFactory = factory;
    }

    public DebugProgressMonitorFactory getDebugProgressMonitorFactory() {
        return this.debugProgressMonitorFactory;
    }

    public Image getImage() {
        return this.renderComponent.getImage();
    }

    public ExecutorService getSingleThreadExecutorService() {
        return this.singleThreadExecutor;
    }

    public LabelInfoProvider getLabelCache() {
        return this.labelInfoCache;
    }

    public Rectangle getComponentBounds() {
        return this.renderComponent.getBounds();
    }

    public Point getComponentCenter() {
        Rectangle bounds = this.renderComponent.getBounds();
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        return new Point(centerX, centerY);
    }

    public NetworkPicker getPicker() {
        return this.picker;
    }

    public NetworkTransform getTransform() {
        return this.renderComponent.getTransform();
    }

    public GraphLOD getGraphLOD() {
        return this.dingGraphLOD;
    }

    private void timerCheckModelAndAnimate() {
        RenderDetailFlags flags;
        boolean modelDirty = this.viewModel.dirty(false);
        if (modelDirty) {
            boolean updated = this.updateModel();
            if (!updated) {
                return;
            }
            this.updateAnimationState();
            this.viewModel.dirty(true);
        }
        boolean paintEdges = this.advanceAnimatedEdges();
        if (modelDirty) {
            this.updateView(UpdateType.ALL_FULL, true);
        } else if (paintEdges && (flags = this.renderComponent.getLastFastRenderFlags()) != null && flags.renderEdges() != GraphLOD.RenderEdges.NONE) {
            this.updateView(UpdateType.JUST_EDGES);
        }
    }

    private void updateAnimationState() {
        if (this.viewModelSnapshot == null) {
            return;
        }
        Collection animatedEdges = this.viewModelSnapshot.getTrackedEdges(DingNetworkViewFactory.ANIMATED_EDGES);
        this.edgeDetails.updateAnimatedEdges(animatedEdges);
        this.animateEdges = !animatedEdges.isEmpty();
    }

    private boolean advanceAnimatedEdges() {
        if (this.animateEdges) {
            boolean advance;
            int trigger = 3;
            boolean bl = advance = this.animationCounter++ % trigger == 0;
            if (advance) {
                this.edgeDetails.advanceAnimatedEdges();
                return true;
            }
        }
        return false;
    }

    public void updateView(UpdateType updateType) {
        this.updateView(updateType, false);
    }

    public void updateView(UpdateType updateType, boolean contentChanged) {
        this.renderComponent.updateView(updateType);
        if (contentChanged) {
            this.fireContentChanged(updateType);
            this.cyAnnotator.getAnnotationSelection().getBounds();
        }
        if (!this.eventFireTimer.isShutdown()) {
            this.eventFireTimer.debounce(() -> this.eventHelper.fireEvent((CyEvent)new UpdateNetworkPresentationEvent(this.getViewModel())));
        }
    }

    private boolean updateModel() {
        CyNetworkViewSnapshot snapshot = this.viewModel.createSnapshot();
        if (snapshot == null) {
            return false;
        }
        this.viewModelSnapshot = snapshot;
        Paint backgroundPaint = (Paint)this.viewModelSnapshot.getVisualProperty(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT);
        this.renderComponent.setBackgroundPaint(backgroundPaint);
        boolean hd = (Boolean)this.viewModelSnapshot.getVisualProperty(DVisualLexicon.NETWORK_FORCE_HIGH_DETAIL);
        this.renderComponent.setLOD(hd ? DingGraphLODAll.instance() : this.dingGraphLOD);
        double x = (Double)this.viewModelSnapshot.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        double y = (Double)this.viewModelSnapshot.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        this.renderComponent.setCenter(x, y);
        double scaleFactor = (Double)this.viewModelSnapshot.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.renderComponent.setScaleFactor(scaleFactor);
        return true;
    }

    public Color getBackgroundColor() {
        return this.renderComponent.getBackgroundPaint();
    }

    public BendStore getBendStore() {
        return this.bendStore;
    }

    public synchronized InputHandlerGlassPane getInputHandlerGlassPane() {
        if (this.inputHandler == null) {
            this.inputHandler = new InputHandlerGlassPane(this.serviceRegistrar, this);
        }
        return this.inputHandler;
    }

    public JComponent getComponent() {
        return this.getInputHandlerGlassPane();
    }

    public NodeDetails getNodeDetails() {
        return this.nodeDetails;
    }

    public EdgeDetails getEdgeDetails() {
        return this.edgeDetails;
    }

    private void fireContentChanged(UpdateType updateType) {
        for (ContentChangeListener l : this.contentChangeListeners) {
            l.contentChanged(updateType);
        }
        this.fireThumbnailChanged(null);
    }

    public void addContentChangeListener(ContentChangeListener l) {
        this.contentChangeListeners.add(l);
    }

    public void removeContentChangeListener(ContentChangeListener l) {
        this.contentChangeListeners.remove(l);
    }

    public void addTransformChangeListener(TransformChangeListener l) {
        this.renderComponent.addTransformChangeListener(l);
    }

    public void removeTransformChangeListener(TransformChangeListener l) {
        this.renderComponent.removeTransformChangeListener(l);
    }

    public void addThumbnailChangeListener(ThumbnailChangeListener l) {
        this.thumbnailChangeListeners.add(l);
    }

    public void removeThumbnailChangeListener(ThumbnailChangeListener l) {
        this.thumbnailChangeListeners.remove(l);
    }

    void fireThumbnailChanged(Image image) {
        for (ThumbnailChangeListener l : this.thumbnailChangeListeners) {
            l.thumbnailChanged(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(double zoom) {
        DingLock dingLock = this.dingLock;
        synchronized (dingLock) {
            this.renderComponent.setScaleFactor(this.checkZoom(zoom, this.renderComponent.getTransform().getScaleFactor()));
        }
    }

    public double getZoom() {
        return this.renderComponent.getTransform().getScaleFactor();
    }

    public void handleFitContent() {
        if (!this.renderComponent.isInitialized()) {
            this.renderComponent.setInitializedCallback(() -> {
                this.renderComponent.setInitializedCallback(null);
                this.handleFitContent();
            });
            return;
        }
        this.handleFit(false);
    }

    public void handleFitSelected() {
        if (!this.renderComponent.isInitialized()) {
            this.renderComponent.setInitializedCallback(() -> {
                this.renderComponent.setInitializedCallback(null);
                this.handleFitSelected();
            });
            return;
        }
        this.handleFit(true);
    }

    private void computeNodeBounds(CyNetworkViewSnapshot netViewSnapshot, Collection<View<CyNode>> nodes, double[] buff) {
        NetworkSpacialIndex2D spacial = netViewSnapshot.getSpacialIndex2D();
        float[] extents = new float[4];
        float xMin = Float.POSITIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float xMax = Float.NEGATIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        for (View<CyNode> nodeView : nodes) {
            spacial.get((Object)nodeView.getSUID(), extents);
            if (extents[0] < xMin) {
                xMin = extents[0];
            }
            if (extents[2] > xMax) {
                xMax = extents[2];
            }
            yMin = Math.min(yMin, extents[1]);
            yMax = Math.max(yMax, extents[3]);
        }
        buff[0] = xMin;
        buff[1] = yMin;
        buff[2] = xMax;
        buff[3] = yMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFit(boolean justSelectedNodes) {
        this.eventHelper.flushPayloadEvents();
        DingLock dingLock = this.dingLock;
        synchronized (dingLock) {
            int visibleNodes;
            RenderDetailFlags flags;
            CyNetworkViewSnapshot netViewSnapshot = this.getViewModel().createSnapshot();
            if (netViewSnapshot == null || netViewSnapshot.getNodeCount() == 0) {
                return;
            }
            NetworkTransform transform = this.renderComponent.getTransform();
            if (transform.getWidth() == 0 || transform.getHeight() == 0) {
                return;
            }
            double[] extents = new double[4];
            NetworkSpacialIndex2D spacial = netViewSnapshot.getSpacialIndex2D();
            Collection selectedNodes = null;
            if (justSelectedNodes) {
                selectedNodes = netViewSnapshot.getTrackedNodes(DingNetworkViewFactory.SELECTED_NODES);
                if (selectedNodes.isEmpty()) {
                    return;
                }
                this.computeNodeBounds(netViewSnapshot, selectedNodes, extents);
            } else {
                spacial.getMBR(extents);
            }
            if (!justSelectedNodes) {
                this.cyAnnotator.adjustBoundsToIncludeAnnotations(extents);
            }
            if ((flags = RenderDetailFlags.create(netViewSnapshot, visibleNodes = justSelectedNodes ? selectedNodes.size() : netViewSnapshot.getNodeCount(), this.getGraphLOD())).all(2, 8, 2048)) {
                LabelInfoProvider labelCache = this.getLabelCache();
                NetworkPicker picker = this.getPicker();
                Iterable nodeIterable = justSelectedNodes ? selectedNodes : netViewSnapshot.getNodeViewsIterable();
                for (View node : nodeIterable) {
                    LabelSelection label = picker.getNodeLabelShape((View<CyNode>)node, labelCache);
                    if (label == null) continue;
                    Rectangle2D bounds = label.getShape().getBounds2D();
                    if (bounds.getMinX() < extents[0]) {
                        extents[0] = bounds.getMinX();
                    }
                    if (bounds.getMinY() < extents[1]) {
                        extents[1] = bounds.getMinY();
                    }
                    if (bounds.getMaxX() > extents[2]) {
                        extents[2] = bounds.getMaxX();
                    }
                    if (!(bounds.getMaxY() > extents[3])) continue;
                    extents[3] = bounds.getMaxY();
                }
            }
            netViewSnapshot.getMutableNetworkView().batch(netView -> {
                if (!netView.isValueLocked(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION)) {
                    netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)((extents[0] + extents[2]) / 2.0));
                }
                if (!netView.isValueLocked(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION)) {
                    netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)((extents[1] + extents[3]) / 2.0));
                }
                if (!netView.isValueLocked(BasicVisualLexicon.NETWORK_SCALE_FACTOR)) {
                    double zoom = Math.min((double)transform.getWidth() / (extents[2] - extents[0]), (double)transform.getHeight() / (extents[3] - extents[1])) * 0.98;
                    netView.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)zoom);
                }
            });
        }
    }

    public void handleUpdateView() {
        Boolean val = (Boolean)this.viewModel.getVisualProperty(DVisualLexicon.DUMMY);
        val = val == null ? Boolean.FALSE : val;
        this.viewModel.setVisualProperty(DVisualLexicon.DUMMY, (Object)(val == false ? 1 : 0));
    }

    public void zoomToCenter(int ticks) {
        int centerX = this.getTransform().getWidth() / 2;
        int centerY = this.getTransform().getHeight() / 2;
        this.zoomToPointer(ticks, centerX, centerY);
    }

    public void zoomToPointer(int ticks, int imageX, int imageY) {
        if (this.getViewModelSnapshot().isValueLocked(BasicVisualLexicon.NETWORK_SCALE_FACTOR)) {
            return;
        }
        double factor = DRenderingEngine.mouseWheelTicksToZoomFactor(ticks);
        if (factor == 1.0) {
            return;
        }
        NetworkTransform currentTransform = this.getTransform();
        double newScaleFactor = currentTransform.getScaleFactor() * factor;
        Point2D zoomPoint1 = currentTransform.getNodeCoordinates(imageX, imageY);
        NetworkTransform scaledTransform = new NetworkTransform(currentTransform);
        scaledTransform.setScaleFactor(newScaleFactor);
        Point2D zoomPoint2 = scaledTransform.getNodeCoordinates(imageX, imageY);
        double dx = zoomPoint1.getX() - zoomPoint2.getX();
        double dy = zoomPoint1.getY() - zoomPoint2.getY();
        double newCenterX = scaledTransform.getCenterX() + dx;
        double newCenterY = scaledTransform.getCenterY() + dy;
        this.renderComponent.setScaleFactorAndCenter(newScaleFactor, newCenterX, newCenterY);
        this.getViewModel().batch(netView -> {
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)newScaleFactor);
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)newCenterX);
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)newCenterY);
        }, false);
    }

    private static double mouseWheelTicksToZoomFactor(int ticks) {
        int maxSpeed = 3;
        ticks = Math.max(-3, Math.min(3, ticks));
        return 1.0 - (double)ticks * 0.1;
    }

    public Panner startPan() {
        return new Panner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenter(double x, double y) {
        DingLock dingLock = this.dingLock;
        synchronized (dingLock) {
            this.renderComponent.setCenter(x, y);
            this.updateCenterVPs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCenterVPs() {
        DingLock dingLock = this.dingLock;
        synchronized (dingLock) {
            this.getViewModel().batch(netView -> {
                NetworkTransform transform = this.renderComponent.getTransform();
                netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)transform.getCenterX());
                netView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)transform.getCenterY());
            }, false);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        if (page != 0) {
            return 1;
        }
        ((Graphics2D)g).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        NetworkTransform transform = new NetworkTransform(this.renderComponent.getTransform());
        transform.setDPIScaleFactor(1.0);
        double image_scale = Math.min(pageFormat.getImageableWidth() / (double)transform.getWidth(), pageFormat.getImageableHeight() / (double)transform.getHeight());
        if (image_scale < 1.0) {
            ((Graphics2D)g).scale(image_scale, image_scale);
        }
        g.clipRect(0, 0, this.renderComponent.getWidth(), this.renderComponent.getHeight());
        PrintLOD printLOD = new PrintLOD();
        CompositeGraphicsCanvas.paint((Graphics2D)g, this.getBackgroundColor(), printLOD, transform, this, false);
        return 0;
    }

    public void printCanvas(Graphics g, Map<String, String> props) {
        if (props == null) {
            props = Collections.emptyMap();
        }
        boolean exportAsShape = Boolean.parseBoolean(props.get("exportTextAsShape"));
        boolean transparent = Boolean.parseBoolean(props.get("exportTransparentBackground"));
        boolean hideLabels = Boolean.parseBoolean(props.get("exportHideLabels"));
        boolean highDetail = Boolean.parseBoolean(props.getOrDefault("highDetail", "true"));
        boolean pdf = Boolean.parseBoolean(props.get("pdf"));
        GraphLOD baseLOD = highDetail ? DingGraphLODAll.instance() : new DingGraphLOD(this.serviceRegistrar);
        PrintLOD printLOD = new PrintLOD(baseLOD, exportAsShape, !hideLabels);
        Color bg = transparent ? null : this.getBackgroundColor();
        NetworkTransform transform = new NetworkTransform(this.renderComponent.getTransform());
        transform.setDPIScaleFactor(1.0);
        CompositeGraphicsCanvas.paint((Graphics2D)g, bg, printLOD, transform, this, pdf);
    }

    public void printCanvas(Graphics g) {
        this.printCanvas(g, null);
    }

    public Image createImage(int width, int height) {
        return this.createImage(width, height, false);
    }

    private Image createImage(int width, int height, boolean transparentBackground) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height arguments must be greater than zero");
        }
        Future<Image> future = this.getSingleThreadExecutorService().submit(() -> {
            double[] extents = new double[4];
            this.getViewModelSnapshot().getSpacialIndex2D().getMBR(extents);
            this.cyAnnotator.adjustBoundsToIncludeAnnotations(extents);
            double xCenter = (extents[0] + extents[2]) / 2.0;
            double yCenter = (extents[1] + extents[3]) / 2.0;
            double zoom = Math.min((double)width / (extents[2] - extents[0]), (double)height / (extents[3] - extents[1])) * 0.98;
            NetworkTransform transform = new NetworkTransform(width, height, xCenter, yCenter, zoom);
            NetworkImageBuffer buffer = new NetworkImageBuffer(transform);
            Color bgColor = transparentBackground ? null : this.getBackgroundColor();
            CompositeGraphicsCanvas.paint(buffer.getGraphics(true), bgColor, this.dingGraphLOD, transform, this, false);
            return buffer.getImage();
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private double checkZoom(double zoom, double orig) {
        if (zoom > 0.0) {
            return zoom;
        }
        logger.debug("invalid zoom: " + zoom + "   using orig: " + orig);
        return orig;
    }

    public Printable createPrintable() {
        return this;
    }

    public DVisualLexicon getVisualLexicon() {
        return this.lexicon;
    }

    public CyNetworkViewSnapshot getViewModelSnapshot() {
        return this.viewModelSnapshot;
    }

    public CyNetworkView getViewModel() {
        return this.viewModel;
    }

    public <V> Icon createIcon(VisualProperty<V> vp, V value, int w, int h) {
        return VisualPropertyIconFactory.createIcon(value, vp, w, h);
    }

    protected TexturePaint getSnapshot(double width, double height) {
        if (!this.latestSnapshot) {
            this.snapshotImage = (BufferedImage)this.createImage(DEF_SNAPSHOT_SIZE, DEF_SNAPSHOT_SIZE, true);
            this.latestSnapshot = true;
        }
        int imageWidth = this.snapshotImage.getWidth();
        int imageHeight = this.snapshotImage.getHeight();
        double ratio = (double)imageHeight / (double)imageWidth;
        int adjustedWidth = (int)(width / ratio) + 1;
        Rectangle2D.Double rect = new Rectangle2D.Double(-adjustedWidth / 2, -height / 2.0, adjustedWidth, height);
        TexturePaint texturePaint = new TexturePaint(this.snapshotImage, rect);
        return texturePaint;
    }

    public CyAnnotator getCyAnnotator() {
        return this.cyAnnotator;
    }

    public LabelSelectionManager getLabelSelectionManager() {
        return this.labelSelectionManager;
    }

    public CyServiceRegistrar getServiceRegistrar() {
        return this.serviceRegistrar;
    }

    public void handleDispose() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DRenderingEngine dRenderingEngine = this;
        synchronized (dRenderingEngine) {
            if (this.inputHandler != null) {
                this.inputHandler.dispose();
            }
            this.modelAndAnimationTimer.stop();
            this.eventFireTimer.shutdown();
            this.cyAnnotator.dispose();
            this.serviceRegistrar.unregisterAllServices((Object)this.cyAnnotator);
            this.renderComponent.dispose();
        }
    }

    public String getRendererId() {
        return "org.cytoscape.ding";
    }

    public static enum UpdateType {
        ALL_FAST,
        ALL_FULL,
        JUST_ANNOTATIONS,
        JUST_EDGES;

    }

    public class Panner {
        private boolean panned = false;

        private Panner() {
        }

        public void continuePan(double dx, double dy) {
            if (!this.panned) {
                DRenderingEngine.this.renderComponent.startPan();
            }
            this.panned = true;
            NetworkTransform transform = DRenderingEngine.this.renderComponent.getTransform();
            double x = transform.getCenterX() + dx;
            double y = transform.getCenterY() + dy;
            DRenderingEngine.this.renderComponent.setCenter(x, y);
            DRenderingEngine.this.updateView(UpdateType.ALL_FAST);
        }

        public void endPan() {
            if (this.panned) {
                DRenderingEngine.this.renderComponent.endPan();
                DRenderingEngine.this.updateCenterVPs();
                DRenderingEngine.this.updateView(UpdateType.ALL_FULL);
            }
        }
    }
}

