/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.cytoscape.cg.util.CustomGraphicsIcon;
import org.cytoscape.ding.DArrowShape;
import org.cytoscape.ding.DNodeShape;
import org.cytoscape.ding.icon.ArrowIcon;
import org.cytoscape.ding.icon.ColorIcon;
import org.cytoscape.ding.icon.EdgeBendIcon;
import org.cytoscape.ding.icon.EdgeStackingIcon;
import org.cytoscape.ding.icon.FontFaceIcon;
import org.cytoscape.ding.icon.NodeIcon;
import org.cytoscape.ding.icon.ObjectPositionIcon;
import org.cytoscape.ding.icon.StrokeIcon;
import org.cytoscape.ding.icon.TextIcon;
import org.cytoscape.ding.icon.VisualPropertyIcon;
import org.cytoscape.ding.impl.DLineType;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.LabelBackgroundShapeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.LabelBackgroundShape;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.NodeShape;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public final class VisualPropertyIconFactory {
    public static <V> Icon createIcon(V value, int w, int h) {
        return VisualPropertyIconFactory.createIcon(value, null, w, h);
    }

    public static <V> Icon createIcon(V value, VisualProperty<V> vp, int w, int h) {
        if (value == null) {
            return null;
        }
        VisualPropertyIcon icon = null;
        if (value instanceof Color) {
            Color color = (Color)value;
            icon = new ColorIcon(color, w, h, value.toString());
        } else if (value instanceof NodeShape) {
            NodeShape shape = (NodeShape)value;
            DNodeShape dShape = NodeShapeVisualProperty.isDefaultShape((NodeShape)shape) ? DNodeShape.getDShape(shape) : (DNodeShape)shape;
            icon = new NodeIcon(dShape.getShape(), w, h, dShape.getDisplayName());
        } else if (value instanceof LabelBackgroundShape) {
            LabelBackgroundShape shape = (LabelBackgroundShape)value;
            DNodeShape dShape = DNodeShape.getDShape(shape);
            icon = dShape != null ? new NodeIcon(dShape.getShape(), w, h, dShape.getDisplayName()) : new TextIcon(LabelBackgroundShapeVisualProperty.NONE, w, h, "");
        } else if (value instanceof LineType) {
            LineType line = (LineType)value;
            icon = new StrokeIcon(DLineType.getDLineType(line).getStroke(2.0f), w, h, value.toString());
        } else if (value instanceof CyCustomGraphics) {
            CyCustomGraphics graphics = (CyCustomGraphics)value;
            String name = graphics.getDisplayName();
            icon = new CustomGraphicsIcon(graphics, w, h, name);
        } else if (value instanceof ObjectPosition) {
            ObjectPosition op = (ObjectPosition)value;
            icon = new ObjectPositionIcon(op, (ObjectPositionVisualProperty)vp, w, h, "Label");
        } else if (value instanceof Font) {
            Font font = (Font)value;
            icon = new FontFaceIcon(font, w, h, "");
        } else if (value instanceof ArrowShape) {
            DArrowShape dShape;
            ArrowShape arrowShape = (ArrowShape)value;
            DArrowShape dArrowShape = dShape = ArrowShapeVisualProperty.isDefaultShape((ArrowShape)arrowShape) ? DArrowShape.getArrowShape(arrowShape) : DArrowShape.NONE;
            icon = dShape.getShape() == null ? new TextIcon(value, w, h, "") : new ArrowIcon(dShape, w, h);
        } else if (value instanceof Bend) {
            Bend bend = (Bend)value;
            icon = new EdgeBendIcon(bend, w, h, value.toString());
        } else if (value instanceof EdgeStacking) {
            EdgeStacking es = (EdgeStacking)value;
            icon = new EdgeStackingIcon(es, w, h, value.toString());
        } else {
            icon = new TextIcon(value, w, h, value.toString());
        }
        return icon;
    }

    private VisualPropertyIconFactory() {
    }
}

