/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.cytoscape.ding.icon.VisualPropertyIcon;

public class NodeIcon
extends VisualPropertyIcon<Shape> {
    private static final long serialVersionUID = 1202339876280466L;
    private static final Stroke BASIC_STROKE = new BasicStroke(2.0f);
    private Shape newShape;
    private Graphics2D g2d;

    public NodeIcon(Shape shape, int width, int height, String name) {
        super(shape, width, height, name);
        this.adjustShape();
    }

    private void adjustShape() {
        double shapeWidth = ((Shape)this.value).getBounds2D().getWidth();
        double shapeHeight = ((Shape)this.value).getBounds2D().getHeight();
        double xRatio = (double)this.width / shapeWidth;
        double yRatio = (double)this.height / shapeHeight;
        AffineTransform af = new AffineTransform();
        af.setToScale(xRatio, yRatio);
        this.newShape = af.createTransformedShape((Shape)this.value);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.g2d = (Graphics2D)g;
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.translate(x, y);
        this.g2d.setColor(c.getForeground());
        this.g2d.setStroke(BASIC_STROKE);
        this.g2d.draw(this.newShape);
        this.g2d.translate(-x, -y);
    }

    public NodeIcon clone() {
        NodeIcon cloned = new NodeIcon((Shape)this.value, this.width, this.height, this.name);
        return cloned;
    }
}

