/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import org.cytoscape.ding.icon.VisualPropertyIcon;
import org.cytoscape.view.presentation.property.values.Bend;

public class EdgeBendIcon
extends VisualPropertyIcon<Bend> {
    private static final long serialVersionUID = 3321774231185088226L;
    private static final Stroke EDGE_STROKE = new BasicStroke(2.0f, 2, 0);
    private static final int FONT_SIZE = 16;
    private static final Font FONT = new Font("SansSerif", 1, 16);
    private static final Color NUMBER_COLOR = new Color(100, 100, 100, 90);

    public EdgeBendIcon(Bend value, int width, int height, String name) {
        super(value, width, height, name);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        g2d.setStroke(EDGE_STROKE);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Integer handles = ((Bend)this.value).getAllHandles().size();
        double x1 = 0.0;
        double y1 = (double)this.height / 2.0;
        double x2 = x1 + (double)this.width;
        double y2 = y1;
        if (handles == 0) {
            g2d.draw(new Line2D.Double(x1, y1, x2, y2));
        } else {
            double ww = this.width * 3 / 4;
            CubicCurve2D.Double curvedLine = new CubicCurve2D.Double(x1, y1, ww, y1 + (double)this.height, (double)this.width - ww, y2 - (double)this.height, x2, y2);
            g2d.draw(curvedLine);
            Font original = g2d.getFont();
            if (this.value != null) {
                g2d.setColor(NUMBER_COLOR);
                g2d.setFont(FONT);
                g2d.drawString(handles.toString(), (int)((double)this.width - ww - 4.0), this.height / 2);
            }
            g2d.setFont(original);
        }
        g2d.translate(-x, -y);
    }
}

