/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import org.cytoscape.ding.DArrowShape;
import org.cytoscape.ding.icon.VisualPropertyIcon;
import org.cytoscape.view.presentation.property.values.ArrowShape;

public class ArrowIcon
extends VisualPropertyIcon<DArrowShape> {
    private static final long serialVersionUID = 1202339877462891L;
    private static final int MIN_EDGE_LENGTH = 4;
    private static final int MIN_EDGE_WIDTH = 1;
    private static final int MIN_ARROW_BORDER_WIDTH = 2;

    public ArrowIcon(DArrowShape dArrowShape, int width, int height) {
        super(dArrowShape, width, height, dArrowShape.getDisplayName());
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double w = this.width;
        double h = this.height;
        double x1 = x;
        double y1 = (double)y + h / 2.0;
        double x2 = x1 + w;
        double y2 = y1;
        float edgeWidth = Math.max((float)this.height / 10.0f, 1.0f);
        Color fg = ArrowIcon.getForeground(c);
        if (this.value == null) {
            this.drawEdge(edgeWidth, fg, g2d, x1, y1, x2, y2);
        } else {
            ArrowShape arrowShape = ((DArrowShape)((Object)this.value)).getPresentationShape();
            Shape shape = ((DArrowShape)((Object)this.value)).getShape();
            Rectangle2D bounds = shape.getBounds2D();
            AffineTransform af = new AffineTransform();
            double minx = bounds.getMinX();
            double miny = bounds.getMinY();
            if (minx < 0.0) {
                af.setToTranslation(Math.abs(minx), 0.0);
                shape = af.createTransformedShape(shape);
            }
            if (miny < 0.0) {
                af.setToTranslation(0.0, Math.abs(miny));
                shape = af.createTransformedShape(shape);
            }
            bounds = shape.getBounds2D();
            double sw = bounds.getWidth();
            double sh = bounds.getHeight() * 2.0;
            double maxArrowHeight = this.maxArrowHeight(bounds);
            double maxArrowWidth = this.maxArrowWidth(bounds);
            if (this.isSquaredShape()) {
                maxArrowHeight = maxArrowWidth = Math.min(maxArrowHeight, maxArrowWidth);
            }
            double originalXYRatio = sw / sh;
            double xRatio = maxArrowWidth / sw;
            double yRatio = maxArrowHeight / sh;
            af.setToScale(xRatio * originalXYRatio, yRatio);
            shape = af.createTransformedShape(shape);
            bounds = shape.getBounds2D();
            af.setToTranslation(x2 - bounds.getWidth(), this.yTranslation(y2, bounds));
            shape = af.createTransformedShape(shape);
            bounds = shape.getBounds2D();
            x2 = this.xIntersection(bounds);
            this.drawEdge(edgeWidth, fg, g2d, x1, y1, x2, y2);
            this.drawArrow(shape, arrowShape.isFilled(), edgeWidth, fg, c.getBackground(), g2d);
        }
    }

    private void drawEdge(float edgeWidth, Color fg, Graphics2D g2d, double x1, double y1, double x2, double y2) {
        fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 128);
        g2d.setColor(fg);
        g2d.setStroke(new BasicStroke(edgeWidth, 2, 0));
        g2d.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    private void drawArrow(Shape shape, boolean filled, float edgeWidth, Color fg, Color bg, Graphics2D g2d) {
        if (filled) {
            g2d.setColor(fg);
            g2d.fill(shape);
        } else {
            float borderWidth = Math.max(edgeWidth / 2.0f, 2.0f);
            g2d.setColor(bg);
            g2d.fill(shape);
            g2d.setColor(fg);
            g2d.setStroke(new BasicStroke(borderWidth, 2, 0));
            g2d.draw(shape);
        }
    }

    private boolean isSquaredShape() {
        return this.value == DArrowShape.SQUARE || this.value == DArrowShape.OPEN_SQUARE || this.value == DArrowShape.CIRCLE || this.value == DArrowShape.OPEN_CIRCLE || this.value == DArrowShape.HALF_CIRCLE || this.value == DArrowShape.OPEN_HALF_CIRCLE;
    }

    private double maxArrowWidth(Rectangle2D bounds) {
        double w = this.width;
        double ratio = this.width / this.height;
        if (ratio <= 1.1) {
            w = Math.max((double)this.height, w);
        } else if (ratio >= 3.0) {
            w /= 3.0;
        } else if (ratio >= 2.0) {
            w /= 2.0;
        }
        return w -= 4.0;
    }

    private double maxArrowHeight(Rectangle2D bounds) {
        double h = this.height;
        double ratio = this.width / this.height;
        if (ratio <= 1.1) {
            h = Math.min(this.height, this.width);
        }
        return h;
    }

    private double yTranslation(double y2, Rectangle2D bounds) {
        double ty = y2 - bounds.getHeight() / 2.0;
        if (this.value == DArrowShape.HALF_TOP) {
            return ty - bounds.getHeight() / 2.0;
        }
        if (this.value == DArrowShape.HALF_BOTTOM) {
            return ty + bounds.getHeight() / 2.0;
        }
        return ty;
    }

    private double xIntersection(Rectangle2D bounds) {
        double x = this.value == DArrowShape.ARROW || this.value == DArrowShape.ARROW_SHORT ? bounds.getMinX() : (this.value == DArrowShape.HALF_TOP || this.value == DArrowShape.HALF_BOTTOM ? bounds.getCenterX() + (bounds.getMaxX() - bounds.getCenterX()) / 2.0 : bounds.getCenterX() - 2.0);
        return x;
    }

    private static Color getForeground(Component c) {
        Color fg = c.getForeground();
        if (fg == null) {
            fg = UIManager.getColor("Label.foreground");
        }
        return fg;
    }
}

