/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;

public class SettingsPanel
extends BasicCollapsiblePanel {
    private final CyServiceRegistrar registrar;
    private final CyProperty<Properties> cyProps;
    private final DebounceTimer debounceTimer = new DebounceTimer();
    private List<PropEditor> props;
    private JButton cacheStatsButton;

    public SettingsPanel(CyServiceRegistrar registrar) {
        super("Settings");
        this.registrar = registrar;
        this.cyProps = (CyProperty)registrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.createContents();
    }

    private void createContents() {
        this.props = Arrays.asList(new NumberPropEditor("render.coarseDetailThreshold", "coarseDetailThreshold"), new NumberPropEditor("render.nodeBorderThreshold", "nodeBorderThreshold"), new NumberPropEditor("render.nodeLabelThreshold", "nodeLabelThreshold"), new NumberPropEditor("render.edgeArrowThreshold", "edgeArrowThreshold"), new NumberPropEditor("render.edgeLabelThreshold", "edgeLabelThreshold"), new BooleanPropEditor("render.edgeBufferPan", "edgeBufferPan"), new BooleanPropEditor("render.labelCache", "labelCache"), new BooleanPropEditor("render.selectedOnly", "selectedOnly"), new BooleanPropEditor("render.hidpi", "hidpi"));
        this.cacheStatsButton = new JButton("show stats");
        this.cacheStatsButton.addActionListener(e -> this.showCacheStats());
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.cacheStatsButton});
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        GroupLayout.ParallelGroup horizontalLabelGroup = layout.createParallelGroup();
        GroupLayout.ParallelGroup horizontalEditorGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        for (PropEditor prop : this.props) {
            horizontalLabelGroup.addComponent(prop.getLabel());
            horizontalEditorGroup.addComponent(prop.getEditor());
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(prop.getLabel()).addComponent(prop.getEditor(), -2, -2, -2));
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(horizontalLabelGroup).addGroup(horizontalEditorGroup).addGroup(layout.createParallelGroup().addComponent(this.cacheStatsButton)));
        layout.setVerticalGroup(verticalGroup);
        verticalGroup.addComponent(this.cacheStatsButton);
        JPanel content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("West", panel);
    }

    public void update() {
        this.props.forEach(PropEditor::update);
    }

    private void showCacheStats() {
        DingRenderer renderer = (DingRenderer)this.registrar.getService(DingRenderer.class);
        CyApplicationManager appManager = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        CyNetworkView netView = appManager.getCurrentNetworkView();
        if (netView == null) {
            return;
        }
        DRenderingEngine re = renderer.getRenderingEngine(netView);
        LabelInfoProvider labelCache = re.getLabelCache();
        String stats = labelCache.getStats();
        JOptionPane.showMessageDialog((Component)((Object)this), stats);
    }

    private void setProperty(String propName, String value) {
        ((Properties)this.cyProps.getProperties()).setProperty(propName, value);
        CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new PropertyUpdatedEvent(this.cyProps));
    }

    private static interface PropEditor {
        public JComponent getLabel();

        public JComponent getEditor();

        public void update();
    }

    private class NumberPropEditor
    implements PropEditor,
    ChangeListener {
        private final String propName;
        private final SpinnerNumberModel model;
        private final JLabel label;
        private final JSpinner spinner;

        public NumberPropEditor(String propName, String labelText) {
            this.propName = propName;
            this.label = new JLabel(labelText);
            int value = this.getPropValue();
            this.model = new SpinnerNumberModel(value, 0, 1000000, 100);
            this.spinner = new JSpinner(this.model);
            this.spinner.addChangeListener(this);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.label, this.spinner});
        }

        @Override
        public JComponent getLabel() {
            return this.label;
        }

        @Override
        public JComponent getEditor() {
            return this.spinner;
        }

        @Override
        public void update() {
            this.spinner.removeChangeListener(this);
            this.model.setValue(this.getPropValue());
            this.spinner.addChangeListener(this);
        }

        private int getPropValue() {
            return Integer.parseInt(((Properties)SettingsPanel.this.cyProps.getProperties()).getProperty(this.propName));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SettingsPanel.this.debounceTimer.debounce(() -> {
                int v = this.model.getNumber().intValue();
                SettingsPanel.this.setProperty(this.propName, Integer.toString(v));
            });
        }
    }

    private class BooleanPropEditor
    implements PropEditor,
    ActionListener {
        private final String propName;
        private final JLabel label;
        private final JCheckBox checkBox;

        public BooleanPropEditor(String propName, String labelText) {
            this.propName = propName;
            this.label = new JLabel(labelText);
            this.checkBox = new JCheckBox();
            boolean value = this.getPropValue();
            this.checkBox.setSelected(value);
            this.checkBox.addActionListener(this);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.label, this.checkBox});
        }

        @Override
        public JComponent getLabel() {
            return this.label;
        }

        @Override
        public JComponent getEditor() {
            return this.checkBox;
        }

        @Override
        public void update() {
            this.checkBox.removeActionListener(this);
            this.checkBox.setSelected(this.getPropValue());
            this.checkBox.addActionListener(this);
        }

        private boolean getPropValue() {
            return Boolean.valueOf(((Properties)SettingsPanel.this.cyProps.getProperties()).getProperty(this.propName));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.debounceTimer.debounce(() -> {
                boolean v = this.checkBox.isSelected();
                SettingsPanel.this.setProperty(this.propName, String.valueOf(v));
            });
        }
    }
}

