/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.ding.debug.NetworkViewportPanel;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class NetworkInfoPanel
extends BasicCollapsiblePanel {
    private final Supplier<DRenderingEngine> reSupplier;
    private JLabel networkNameLabel;
    private JLabel edgeCountLabel;
    private JLabel transformViewLabel;
    private JLabel selectedNodeLabel;
    private NetworkViewportPanel viewportPanel;

    public NetworkInfoPanel(Supplier<DRenderingEngine> reSupplier) {
        super("Network View and Transform");
        this.reSupplier = reSupplier;
        this.createContents();
    }

    private void createContents() {
        this.networkNameLabel = new JLabel();
        this.transformViewLabel = new JLabel();
        this.viewportPanel = new NetworkViewportPanel();
        this.edgeCountLabel = new JLabel();
        this.selectedNodeLabel = new JLabel();
        this.clear();
        JButton countButton = new JButton("Count Visible Nodes/Edges");
        countButton.addActionListener(e -> this.countNodesEdges());
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.edgeCountLabel, this.selectedNodeLabel, countButton});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.transformViewLabel});
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.networkNameLabel).addComponent(this.viewportPanel).addComponent(this.transformViewLabel).addComponent(this.selectedNodeLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(countButton).addComponent(this.edgeCountLabel)));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.networkNameLabel).addComponent(this.viewportPanel, GroupLayout.Alignment.CENTER).addComponent(this.transformViewLabel).addComponent(this.selectedNodeLabel).addGroup(layout.createSequentialGroup().addComponent(countButton).addComponent(this.edgeCountLabel)));
        JPanel content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("West", panel);
    }

    public void clear() {
        this.networkNameLabel.setText("-none-");
        this.transformViewLabel.setText("");
        this.viewportPanel.clear();
        this.edgeCountLabel.setText("");
        this.selectedNodeLabel.setText("Selected Node - none");
    }

    public void updateTransform(NetworkTransform t) {
        this.transformViewLabel.setText(String.format("Viewport - w:%d h:%d", t.getWidth(), t.getHeight()));
        this.viewportPanel.updateTransform(t);
    }

    public void setNetworkName(String name) {
        this.networkNameLabel.setText(name == null ? "-none-" : name);
    }

    private void countNodesEdges() {
        Object text = "-";
        DRenderingEngine re = this.reSupplier.get();
        if (re != null) {
            int[] counts = RenderDetailFlags.countNodesEdges(re);
            int nodeCount = counts[0];
            int edgeCount = counts[1];
            text = "nodes: " + nodeCount + ", edges: " + edgeCount;
        }
        this.edgeCountLabel.setText((String)text);
    }

    public void setSelectedNodesInfo(int nodeCount) {
        if (nodeCount == 0) {
            this.selectedNodeLabel.setText("Selected Node - none");
        } else {
            this.selectedNodeLabel.setText("Selected Node - " + nodeCount + " nodes selected");
        }
    }

    public void setSingleNode(double x, double y, double w, double h) {
        this.selectedNodeLabel.setText("Selected Node - " + String.format("(x:%.2f, y:%.2f, w:%.2f, h:%.2f)", x, y, w, h));
    }
}

