/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugRootFrameInfo;
import org.cytoscape.ding.debug.FrameListTablePanel;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class FrameListPanel
extends BasicCollapsiblePanel {
    private FrameListTablePanel fastPanel;
    private FrameListTablePanel slowPanel;
    private FrameListTablePanel fastBirdPanel;
    private FrameListTablePanel slowBirdPanel;

    public FrameListPanel() {
        super("Individual Frames");
        this.createContents();
    }

    private void createContents() {
        this.fastPanel = new FrameListTablePanel("Main Fast (on EDT)");
        this.slowPanel = new FrameListTablePanel("Main Slow (Async)");
        this.fastBirdPanel = new FrameListTablePanel("Birds-Eye-View Fast (on EDT)");
        this.slowBirdPanel = new FrameListTablePanel("Birds-Eye-View Slow (Async)");
        int w = 200;
        int h = 200;
        this.fastPanel.setPreferredSize(new Dimension(200, 200));
        this.slowPanel.setPreferredSize(new Dimension(200, 200));
        this.fastBirdPanel.setPreferredSize(new Dimension(200, 200));
        this.slowBirdPanel.setPreferredSize(new Dimension(200, 200));
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(e -> this.clear());
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{clearButton});
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.fastPanel).addComponent(this.slowPanel)).addGroup(layout.createParallelGroup().addComponent(this.fastBirdPanel).addComponent(this.slowBirdPanel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(clearButton)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.fastPanel, -2, -2, Short.MAX_VALUE).addComponent(this.fastBirdPanel, -2, -2, Short.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(this.slowPanel, -2, -2, Short.MAX_VALUE).addComponent(this.slowBirdPanel, -2, -2, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(clearButton)));
        JPanel content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("Center", panel);
    }

    public void clear() {
        this.fastPanel.clear();
        this.slowPanel.clear();
        this.fastBirdPanel.clear();
        this.slowBirdPanel.clear();
    }

    private FrameListTablePanel getPanel(DebugFrameType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case MAIN_ANNOTAITONS: 
            case MAIN_EDGES: 
            case MAIN_SELECTED: 
            case MAIN_FAST: {
                return this.fastPanel;
            }
            case MAIN_SLOW: {
                return this.slowPanel;
            }
            case BEV_ANNOTAITONS: 
            case BEV_FAST: {
                return this.fastBirdPanel;
            }
            case BEV_SLOW: {
                return this.slowBirdPanel;
            }
        }
        return null;
    }

    public void addFrame(DebugRootFrameInfo frame) {
        ViewUtil.invokeOnEDT(() -> {
            if (frame.getType() != null) {
                this.getPanel(frame.getType()).addFrame(frame);
            }
        });
    }
}

