/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.ding.debug.FrameListPanel;
import org.cytoscape.ding.debug.FrameRatePanel;
import org.cytoscape.ding.debug.NetworkInfoPanel;
import org.cytoscape.ding.debug.SettingsPanel;
import org.cytoscape.ding.debug.ThumbnailPanel;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;

public class DingDebugPanel
extends JPanel
implements CytoPanelComponent {
    private DRenderingEngine re;
    private NetworkInfoPanel networkInfoPanel = new NetworkInfoPanel(() -> this.re);
    private SettingsPanel settingsPanel;
    private FrameRatePanel frameRatePanel;
    private FrameListPanel frameListPanel;
    private ThumbnailPanel thumbnailPanel;

    public DingDebugPanel(CyServiceRegistrar registrar) {
        this.networkInfoPanel.setCollapsed(false);
        this.settingsPanel = new SettingsPanel(registrar);
        this.settingsPanel.setCollapsed(true);
        this.frameRatePanel = new FrameRatePanel();
        this.frameRatePanel.setCollapsed(false);
        this.frameListPanel = new FrameListPanel();
        this.frameListPanel.setCollapsed(true);
        this.thumbnailPanel = new ThumbnailPanel(registrar);
        this.thumbnailPanel.setCollapsed(true);
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.networkInfoPanel)).addComponent((Component)((Object)this.settingsPanel)).addComponent((Component)((Object)this.frameRatePanel)).addComponent((Component)((Object)this.frameListPanel)).addComponent((Component)((Object)this.thumbnailPanel)).addGap(0, 500, Short.MAX_VALUE));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)((Object)this.networkInfoPanel)).addComponent((Component)((Object)this.settingsPanel)).addComponent((Component)((Object)this.frameRatePanel)).addComponent((Component)((Object)this.frameListPanel)).addComponent((Component)((Object)this.thumbnailPanel)));
        JScrollPane scrollPane = new JScrollPane(panel, 22, 31);
        this.setLayout(new BorderLayout());
        this.add("Center", scrollPane);
    }

    public NetworkInfoPanel getNetworkInfoPanel() {
        return this.networkInfoPanel;
    }

    public SettingsPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    public FrameListPanel getFrameListPanel() {
        return this.frameListPanel;
    }

    public FrameRatePanel getFrameRatePanel() {
        return this.frameRatePanel;
    }

    public ThumbnailPanel getThumbnailPanel() {
        return this.thumbnailPanel;
    }

    public void clear() {
        this.networkInfoPanel.clear();
        this.frameListPanel.clear();
    }

    public void setRenderingEngine(DRenderingEngine re) {
        this.re = re;
        if (re != null) {
            CyNetworkView netView = re.getViewModel();
            CyNetwork model = (CyNetwork)netView.getModel();
            String name = (String)model.getRow((CyIdentifiable)model).get("name", String.class);
            this.networkInfoPanel.setNetworkName(name);
        } else {
            this.networkInfoPanel.setNetworkName(null);
        }
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public String getTitle() {
        return "Ding Debug";
    }

    public Icon getIcon() {
        return null;
    }
}

