/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugProgressMonitor;
import org.cytoscape.ding.debug.DebugProgressMonitorCallback;
import org.cytoscape.ding.debug.DebugRootFrameInfo;
import org.cytoscape.ding.debug.DebugSubProgressMonitor;
import org.cytoscape.ding.impl.canvas.CompositeImageCanvas;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;

public class DebugRootProgressMonitor
implements DebugProgressMonitor {
    private final ProgressMonitor delegate;
    private final DebugProgressMonitorCallback callback;
    private final DebugFrameType type;
    private List<DebugSubProgressMonitor> subMonitors = Collections.emptyList();
    private long start;
    private long end;
    private String taskName;
    private RenderDetailFlags flags;
    private CompositeImageCanvas.PaintParameters paintParams;

    public DebugRootProgressMonitor(DebugFrameType type, ProgressMonitor delegate, DebugProgressMonitorCallback callback) {
        this.type = type;
        this.delegate = ProgressMonitor.notNull(delegate);
        this.callback = callback;
    }

    @Override
    public void start(String taskName) {
        this.taskName = taskName;
        this.start = System.currentTimeMillis();
        this.delegate.start(taskName);
    }

    @Override
    public void done() {
        this.delegate.done();
    }

    public void done(RenderDetailFlags flags, CompositeImageCanvas.PaintParameters paintParams) {
        this.end = System.currentTimeMillis();
        this.flags = flags;
        this.paintParams = paintParams;
        this.done();
        if (this.callback != null) {
            this.callback.addFrame(DebugRootFrameInfo.fromProgressMonitor(this));
        }
    }

    @Override
    public ProgressMonitor[] split(double ... parts) {
        this.subMonitors = new ArrayList<DebugSubProgressMonitor>(parts.length);
        return DebugProgressMonitor.super.split(parts);
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public ProgressMonitor createSubProgressMonitor(double percent) {
        DebugSubProgressMonitor sub = new DebugSubProgressMonitor(this, percent);
        this.subMonitors.add(sub);
        return sub;
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public void addProgress(double progress) {
        this.delegate.addProgress(progress);
    }

    @Override
    public List<DebugSubProgressMonitor> getSubMonitors() {
        return this.subMonitors;
    }

    public DebugFrameType getType() {
        return this.type;
    }

    public RenderDetailFlags getRenderDetailFlags() {
        return this.flags;
    }

    public CompositeImageCanvas.PaintParameters getPaintParametsr() {
        return this.paintParams;
    }

    public long getStartTime() {
        return this.start;
    }

    public long getEndTime() {
        return this.end;
    }

    @Override
    public long getTime() {
        return this.end - this.start;
    }
}

