/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.cytoscape.ding.debug.DebugFrameInfo;
import org.cytoscape.ding.debug.DebugFrameType;
import org.cytoscape.ding.debug.DebugRootProgressMonitor;
import org.cytoscape.ding.debug.DebugUtil;
import org.cytoscape.ding.impl.canvas.CompositeImageCanvas;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;

public class DebugRootFrameInfo
extends DebugFrameInfo {
    private static AtomicInteger frameCounter = new AtomicInteger();
    private final DebugFrameType type;
    private final boolean cancelled;
    private final int frameNumber;
    private final long start;
    private final long end;
    private final RenderDetailFlags flags;
    private final CompositeImageCanvas.PaintParameters paintParams;

    private DebugRootFrameInfo(String task, long start, long end, DebugFrameType type, boolean cancelled, RenderDetailFlags flags, CompositeImageCanvas.PaintParameters paintParams, List<DebugFrameInfo> subFrames) {
        super(task, end - start, subFrames);
        this.type = type;
        this.cancelled = cancelled;
        this.flags = flags;
        this.paintParams = paintParams;
        this.start = start;
        this.end = end;
        this.frameNumber = frameCounter.incrementAndGet();
    }

    public DebugFrameType getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.start;
    }

    public long getEndTime() {
        return this.end;
    }

    public RenderDetailFlags getRenderDetailFlags() {
        return this.flags;
    }

    public CompositeImageCanvas.PaintParameters getPaintParameters() {
        return this.paintParams;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public static DebugRootFrameInfo fromProgressMonitor(DebugRootProgressMonitor pm) {
        DebugFrameType type = pm.getType();
        boolean cancelled = pm.isCancelled();
        long start = pm.getStartTime();
        long end = pm.getEndTime();
        RenderDetailFlags flags = pm.getRenderDetailFlags();
        CompositeImageCanvas.PaintParameters paintParams = pm.getPaintParametsr();
        String task = pm.getTaskName();
        List<DebugFrameInfo> subInfos = DebugUtil.map(pm.getSubMonitors(), x -> DebugRootFrameInfo.fromSubPM(x));
        return new DebugRootFrameInfo(task, start, end, type, cancelled, flags, paintParams, subInfos);
    }
}

