/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.ding.ObjectPlacerControl;
import org.cytoscape.ding.ObjectPlacerGraphic;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyValueEditor;

public class ObjectPositionValueEditor
implements VisualPropertyValueEditor<ObjectPosition> {
    private static final String TITLE = "Position";
    private ObjectPosition oldValue;
    private boolean canceled;
    private JDialog dialog;
    private ObjectPlacerGraphic graphic;
    private ObjectPlacerControl control;

    public <S extends ObjectPosition> ObjectPosition showEditor(Component parent, S initialValue, VisualProperty<S> vp) {
        ObjectPosition pos;
        if (initialValue == null) {
            this.oldValue = null;
            pos = new ObjectPosition();
        } else {
            this.oldValue = initialValue;
            pos = new ObjectPosition(initialValue);
        }
        this.dialog = this.createDialog(parent, pos, (ObjectPositionVisualProperty)vp);
        if (parent != null) {
            this.dialog.setLocationRelativeTo(parent);
        } else {
            this.dialog.setLocationByPlatform(true);
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.canceled) {
            this.canceled = false;
            return this.oldValue;
        }
        return this.control.getPosition();
    }

    public Class<ObjectPosition> getValueType() {
        return ObjectPosition.class;
    }

    private JDialog createDialog(Component parent, ObjectPosition pos, ObjectPositionVisualProperty vp) {
        Window owner = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        final JDialog dialog = new JDialog(owner, Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setTitle(vp != null ? vp.getDisplayName() : TITLE);
        dialog.setResizable(false);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ObjectPositionValueEditor.this.cancel();
            }
        });
        this.graphic = new ObjectPlacerGraphic(pos, vp, true);
        this.control = new ObjectPlacerControl(pos, vp);
        this.graphic.addPropertyChangeListener(this.control);
        this.control.addPropertyChangeListener(this.graphic);
        JPanel graphicPanel = new JPanel();
        graphicPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        graphicPanel.setLayout(new BorderLayout());
        graphicPanel.add(this.graphic);
        JButton okButton = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        okButton.addActionListener(this.control);
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPositionValueEditor.this.cancel();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okButton, (JButton)cancelButton);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)dialog.getRootPane(), (Action)okButton.getAction(), (Action)cancelButton.getAction());
        dialog.getRootPane().setDefaultButton(okButton);
        GroupLayout layout = new GroupLayout(dialog.getContentPane());
        dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(graphicPanel).addComponent(this.control).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(graphicPanel).addComponent(this.control).addComponent(buttonPanel));
        return dialog;
    }

    private void cancel() {
        this.canceled = true;
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

